/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomContextMenu;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidgetSkin;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Skin;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;

public class HyperlinkWidget
extends Hyperlink
implements HasViewState {
    private String defaultText;
    final ReadOnlyBooleanWrapper truncated = new ReadOnlyBooleanWrapper();
    private final ViewState viewState = new ViewState();

    public HyperlinkWidget() {
        this.getStyleClass().addAll((Object[])new String[]{"hyperlink-widget", "simple-widget"});
        this.textProperty().addListener((obj, oldValue, newValue) -> {
            if (TextUtil.isBlank((String)this.defaultText) || !TextUtil.isBlank((String)newValue)) {
                return;
            }
            this.setText(this.defaultText);
        });
        this.truncated.addListener((s, o, n) -> {
            if (n.booleanValue() && !TextUtil.isBlank((String)this.getText())) {
                this.setTooltip(new Tooltip(this.getText()));
            } else {
                this.setTooltip(null);
            }
        });
        this.setOnContextMenuRequested(evt -> {
            CustomContextMenu menu = new CustomContextMenu();
            CustomMenuItem item = new CustomMenuItem(Messages.General_Copy_text);
            item.setOnAction(evt2 -> Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, this.getText())));
            menu.getItems().add((Object)item);
            menu.show((Node)this, evt.getScreenX(), evt.getScreenY());
        });
        this.viewState.stateProperty().addListener((s, o, n) -> this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, ViewState.isImmutable(n.intValue())));
    }

    public ReadOnlyBooleanProperty truncatedProperty() {
        return this.truncated.getReadOnlyProperty();
    }

    public boolean isTruncated() {
        return this.truncated.get();
    }

    public void setDefaultText(String value) {
        this.defaultText = value;
        if (!TextUtil.isBlank((String)this.defaultText) && TextUtil.isBlank((String)this.getText())) {
            this.setText(this.defaultText);
        }
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    protected Skin<?> createDefaultSkin() {
        return new HyperlinkWidgetSkin(this);
    }
}

