/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.sun.javafx.scene.control.skin.HyperlinkSkin;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Labeled;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;

class HyperlinkWidgetSkin
extends HyperlinkSkin {
    private static final double HEIGHT_GAP = 1.0;
    private final Region underline = new Region();

    HyperlinkWidgetSkin(Hyperlink link) {
        super(link);
        this.underline.getStyleClass().add((Object)"xtrip-underline");
        this.updateChildren();
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.underline != null) {
            this.getChildren().add((Object)this.underline);
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        Hyperlink hyperlink = (Hyperlink)this.getNode();
        double computedWidth = UiUtil.computeTextBounds((Labeled)hyperlink).getWidth();
        double underlineWidth = Math.ceil(Math.min(computedWidth, w));
        double underlineHeight = Math.ceil(hyperlink.getBaselineOffset() + 1.0);
        this.underline.resize(underlineWidth, underlineHeight);
        this.positionInArea((Node)this.underline, hyperlink.getPadding().getLeft() + UiUtil.computeXOffset(w, underlineWidth, HPos.LEFT), hyperlink.getPadding().getTop() + UiUtil.computeYOffset(h, underlineHeight, VPos.CENTER), underlineWidth, underlineHeight, 0.0, hyperlink.getAlignment().getHpos(), hyperlink.getAlignment().getVpos());
        for (Node node : this.getChildren()) {
            ReadOnlyBooleanWrapper truncatedWrapper;
            if (!(node instanceof Text)) continue;
            String fullText = ((Hyperlink)this.getSkinnable()).getText();
            boolean truncated = fullText != null && !fullText.equals(((Text)node).getText());
            if (truncated == (truncatedWrapper = ((HyperlinkWidget)this.getSkinnable()).truncated).get()) {
                truncatedWrapper.set(!truncated);
            }
            truncatedWrapper.set(truncated);
            break;
        }
    }
}

