/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.standard.helpers.HttpHelper;
import com.gridnine.xtrip.common.model.system.BinaryData;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;

public class ImageWidget
extends StackPane
implements HasViewState {
    protected final ObjectProperty<BinaryData> data = new SimpleObjectProperty();
    protected final ImageView imageView;
    protected final ViewState viewState = new ViewState();
    private String fieldName;
    private ControlsPane controlsPanel;
    private Label controlsLabel;
    private Consumer<FileChooser> fileChooserConfigurator;
    private Predicate<File> fileFilter;
    private List<String> supportedExtensions = Arrays.asList(".jpg", ".jpeg", ".gif", ".png");
    private Consumer<File> fileLoader = file -> {
        try {
            BinaryData bd = new BinaryData();
            bd.setData(Files.readAllBytes(file.toPath()));
            bd.setContentType(HttpHelper.detectContentType((String)file.getName()));
            this.setData(bd);
        }
        catch (IOException ioe) {
            ErrorHandler.handle(ioe);
        }
    };

    public ImageWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().add((Object)"image-widget");
        this.getStyleClass().add((Object)"simple-widget");
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.setMinHeight(Double.NEGATIVE_INFINITY);
        this.widthProperty().addListener(obj -> this.configureImageView());
        this.imageView = new ImageView();
        this.imageView.setPreserveRatio(true);
        this.imageView.setManaged(false);
        this.imageView.imageProperty().addListener(obj -> this.configureImageView());
        this.prefHeightProperty().bind((ObservableValue)new DoubleBinding(){
            {
                this.bind(new Observable[]{ImageWidget.this.imageView.boundsInLocalProperty()});
            }

            protected double computeValue() {
                double height = ImageWidget.this.imageView.getBoundsInLocal().getHeight();
                return height < 40.0 ? 40.0 : height;
            }
        });
        this.getChildren().add((Object)this.imageView);
        this.data.addListener((src, o, n) -> {
            this.imageView.setImage(n == null || n.getData() == null ? null : new Image((InputStream)new ByteArrayInputStream(n.getData())));
            this.pseudoClassStateChanged(Styles.EMPTY_PSEUDOCLASS, n == null);
        });
        this.pseudoClassStateChanged(Styles.EMPTY_PSEUDOCLASS, true);
        this.configureDnD();
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    private void configureDnD() {
        this.setOnDragOver(evt -> {
            evt.consume();
            if (this.viewState.isImmutable()) {
                return;
            }
            if (evt.getGestureSource() == this) {
                return;
            }
            if (!evt.getDragboard().hasFiles()) {
                return;
            }
            for (File file : evt.getDragboard().getFiles()) {
                for (String ext : this.supportedExtensions) {
                    if (!file.getName().toLowerCase().endsWith(ext)) continue;
                    evt.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                    return;
                }
            }
        });
        this.setOnDragDropped(evt -> {
            evt.consume();
            if (this.viewState.isImmutable()) {
                return;
            }
            if (!evt.getDragboard().hasFiles()) {
                return;
            }
            for (File file : evt.getDragboard().getFiles()) {
                for (String ext : this.supportedExtensions) {
                    if (!file.getName().toLowerCase().endsWith(ext)) continue;
                    this.fileLoader.accept(file);
                    evt.setDropCompleted(true);
                    return;
                }
            }
        });
    }

    private void configureImageView() {
        if (this.imageView.getImage() == null) {
            return;
        }
        double imageWidth = this.imageView.getImage().getWidth();
        double nodeWidth = this.getWidth();
        if (nodeWidth > imageWidth) {
            this.imageView.setFitWidth(0.0);
        } else {
            this.imageView.setFitWidth(nodeWidth);
        }
        this.requestLayout();
    }

    public ObjectProperty<BinaryData> dataProperty() {
        return this.data;
    }

    public BinaryData getData() {
        return (BinaryData)this.data.get();
    }

    public void setData(BinaryData value) {
        this.data.set((Object)value);
    }

    public Image getImage() {
        return this.imageView.getImage();
    }

    public void setFieldName(String value) {
        this.fieldName = value;
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    private void updateState() {
        boolean disabled = this.viewState.isImmutable();
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, disabled);
        if (disabled) {
            if (this.controlsLabel != null) {
                this.getChildren().remove((Object)this.controlsLabel);
                this.controlsLabel = null;
            }
        } else if (this.controlsLabel == null) {
            this.controlsLabel = new Label(Messages.General_Choose_file_img);
            this.getChildren().add(0, (Object)this.controlsLabel);
        }
        if (this.controlsPanel == null) {
            this.controlsPanel = new ControlsPane();
            UiUtil.setTooltip((Node)this.controlsPanel.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)evt -> this.selectImage()), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                {
                    this.bind(new Observable[]{ImageWidget.this.viewState.stateProperty()});
                }

                protected boolean computeValue() {
                    return ImageWidget.this.viewState.isImmutable();
                }
            }), Messages.General_Choose_img);
            UiUtil.setTooltip((Node)this.controlsPanel.addButton(ControlsPane.ButtonType.REMOVE, (EventHandler<? super MouseEvent>)((EventHandler)evt -> this.data.set(null)), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                {
                    this.bind(new Observable[]{ImageWidget.this.viewState.stateProperty(), ImageWidget.this.data});
                }

                protected boolean computeValue() {
                    return ImageWidget.this.viewState.isImmutable() || ImageWidget.this.data.get() == null;
                }
            }), Messages.General_Clean_img);
            UiUtil.setTooltip((Node)this.controlsPanel.addButton(ControlsPane.ButtonType.DOWNLOAD, (EventHandler<? super MouseEvent>)((EventHandler)evt -> this.saveImage()), (ObservableValue<? extends Boolean>)Bindings.isNull(this.data)), Messages.General_save_image);
            StackPane.setAlignment((Node)this.controlsPanel, (Pos)Pos.CENTER);
            this.controlsPanel.setMaxHeight(Double.NEGATIVE_INFINITY);
            this.controlsPanel.setMinHeight(Double.NEGATIVE_INFINITY);
            this.controlsPanel.setMaxWidth(Double.NEGATIVE_INFINITY);
            this.controlsPanel.setPrefHeight(-1.0);
            this.getChildren().add((Object)this.controlsPanel);
        }
    }

    public void setFileChooserConfigurator(Consumer<FileChooser> value) {
        this.fileChooserConfigurator = value;
    }

    public void setFileFilter(Predicate<File> value) {
        this.fileFilter = value;
    }

    public void setSupportedExtensions(String ... exts) {
        this.supportedExtensions = Arrays.asList(exts);
    }

    public void setFileLoader(Consumer<File> value) {
        this.fileLoader = Objects.requireNonNull(value);
    }

    private void selectImage() {
        File file;
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(Messages.General_Files_img, this.supportedExtensions.stream().map(ext -> '*' + ext).collect(Collectors.toList())));
        chooser.setTitle(this.fieldName);
        File dir = ClientSettings.get().getFileChooserDirectory();
        if (UiUtil.isFileValid(dir) && dir.isDirectory()) {
            chooser.setInitialDirectory(dir);
        } else {
            chooser.setInitialDirectory(Environment.getDataFolder());
        }
        if (this.fileChooserConfigurator != null) {
            this.fileChooserConfigurator.accept(chooser);
        }
        if ((file = chooser.showOpenDialog(this.getScene().getWindow())) == null) {
            return;
        }
        ClientSettings.get().setFileChooserDirectory(file.getParentFile());
        ClientSettings.get().save();
        if (this.fileFilter != null && !this.fileFilter.test(file)) {
            return;
        }
        this.fileLoader.accept(file);
    }

    private void saveImage() {
        FileChooser chooser = new FileChooser();
        String ext = "*.*";
        if (((BinaryData)this.data.get()).getContentType() != null) {
            switch (((BinaryData)this.data.get()).getContentType()) {
                case GIF: {
                    ext = "*.gif";
                    break;
                }
                case JPEG: {
                    ext = "*.jpeg";
                    break;
                }
                case PNG: {
                    ext = "*.png";
                    break;
                }
                case ICO: {
                    ext = "*.ico";
                    break;
                }
                case SVG: {
                    ext = "*.svg";
                    break;
                }
            }
        }
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(Messages.General_Files_img, new String[]{ext}));
        chooser.setTitle(this.fieldName);
        File dir = ClientSettings.get().getFileChooserDirectory();
        if (UiUtil.isFileValid(dir) && dir.isDirectory()) {
            chooser.setInitialDirectory(dir);
        } else {
            chooser.setInitialDirectory(Environment.getDataFolder());
        }
        File file = chooser.showSaveDialog(this.getScene().getWindow());
        if (file == null) {
            return;
        }
        ClientSettings.get().setFileChooserDirectory(file.getParentFile());
        ClientSettings.get().save();
        FxUtil.saveToFile(file, ((BinaryData)this.data.get()).getData());
    }
}

