/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PasswordFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.StrengthIndicator;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.model.standard.helpers.PasswordHelper;
import com.sun.javafx.scene.control.behavior.TextFieldBehavior;
import com.sun.javafx.scene.control.skin.TextFieldSkin;
import java.util.Arrays;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;

class PasswordFieldSkin
extends TextFieldSkin {
    private static final PseudoClass REVEALED_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"revealed");
    private static final char STAR_CHARACTER = '*';
    private static final String TOOLTIP_SHOW_PASSWORD = Messages.General_Show_password;
    private static final String TOOLTIP_HIDE_PASSWORD = Messages.General_Hide_password;
    private final AnchorPane anchor = new AnchorPane();
    private final Button starButton;
    private boolean revealed = false;
    private StrengthIndicator strengthIndicator;

    PasswordFieldSkin(PasswordFieldWidget widget, PasswordField passwordField) {
        super((TextField)passwordField, new TextFieldBehavior((TextField)passwordField));
        this.getChildren().add((Object)this.anchor);
        this.starButton = new Button();
        this.starButton.setFocusTraversable(false);
        this.starButton.setOnAction(evt -> {
            this.revealed = !this.revealed;
            this.starButton.pseudoClassStateChanged(REVEALED_PSEUDOCLASS, this.revealed);
            UiUtil.setTooltip((Node)this.starButton, this.revealed ? TOOLTIP_HIDE_PASSWORD : TOOLTIP_SHOW_PASSWORD);
            this.repaint();
        });
        this.starButton.minWidthProperty().bind((ObservableValue)this.anchor.heightProperty());
        this.starButton.getStyleClass().add((Object)"xtrip-star-button");
        UiUtil.setTooltip((Node)this.starButton, this.revealed ? TOOLTIP_HIDE_PASSWORD : TOOLTIP_SHOW_PASSWORD);
        this.starButton.setGraphic((Node)new IconNode(StandardIconShapes.STAR, (Styleable)this.starButton, StandardIconIntentions.STAR, (Styleable)this.starButton));
        AnchorPane.setTopAnchor((Node)this.starButton, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.starButton, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.starButton, (Double)0.0);
        this.anchor.getChildren().add((Object)this.starButton);
        widget.showStrengthIndicator.addListener((s, o, n) -> this.updateStrengthIndicator((boolean)n));
        this.updateStrengthIndicator(widget.showStrengthIndicator.get());
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        double fullHeight = h + this.snappedTopInset() + this.snappedBottomInset();
        double fullWidth = w + this.snappedLeftInset() + this.snappedRightInset();
        this.anchor.relocate(0.0, 0.0);
        this.anchor.resize(fullWidth, fullHeight);
        if (this.strengthIndicator != null && this.getChildren().contains((Object)this.strengthIndicator)) {
            this.strengthIndicator.relocate(0.0, fullHeight + 4.0);
            this.strengthIndicator.resize(fullWidth, 5.0);
        }
    }

    protected String maskText(String txt) {
        if (this.revealed) {
            return txt;
        }
        char[] stars = new char[txt.length()];
        Arrays.fill(stars, '*');
        return new String(stars);
    }

    private void repaint() {
        String text = ((TextField)this.getSkinnable()).getText();
        ((TextField)this.getSkinnable()).setText("*");
        ((TextField)this.getSkinnable()).setText(text);
    }

    private void updateStrengthIndicator(boolean visible) {
        if (!visible) {
            if (this.strengthIndicator != null) {
                this.getChildren().remove((Object)this.strengthIndicator);
            }
        } else {
            if (this.strengthIndicator == null) {
                this.strengthIndicator = new StrengthIndicator();
                Tooltip.install((Node)this.strengthIndicator, (Tooltip)new Tooltip(Messages.General_Password_hack_indicator));
                ((TextField)this.getSkinnable()).textProperty().addListener((s, o, n) -> this.strengthIndicator.setStrength(PasswordHelper.calculatePasswordStrength((String)n)));
            }
            if (!this.getChildren().contains((Object)this.strengthIndicator)) {
                this.getChildren().add((Object)this.strengthIndicator);
            }
        }
        this.repaint();
    }
}

