/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.lib.widgets.BaseNumberWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DoubleValueWidget;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import javafx.util.StringConverter;

public class PriceValueWidget
extends BaseNumberWidget<BigDecimal> {
    public PriceValueWidget(boolean readonly) {
        super(readonly);
    }

    @Override
    protected StringConverter<BigDecimal> createConverter() {
        return new StringConverter<BigDecimal>(){
            private final DecimalFormat nf;
            {
                LocaleManager lm = LocaleManager.get();
                this.nf = lm.getLocaleData(lm.getCurrentLocale()).getPriceFormat();
                this.nf.setParseBigDecimal(true);
            }

            public String toString(BigDecimal object) {
                return object == null ? "" : this.nf.format(object);
            }

            public BigDecimal fromString(String string) {
                BigDecimal result;
                if (string == null) {
                    return null;
                }
                String str = string.trim();
                if (str.isEmpty()) {
                    return null;
                }
                Number obj = DoubleValueWidget.parseAsNumber(this.nf, str);
                BigDecimal bigDecimal = result = obj instanceof BigDecimal ? (BigDecimal)obj : BigDecimal.valueOf(obj.doubleValue());
                if (result.scale() > this.nf.getMaximumFractionDigits()) {
                    result = result.setScale(this.nf.getMaximumFractionDigits(), this.nf.getRoundingMode());
                }
                return result;
            }
        };
    }
}

