/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomToggleButton;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class RadioBoxWidget<T>
extends StackPane
implements HasViewState,
HasValue<T> {
    private Supplier<List<T>> itemsSupplier = () -> Collections.emptyList();
    private Predicate<T> disabledItemChecker = item -> false;
    private final ViewState viewState = new ViewState();
    private StringConverter<T> converter = StandardRenderers.GENERIC.createStatefulConverter(this.viewState::isImmutable);
    private final ObjectProperty<T> val = new SimpleObjectProperty();
    private final GridPane buttonsPane = new GridPane();
    private final Label valueLabel = new CustomLabel();

    public RadioBoxWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"radio-box-widget", "simple-widget"});
        this.val.addListener((obj, oldValue, newValue) -> {
            for (Node node : this.buttonsPane.getChildren()) {
                CustomToggleButton button = (CustomToggleButton)node;
                button.setSelected(MiscUtil.equals((Object)newValue, (Object)button.getUserData()));
            }
            this.valueLabel.setText(this.converter.toString(newValue));
        });
        this.getChildren().addAll((Object[])new Node[]{this.buttonsPane, this.valueLabel});
        this.valueLabel.getStyleClass().add((Object)"value-label");
        this.valueLabel.setText(this.converter.toString(null));
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public void setItemsSupplier(Supplier<List<T>> value) {
        this.itemsSupplier = Objects.requireNonNull(value);
        this.updateButtons();
    }

    public void setDisabledItemChecker(Predicate<T> value) {
        this.disabledItemChecker = Objects.requireNonNull(value);
        for (Node node : this.buttonsPane.getChildren()) {
            CustomToggleButton button = (CustomToggleButton)node;
            button.setDisable(this.disabledItemChecker.test(button.getUserData()));
        }
    }

    public void setConverter(StringConverter<T> value) {
        this.converter = Objects.requireNonNull(value);
        for (Node node : this.buttonsPane.getChildren()) {
            CustomToggleButton button = (CustomToggleButton)node;
            button.setText(this.converter.toString(button.getUserData()));
        }
        this.valueLabel.setText(this.converter.toString(this.val.get()));
    }

    @Override
    public ObjectProperty<T> valueProperty() {
        return this.val;
    }

    public T getValue() {
        return (T)this.valueProperty().getValue();
    }

    public void setValue(T value) {
        this.valueProperty().setValue(value);
    }

    private void updateState() {
        this.valueLabel.setVisible(this.viewState.isImmutable());
        this.buttonsPane.setVisible(!this.valueLabel.isVisible());
        if (this.buttonsPane.getChildren().isEmpty()) {
            this.updateButtons();
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.valueLabel.isVisible());
    }

    private void updateButtons() {
        this.buttonsPane.getChildren().clear();
        this.buttonsPane.getColumnConstraints().clear();
        if (this.viewState.isImmutable()) {
            return;
        }
        List<T> items = this.itemsSupplier.get();
        ArrayList<ColumnConstraints> constraints = new ArrayList<ColumnConstraints>(items.size());
        ArrayList<CustomToggleButton> buttons = new ArrayList<CustomToggleButton>(items.size());
        double colWidth = 100.0 / (double)items.size();
        ToggleGroup toggleGroup = new ToggleGroup();
        int idx = 0;
        for (T item : items) {
            ColumnConstraints cc = new ColumnConstraints();
            cc.setPercentWidth(colWidth);
            constraints.add(cc);
            CustomToggleButton button = new CustomToggleButton(this.converter.toString(item));
            GridPane.setConstraints((Node)button, (int)idx, (int)0);
            button.setMaxWidth(Double.MAX_VALUE);
            button.setToggleGroup(toggleGroup);
            if (idx == 0) {
                button.getStyleClass().add((Object)"left-button");
            } else if (idx == items.size() - 1) {
                button.getStyleClass().add((Object)"right-button");
            }
            button.setDisable(this.disabledItemChecker.test(item));
            button.setUserData(item);
            button.setSelected(MiscUtil.equals((Object)this.val.get(), item));
            button.selectedProperty().addListener(this::updateValue);
            int buttonIndex = idx++;
            button.selectedProperty().addListener((obj, o, n) -> {
                if (buttonIndex > 0) {
                    ((CustomToggleButton)((Object)((Object)buttons.get(buttonIndex - 1)))).pseudoClassStateChanged(CustomToggleButton.TO_THE_LEFT_FROM_SELECTED, (boolean)n);
                }
            });
            button.hoverProperty().addListener((obj, o, n) -> {
                if (buttonIndex > 0) {
                    ((CustomToggleButton)((Object)((Object)buttons.get(buttonIndex - 1)))).pseudoClassStateChanged(CustomToggleButton.TO_THE_LEFT_FROM_HOVER, n != false && !button.isSelected());
                }
            });
            buttons.add(button);
        }
        this.buttonsPane.getColumnConstraints().addAll(constraints);
        this.buttonsPane.getChildren().addAll(buttons);
    }

    private void updateValue(Object src) {
        for (Node node : this.buttonsPane.getChildren()) {
            CustomToggleButton button = (CustomToggleButton)node;
            if (!button.isSelected()) continue;
            this.val.set(button.getUserData());
        }
    }
}

