/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.lib.components.ClearableTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class SimpleObjectWidget<T>
extends StackPane
implements HasViewState,
HasValue<T> {
    private final SimpleObjectProperty<T> value = new SimpleObjectProperty();
    StringConverter<T> converter;
    private Label readonlyLabel;
    private ClearableTextField textField;
    private String proptText;
    private final ViewState viewState = new ViewState();
    T defaultValue;
    private boolean ignoreValueChange;
    private boolean touched;

    public SimpleObjectWidget(boolean ro, StringConverter<T> cvrtr) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"simple-object-widget", "simple-widget"});
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.converter = Objects.requireNonNull(cvrtr);
        this.value.addListener(evt -> {
            if (this.ignoreValueChange) {
                return;
            }
            this.renderValue();
            this.touched = false;
        });
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    public void requestFocus() {
        if (this.textField != null) {
            this.textField.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    @Override
    public ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public void setDefaultValue(T val) {
        this.defaultValue = val;
        if (this.value.get() == null && this.defaultValue != null) {
            this.value.set(val);
        }
    }

    public T getValue() {
        return (T)this.value.get();
    }

    public void setValue(T val) {
        this.value.set(val);
    }

    public void setConverter(StringConverter<T> val) {
        this.converter = Objects.requireNonNull(val);
        this.renderValue();
    }

    public void setPromptText(String val) {
        this.proptText = val;
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            this.textField = null;
            if (this.readonlyLabel == null) {
                this.readonlyLabel = new CustomLabel();
                this.readonlyLabel.getStyleClass().add((Object)"value-label");
                this.getChildren().setAll((Object[])new Node[]{this.readonlyLabel});
            }
        } else {
            this.readonlyLabel = null;
            if (this.textField == null) {
                this.textField = new ClearableTextField(){

                    @Override
                    protected boolean isEmpty() {
                        return super.isEmpty() || MiscUtil.equals(SimpleObjectWidget.this.getValue(), SimpleObjectWidget.this.defaultValue);
                    }

                    public void clear() {
                        this.deselect();
                        SimpleObjectWidget.this.valueProperty().set(SimpleObjectWidget.this.defaultValue);
                        this.setText(SimpleObjectWidget.this.defaultValue == null ? null : SimpleObjectWidget.this.converter.toString(SimpleObjectWidget.this.defaultValue));
                    }
                };
                this.textField.focusedProperty().addListener((s, o, n) -> {
                    if (!this.touched) {
                        return;
                    }
                    try {
                        this.ignoreValueChange = true;
                        Object val = this.converter.fromString(this.textField.getText());
                        if (val == null) {
                            this.value.set(null);
                            if (this.textField != null) {
                                this.textField.setText(this.defaultValue == null ? null : this.converter.toString(this.defaultValue));
                            }
                        } else {
                            this.value.set(val);
                            if (this.textField != null) {
                                this.textField.setText(this.converter.toString(val));
                            }
                        }
                    }
                    catch (Exception e) {
                        UiUtil.blink((Node)this.textField);
                        this.value.set(this.defaultValue);
                        if (this.textField != null) {
                            this.textField.setText(this.defaultValue == null ? null : this.converter.toString(this.defaultValue));
                        }
                    }
                    finally {
                        this.ignoreValueChange = false;
                    }
                });
                this.textField.textProperty().addListener((s, o, n) -> {
                    if (this.ignoreValueChange) {
                        return;
                    }
                    try {
                        this.ignoreValueChange = true;
                        this.touched = true;
                        Object val = this.converter.fromString(n);
                        if (val == null) {
                            this.value.set(this.defaultValue);
                        } else {
                            this.value.set(val);
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        this.ignoreValueChange = false;
                    }
                });
                this.getChildren().setAll((Object[])new Node[]{this.textField});
            }
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
        this.renderValue();
    }

    private void renderValue() {
        Object val = this.value.get();
        String promptText = this.proptText == null ? (this.viewState.isImmutable() ? "\u2014" : UiUtil.NULL_TEXT) : this.proptText;
        if (this.readonlyLabel != null) {
            this.readonlyLabel.setText(val == null ? promptText : this.converter.toString(val));
        } else {
            this.ignoreValueChange = true;
            try {
                this.textField.setText(this.converter.toString(val));
                this.textField.setPromptText(promptText);
            }
            finally {
                this.ignoreValueChange = false;
            }
        }
    }
}

