/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Suppliers {
    public static final Supplier<List<String>> ALL_CURRENCIES = () -> new ArrayList(Currency.getAvailableCurrencies().stream().map(Currency::getCurrencyCode).collect(Collectors.toList()));
    public static final Supplier<List<Locale>> ALL_LOCALES = () -> {
        HashMap<String, Locale> map = new HashMap<String, Locale>();
        for (Locale locale : Locale.getAvailableLocales()) {
            if (Locale.ROOT.equals(locale)) continue;
            Locale loc = (Locale)map.get(locale.getLanguage());
            if (loc == null) {
                map.put(locale.getLanguage(), locale);
                continue;
            }
            if (!TextUtil.isBlank((String)loc.getCountry()) && TextUtil.isBlank((String)locale.getCountry())) {
                map.put(locale.getLanguage(), locale);
                continue;
            }
            if (TextUtil.isBlank((String)loc.getVariant()) || !TextUtil.isBlank((String)locale.getVariant())) continue;
            map.put(locale.getLanguage(), locale);
        }
        map.put(LocaleUtil.LOCALE_KK.getLanguage(), LocaleUtil.LOCALE_KK);
        return new ArrayList(map.values());
    };
    public static final Supplier<List<Locale>> SUPPORTED_LOCALES = () -> LocaleManager.get().getSupportedLocales().stream().map(ld -> ld.getLocale()).collect(Collectors.toList());
    public static final Supplier<List<TimeZone>> ALL_TIME_ZONES = () -> Arrays.stream(TimeZone.getAvailableIDs()).map(id -> TimeZone.getTimeZone(id)).collect(Collectors.toList());
    public static final Supplier<List<Boolean>> TRUE_FALSE = () -> Arrays.asList(Boolean.FALSE, Boolean.TRUE);

    public static <E extends Enum<E>> Supplier<List<E>> createEnumSupplier(Class<E> cls) {
        return Suppliers.createEnumSupplier(cls, item -> true);
    }

    public static <E extends Enum<E>> Supplier<List<E>> createEnumSupplier(Class<E> cls, Predicate<E> filter) {
        return () -> Stream.of(cls.getEnumConstants()).filter(filter).collect(Collectors.toList());
    }

    private Suppliers() {
    }
}

