/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidgetColumn;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.function.Function;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class ActionColumn<T>
extends BigTableWidgetColumn<T, String> {
    private final Function<T, String> getter;
    private final Callback<TableColumn<T, String>, TableCell<T, String>> cellFactory = column -> new HyperlinkWidgetCell();
    protected EventHandler<ColumnActionEvent<T>> actionHandler;

    public ActionColumn(Function<T, String> aGetter) {
        this.getter = aGetter;
    }

    public void setActionHandler(EventHandler<ColumnActionEvent<T>> value) {
        this.actionHandler = value;
    }

    @Override
    protected String getCellValue(T row) {
        return this.getter.apply(row);
    }

    @Override
    protected void setCellValue(T row, String value) {
    }

    @Override
    protected boolean isCellValueChanged(T row, String value) {
        return false;
    }

    @Override
    protected Callback<TableColumn<T, String>, TableCell<T, String>> getCellFactory() {
        return this.cellFactory;
    }

    class HyperlinkWidgetCell
    extends TableCell<T, String> {
        private HyperlinkWidget widget;

        HyperlinkWidgetCell() {
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || TextUtil.isBlank((String)item)) {
                this.setText(null);
                this.setGraphic(null);
                return;
            }
            if (this.widget == null) {
                this.widget = new HyperlinkWidget();
                this.widget.setOnAction(evt -> {
                    if (ActionColumn.this.actionHandler == null) {
                        return;
                    }
                    ActionColumn.this.actionHandler.handle(new ColumnActionEvent<Object>(this.widget, ActionColumn.this.getRowData(this.getIndex())));
                });
            }
            this.widget.setText(item);
            this.setGraphic((Node)this.widget);
        }
    }

    public static class ColumnActionEvent<T>
    extends ActionEvent {
        private static final long serialVersionUID = 8526457409326624105L;
        private final T item;

        ColumnActionEvent(Object src, T gridItem) {
            super(src, Event.NULL_SOURCE_TARGET);
            this.item = gridItem;
        }

        public T getItem() {
            return this.item;
        }
    }
}

