/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column;

import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class ComboBoxColumn<T, S>
extends BigTableWidgetColumn<T, S> {
    private final Function<T, S> getter;
    private final BiConsumer<T, S> setter;
    private Supplier<List<S>> itemsSupplier = Collections::emptyList;
    private StringConverter<S> editConverter = StandardRenderers.GENERIC.createConverter();
    private StringConverter<S> viewConverter = StandardRenderers.GENERIC.createConverter(() -> "\u2014");
    private boolean sortItems = true;
    private boolean noNulls;
    private String promptText = UiUtil.NULL_TEXT;
    private Consumer<S> navigationHandler;
    private final Callback<TableColumn<T, S>, TableCell<T, S>> cellFactory = column -> new ComboBoxWidgetCell();

    public ComboBoxColumn(Function<T, S> aGetter, BiConsumer<T, S> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    @Override
    protected S getCellValue(T row) {
        return this.getter.apply(row);
    }

    @Override
    protected void setCellValue(T row, S value) {
        this.setter.accept(row, value);
    }

    @Override
    protected boolean isCellValueChanged(T row, S value) {
        return !MiscUtil.equals(value, this.getter.apply(row));
    }

    @Override
    protected Callback<TableColumn<T, S>, TableCell<T, S>> getCellFactory() {
        return this.cellFactory;
    }

    public void setItemsSupplier(Supplier<List<S>> itemsSupplier) {
        this.itemsSupplier = itemsSupplier;
    }

    public void setEditConverter(StringConverter<S> editConverter) {
        this.editConverter = editConverter;
    }

    public void setViewConverter(StringConverter<S> viewConverter) {
        this.viewConverter = viewConverter;
    }

    public void setSortItems(boolean sortItems) {
        this.sortItems = sortItems;
    }

    public void setNoNulls(boolean noNulls) {
        this.noNulls = noNulls;
    }

    public void setPromptText(String promptText) {
        this.promptText = promptText;
    }

    public void setNavigationHandler(Consumer<S> navigationHandler) {
        this.navigationHandler = navigationHandler;
    }

    class ComboBoxWidgetCell
    extends TableCell<T, S> {
        private final PseudoClass EDITING_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"editing");
        private CustomLabel viewWidget;
        private ComboBoxWidget<S> editWidget;

        ComboBoxWidgetCell() {
            this.setOnKeyPressed(Event::consume);
        }

        public void startEdit() {
            if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable())) {
                return;
            }
            super.startEdit();
            if (this.isEditing()) {
                if (this.editWidget == null) {
                    this.editWidget = new ComboBoxWidget(false);
                    this.editWidget.setItemsSupplier(ComboBoxColumn.this.itemsSupplier);
                    this.editWidget.setConverter(ComboBoxColumn.this.editConverter);
                    this.editWidget.setSortItems(ComboBoxColumn.this.sortItems);
                    this.editWidget.setNoNulls(ComboBoxColumn.this.noNulls);
                    this.editWidget.setPromptText(ComboBoxColumn.this.promptText);
                    this.editWidget.setNavigationHandler(ComboBoxColumn.this.navigationHandler);
                    this.editWidget.valueProperty().addListener((s, o, n) -> {
                        this.setItem(n);
                        this.fireEvent();
                    });
                    this.editWidget.setOnKeyReleased(evt -> {
                        if (evt.getCode() == KeyCode.ESCAPE) {
                            this.editWidget.setValue(this.getItem());
                            this.cancelEdit();
                            evt.consume();
                        }
                    });
                    this.editWidget.focusedProperty().addListener((src, o, n) -> {
                        if (!n.booleanValue() && this.isEditing()) {
                            this.commitEdit(this.editWidget.getValue());
                        } else if (!n.booleanValue() && o.booleanValue()) {
                            this.fireEvent();
                        }
                        this.pseudoClassStateChanged(this.EDITING_PSEUDOCLASS, this.isEditing());
                    });
                }
                this.editWidget.setValue(this.getItem());
                this.setGraphic((Node)this.editWidget);
                this.editWidget.requestFocus();
            }
            this.getStyleClass().remove((Object)"edited");
        }

        public void cancelEdit() {
            super.cancelEdit();
            if (this.viewWidget == null) {
                this.viewWidget = new CustomLabel();
            }
            this.viewWidget.setText(ComboBoxColumn.this.editConverter.toString(this.getItem()));
            this.setGraphic((Node)this.viewWidget);
        }

        protected void updateItem(S item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setGraphic(null);
                return;
            }
            if (this.isEditing()) {
                if (this.editWidget != null) {
                    this.editWidget.setValue(this.getItem());
                }
                this.setGraphic((Node)this.editWidget);
            } else {
                if (this.viewWidget == null) {
                    this.viewWidget = new CustomLabel();
                }
                this.viewWidget.setText(ComboBoxColumn.this.viewConverter.toString(item));
                this.setGraphic((Node)this.viewWidget);
            }
        }

        private void fireEvent() {
            TableView tableView = this.getTableView();
            if (tableView != null) {
                TableColumn tableColumn = this.getTableColumn();
                TableColumn.CellEditEvent editEvent = new TableColumn.CellEditEvent(tableView, new TablePosition(tableView, this.getIndex(), tableColumn), TableColumn.editCommitEvent(), this.editWidget.getValue());
                Event.fireEvent((EventTarget)tableColumn, (Event)editEvent);
            }
        }
    }
}

