/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column;

import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.util.Callback;

public class PriceColumn<T>
extends BigTableWidgetColumn<T, BigDecimal> {
    private final Function<T, BigDecimal> getter;
    private final BiConsumer<T, BigDecimal> setter;
    private final Callback<TableColumn<T, BigDecimal>, TableCell<T, BigDecimal>> cellFactory = column -> new PriceWidgetCell();

    public PriceColumn(Function<T, BigDecimal> aGetter, BiConsumer<T, BigDecimal> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    @Override
    protected BigDecimal getCellValue(T row) {
        return this.getter.apply(row);
    }

    @Override
    protected void setCellValue(T row, BigDecimal value) {
        this.setter.accept(row, value);
    }

    @Override
    protected boolean isCellValueChanged(T row, BigDecimal value) {
        return !MiscUtil.equals((Object)value, (Object)this.getter.apply(row));
    }

    @Override
    protected Callback<TableColumn<T, BigDecimal>, TableCell<T, BigDecimal>> getCellFactory() {
        return this.cellFactory;
    }

    class PriceWidgetCell
    extends TableCell<T, BigDecimal> {
        private final PseudoClass EDITING_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"editing");
        private CustomLabel viewWidget;
        private PriceValueWidget editWidget;

        PriceWidgetCell() {
            this.setOnKeyPressed(Event::consume);
        }

        public void startEdit() {
            if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable())) {
                return;
            }
            super.startEdit();
            if (this.isEditing()) {
                if (this.editWidget == null) {
                    this.editWidget = new PriceValueWidget(false);
                    this.editWidget.valueProperty().addListener((s, o, n) -> {
                        this.setItem(n);
                        this.fireEvent();
                    });
                    this.editWidget.setOnKeyReleased(evt -> {
                        if (evt.getCode() == KeyCode.ESCAPE) {
                            this.editWidget.setValue((Number)this.getItem());
                            this.cancelEdit();
                            evt.consume();
                        }
                    });
                    this.editWidget.focusedProperty().addListener((src, o, n) -> {
                        if (!n.booleanValue() && this.isEditing()) {
                            this.commitEdit(this.editWidget.getValue());
                        } else if (!n.booleanValue() && o.booleanValue()) {
                            this.fireEvent();
                        }
                        this.pseudoClassStateChanged(this.EDITING_PSEUDOCLASS, this.isEditing());
                    });
                }
                this.editWidget.setValue((Number)this.getItem());
                this.setGraphic((Node)this.editWidget);
                this.editWidget.requestFocus();
            }
            this.getStyleClass().remove((Object)"edited");
        }

        public void cancelEdit() {
            super.cancelEdit();
            if (this.viewWidget == null) {
                this.viewWidget = new CustomLabel();
            }
            this.viewWidget.setText((String)StandardRenderers.PRICE.apply(this.getItem()));
            this.setGraphic((Node)this.viewWidget);
        }

        protected void updateItem(BigDecimal item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setGraphic(null);
                return;
            }
            if (this.isEditing()) {
                if (this.editWidget != null) {
                    this.editWidget.setValue((Number)this.getItem());
                }
                this.setGraphic((Node)this.editWidget);
            } else {
                if (this.viewWidget == null) {
                    this.viewWidget = new CustomLabel();
                }
                this.viewWidget.setText((String)StandardRenderers.PRICE.apply(item));
                this.setGraphic((Node)this.viewWidget);
            }
        }

        private void fireEvent() {
            TableView tableView = this.getTableView();
            if (tableView != null) {
                TableColumn tableColumn = this.getTableColumn();
                TableColumn.CellEditEvent editEvent = new TableColumn.CellEditEvent(tableView, new TablePosition(tableView, this.getIndex(), tableColumn), TableColumn.editCommitEvent(), this.editWidget.getValue());
                Event.fireEvent((EventTarget)tableColumn, (Event)editEvent);
            }
        }
    }
}

