/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.ValueWrapper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.Callback;

public class SuperColumn<M, I, V extends Node>
extends BigTableWidgetColumn<M, ValueWrapper<I, V>> {
    private final Function<M, I> getter;
    final Supplier<ViewController<V, I>> controllerSupplier;
    BiConsumer<Integer, V> popupCloseHandler;
    PopupConfigurator<V> popupConfigurator;
    BiFunction<Integer, M, String> actionTextSupplier;
    InfoLabelConfigurator<M> infoLabelConfigurator;

    public SuperColumn(Function<M, I> aGgetter, Supplier<ViewController<V, I>> cs) {
        this.getter = aGgetter;
        this.controllerSupplier = cs;
    }

    public void setPopupCloseHandler(BiConsumer<Integer, V> value) {
        this.popupCloseHandler = value;
    }

    public void setPopupConfigurator(PopupConfigurator<V> value) {
        this.popupConfigurator = value;
    }

    public void setActionTextSupplier(BiFunction<Integer, M, String> value) {
        this.actionTextSupplier = value;
        this.refresh();
    }

    public void setInfoLabelConfigurator(InfoLabelConfigurator<M> value) {
        this.infoLabelConfigurator = value;
        this.refresh();
    }

    @Override
    protected ValueWrapper<I, V> getCellValue(M row) {
        return new ValueWrapper(this.getter.apply(row));
    }

    @Override
    protected void setCellValue(M row, ValueWrapper<I, V> value) {
        if (value.controller != null) {
            value.controller.writeData(value.value);
        }
    }

    @Override
    protected boolean isCellValueChanged(M row, ValueWrapper<I, V> value) {
        return value.controller != null && value.controller.isDataChanged();
    }

    @Override
    protected Callback<TableColumn<M, ValueWrapper<I, V>>, TableCell<M, ValueWrapper<I, V>>> getCellFactory() {
        return column -> new SuperCell();
    }

    private class SuperCell
    extends TableCell<M, ValueWrapper<I, V>> {
        private Node node;

        SuperCell() {
            this.getStyleClass().add((Object)"super-cell");
        }

        protected void updateItem(ValueWrapper<I, V> item, boolean empty) {
            super.updateItem(item, empty);
            if (empty || item == null) {
                this.setGraphic(null);
                return;
            }
            Object rowData = SuperColumn.this.getRowData(this.getIndex());
            int idx = SuperColumn.this.getRowIndexOf(rowData);
            if (this.node == null) {
                HyperlinkWidget actionWidget;
                String actionText = SuperColumn.this.actionTextSupplier != null ? SuperColumn.this.actionTextSupplier.apply(idx == -1 ? null : Integer.valueOf(idx), rowData) : SuperColumn.this.getCaption();
                if (TextUtil.isBlank((String)actionText)) {
                    Button button = new Button();
                    button.getStyleClass().add((Object)"xtrip-button");
                    button.setGraphic((Node)new IconNode(StandardIconShapes.DOTS_22X14, (Styleable)button, StandardIconIntentions.EXPAND_BUTTON_ACTION, (Styleable)button));
                    button.setOnAction(evt -> this.openPopup(Messages.General_In_details, (ValueWrapper)this.getItem()));
                    actionWidget = button;
                } else {
                    HyperlinkWidget widget = new HyperlinkWidget();
                    widget.setMinWidth(Double.NEGATIVE_INFINITY);
                    widget.setText(actionText);
                    widget.setOnAction(evt -> this.openPopup(widget.getText(), (ValueWrapper)this.getItem()));
                    actionWidget = widget;
                }
                if (SuperColumn.this.infoLabelConfigurator == null) {
                    this.node = actionWidget;
                } else {
                    CustomLabel infoLabel = new CustomLabel();
                    infoLabel.setMaxWidth(Double.MAX_VALUE);
                    HBox.setHgrow((Node)infoLabel, (Priority)Priority.ALWAYS);
                    HBox.setHgrow((Node)actionWidget, (Priority)Priority.NEVER);
                    this.node = new HBox(new Node[]{infoLabel, actionWidget});
                }
            }
            if (this.node instanceof HBox) {
                SuperColumn.this.infoLabelConfigurator.configure(idx == -1 ? null : Integer.valueOf(idx), rowData, (Label)((HBox)this.node).getChildren().get(0));
            }
            this.setGraphic(this.node);
        }

        private void openPopup(String title, ValueWrapper<I, V> item) {
            if (item == null) {
                return;
            }
            if (item.controller == null) {
                item.controller = SuperColumn.this.controllerSupplier.get();
                item.controller.readData(item.value);
            }
            item.controller.setReadonly(!this.getTableView().isEditable() || SuperColumn.this.isNotEditable());
            Object rowData = SuperColumn.this.getRowData(this.getIndex());
            int idx = SuperColumn.this.getRowIndexOf(rowData);
            Dialog dialog = new Dialog();
            dialog.setTitle(title).setBody((Node)item.controller.getView()).setExpandToParent(true).setOnCloseRequest(() -> {
                if (SuperColumn.this.popupCloseHandler != null) {
                    SuperColumn.this.popupCloseHandler.accept(idx == -1 ? null : Integer.valueOf(idx), item.controller.getView());
                }
            }).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Close, () -> {
                if (SuperColumn.this.popupCloseHandler != null) {
                    SuperColumn.this.popupCloseHandler.accept(idx == -1 ? null : Integer.valueOf(idx), item.controller.getView());
                }
                dialog.close();
                SuperColumn.this.refresh();
            });
            if (SuperColumn.this.popupConfigurator != null) {
                SuperColumn.this.popupConfigurator.configure(idx == -1 ? null : Integer.valueOf(idx), dialog, item.controller.getView());
            }
            dialog.show((Node)this);
        }
    }

    @FunctionalInterface
    public static interface InfoLabelConfigurator<M> {
        public void configure(Integer var1, M var2, Label var3);
    }

    @FunctionalInterface
    public static interface PopupConfigurator<V extends Node> {
        public void configure(Integer var1, Dialog var2, V var3);
    }
}

