/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column;

import com.gridnine.xtrip.client.fx.core.lib.components.ClearableTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;

class TextFieldWidgetCell<T>
extends TableCell<T, String> {
    private static final PseudoClass EDITING_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"editing");
    private CustomLabel viewWidget;
    private ClearableTextField editWidget;

    TextFieldWidgetCell() {
        this.setOnKeyPressed(ev -> ev.consume());
    }

    public void startEdit() {
        if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable())) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            if (this.editWidget == null) {
                this.editWidget = new ClearableTextField();
                this.editWidget.setOnAction(evt -> {
                    this.commitEdit(this.editWidget.getText());
                    evt.consume();
                });
                this.editWidget.setOnKeyReleased(evt -> {
                    if (evt.getCode() == KeyCode.ESCAPE) {
                        this.editWidget.setText((String)this.getItem());
                        this.cancelEdit();
                        evt.consume();
                    }
                });
                this.editWidget.focusedProperty().addListener((src, o, n) -> {
                    TableView tableView;
                    if (!n.booleanValue() && this.isEditing()) {
                        this.commitEdit(this.editWidget.getText());
                    } else if (!n.booleanValue() && o.booleanValue() && (tableView = this.getTableView()) != null) {
                        TableColumn tableColumn = this.getTableColumn();
                        TableColumn.CellEditEvent editEvent = new TableColumn.CellEditEvent(tableView, new TablePosition(tableView, this.getIndex(), tableColumn), TableColumn.editCommitEvent(), (Object)this.editWidget.getText());
                        Event.fireEvent((EventTarget)tableColumn, (Event)editEvent);
                    }
                    this.pseudoClassStateChanged(EDITING_PSEUDOCLASS, this.isEditing());
                });
            }
            this.editWidget.setText((String)this.getItem());
            this.setGraphic((Node)this.editWidget);
            this.editWidget.selectAll();
            this.editWidget.requestFocus();
        }
        this.getStyleClass().remove((Object)"edited");
    }

    public void cancelEdit() {
        super.cancelEdit();
        if (this.viewWidget == null) {
            this.viewWidget = new CustomLabel();
        }
        this.viewWidget.setText((String)this.getItem());
        this.setGraphic((Node)this.viewWidget);
    }

    protected void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setGraphic(null);
            return;
        }
        if (this.isEditing()) {
            if (this.editWidget != null) {
                this.editWidget.setText((String)this.getItem());
            }
            this.setGraphic((Node)this.editWidget);
        } else {
            if (this.viewWidget == null) {
                this.viewWidget = new CustomLabel();
            }
            this.viewWidget.setText((String)this.getItem());
            this.setGraphic((Node)this.viewWidget);
        }
    }
}

