/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dataview;

import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.QueryDataViewHandler;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public final class EntityIndexDataViewHandler<V, E extends BaseEntity, I extends EntityIndex<E>>
extends QueryDataViewHandler<V> {
    private final Class<I> indexClass;
    private final Function<I, V> converter;

    public EntityIndexDataViewHandler(Class<I> cls, Function<I, V> crtr) {
        this.indexClass = cls;
        this.converter = crtr;
    }

    @Override
    protected List<V> executeQuery(SearchQuery query) throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        List searchResult = entityService.search(sic, this.indexClass, query);
        ArrayList<V> result = new ArrayList<V>(searchResult.size());
        for (EntityIndex idx : searchResult) {
            result.add(this.converter.apply(idx));
        }
        return result;
    }
}

