/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomComboBox;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DefaultListParametersMultiSupplier;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;

public abstract class BaseEntityBoxWidget<E extends BaseEntity, V extends EntityReference<E>>
extends HBox
implements HasViewState,
HasValue<V>,
DevTool {
    private final Class<E> entityType;
    private final SimpleObjectProperty<V> value = new SimpleObjectProperty();
    private final Map<String, Object> indexPropertiesMap = new HashMap<String, Object>();
    private ComboBoxWidget<V> comboBox;
    private Hyperlink readonlyLink;
    private Label readonlyLabel;
    protected Supplier<List<V>> itemsSupplier;
    private boolean itemsSupplierAsync;
    MultiSupplier<IndexListParameters<E, ?>> listParametersSupplier;
    Supplier<Map<String, Function<EntityIndex<E>, Object>>> indexPropertiesSupplier = null;
    private String fieldName = "";
    private final ViewState viewState = new ViewState();
    protected StringConverter<V> converter;
    private boolean noNulls;
    private boolean live;
    Consumer<EntityIndex<E>> valueSelectionListener;
    private String clearButtonTooltip;
    private Runnable clearAction;
    private Node lookupDialogOwner = this;
    private boolean inactive;

    public static <E extends BaseEntity> MultiSupplier<IndexListParameters<E, ?>> createDefaultListParametersSupplier(Class<E> entityType) {
        return new DefaultListParametersMultiSupplier<E>(entityType);
    }

    protected BaseEntityBoxWidget(Class<E> entityCls, boolean ro) {
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.entityType = entityCls;
        this.listParametersSupplier = new DefaultListParametersMultiSupplier<E>(this.entityType);
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"entity-box-widget", "simple-widget"});
        this.value.addListener((s, o, n) -> this.updateLinkValue(n));
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    public void requestFocus() {
        if (this.comboBox != null) {
            this.comboBox.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public Class<E> getEntityType() {
        return this.entityType;
    }

    public void setItemsSupplier(Supplier<List<V>> supplier, boolean async) {
        this.itemsSupplier = supplier;
        this.itemsSupplierAsync = async;
        if (this.comboBox != null) {
            this.configureComboBoxSupplier();
        }
    }

    public Supplier<List<V>> getItemsSupplier() {
        return this.itemsSupplier;
    }

    public void setListParametersSupplier(MultiSupplier<IndexListParameters<E, ?>> val) {
        if (val.count() <= 0) {
            throw new IllegalArgumentException("parameters count should be positive");
        }
        this.listParametersSupplier = val;
        if (this.comboBox != null) {
            this.configureComboBoxSupplier();
        }
    }

    public void setListParametersSupplier(final Supplier<IndexListParameters<E, ?>> val) {
        this.listParametersSupplier = new MultiSupplier<IndexListParameters<E, ?>>(){

            @Override
            public int count() {
                return 1;
            }

            @Override
            public String getDisplayName(int idx) {
                return null;
            }

            @Override
            public IndexListParameters<E, ?> get(int idx) {
                return (IndexListParameters)val.get();
            }
        };
        if (this.comboBox != null) {
            this.configureComboBoxSupplier();
        }
    }

    public void setIndexPropertiesSupplier(Supplier<Map<String, Function<EntityIndex<E>, Object>>> val) {
        this.indexPropertiesSupplier = val;
        if (val != null && this.comboBox != null) {
            this.comboBox.setSuggestionsHandler(null);
        }
    }

    public void setConverter(StringConverter<V> val) {
        this.converter = val;
        if (this.comboBox != null) {
            this.comboBox.setConverter(this.converter);
        }
        this.redraw();
    }

    public Map<String, Object> getIndexProperties() {
        return this.indexPropertiesMap;
    }

    private void setIndexProperties(EntityIndex<E> idx) {
        this.indexPropertiesMap.clear();
        for (Map.Entry<String, Function<EntityIndex<E>, Object>> entry : this.indexPropertiesSupplier.get().entrySet()) {
            this.indexPropertiesMap.put(entry.getKey(), entry.getValue().apply(idx));
        }
    }

    @Override
    public ObjectProperty<V> valueProperty() {
        return this.value;
    }

    public V getValue() {
        return (V)((EntityReference)this.value.get());
    }

    public void setValue(V val) {
        this.value.set(val);
    }

    public String getText() {
        return this.getText((EntityReference)this.value.get());
    }

    public String getText(V val) {
        if (this.converter != null) {
            return this.converter.toString(val);
        }
        return val == null ? null : val.toString();
    }

    public void setNoNulls(boolean val) {
        this.noNulls = val;
        if (this.comboBox != null) {
            this.comboBox.setNoNulls(this.noNulls);
        }
    }

    public void setLive(boolean val) {
        this.live = val;
        if (this.comboBox != null) {
            this.comboBox.setLive(this.live);
        }
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public void redraw() {
        if (this.comboBox != null) {
            this.comboBox.setValue(this.value.get());
            this.comboBox.redraw();
        } else {
            this.updateLinkValue((EntityReference)this.value.get());
        }
    }

    protected String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String val) {
        this.fieldName = val;
    }

    public void setValueSelectionListener(Consumer<EntityIndex<E>> val) {
        this.valueSelectionListener = val;
    }

    public void setClearButtonTooltip(String val) {
        this.clearButtonTooltip = val;
        if (this.comboBox != null) {
            this.comboBox.setClearButtonTooltip(this.clearButtonTooltip);
        }
    }

    public void setClearAction(Runnable val) {
        this.clearAction = val;
        if (this.comboBox != null) {
            this.comboBox.setClearAction(this.clearAction);
        }
    }

    public void setLookupDialogOwner(Node val) {
        this.lookupDialogOwner = val;
    }

    public void setInactive(boolean val) {
        this.inactive = val;
        this.updateState();
    }

    protected abstract void navigateTo(V var1);

    protected abstract V createValue(EntityIndex<E> var1);

    public void showLookupDialog() {
        if (this.listParametersSupplier.count() < 1) {
            Notifications.get().showFlashNotification(Messages.General_Not_Configured + this.getEntityType().getName(), null);
            return;
        }
        IndexListPane pane = new IndexListPane<E, EntityIndex<E>>(new ObservableMutex(), new MultiSupplier<IndexListPaneConfiguration<E, EntityIndex<E>>>(){

            @Override
            public int count() {
                return BaseEntityBoxWidget.this.listParametersSupplier.count();
            }

            @Override
            public String getDisplayName(int idx) {
                return BaseEntityBoxWidget.this.listParametersSupplier.getDisplayName(idx);
            }

            @Override
            public IndexListPaneConfiguration<E, EntityIndex<E>> get(int idx) {
                IndexListParameters parameters = BaseEntityBoxWidget.this.listParametersSupplier.get(idx);
                IndexListPaneConfiguration result = new IndexListPaneConfiguration(parameters.getIndexType());
                result.setSelectionMode(SelectionMode.SINGLE);
                result.setPatternSearchEnabled(true);
                result.setActionsEnabled(false);
                result.setLimit(parameters.getLimit());
                result.applyParameters(parameters);
                return result;
            }
        }){

            @Override
            protected void newConfigurationPopulated() {
                super.newConfigurationPopulated();
                this.getTableView().getColumns().add(TableColumnSettings.createActionColumn(item -> BaseEntityBoxWidget.this.navigateTo(BaseEntityBoxWidget.this.createValue(item))));
            }
        };
        new Dialog().setTitle(Messages.getWritingField(this.getFieldName())).setBody((Node)pane).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE, Messages.General_Cancel).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.General_Choose, () -> {
            EntityIndex selected;
            List items = pane.getSelectedItems();
            if (!items.isEmpty()) {
                selected = (EntityIndex)items.get(0);
                if (this.indexPropertiesSupplier != null) {
                    this.setIndexProperties(selected);
                }
                this.setValue(this.createValue(selected));
            } else {
                selected = null;
                this.setValue(null);
            }
            if (this.valueSelectionListener != null) {
                this.valueSelectionListener.accept(selected);
            }
        }, (BooleanExpression)pane.selectionPresentProperty()).show(this.lookupDialogOwner);
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            if (this.comboBox != null) {
                this.value.unbindBidirectional(this.comboBox.valueProperty());
                this.comboBox = null;
            }
            if (this.inactive) {
                if (this.readonlyLabel == null) {
                    this.readonlyLink = null;
                    this.readonlyLabel = new CustomLabel();
                    this.readonlyLabel.setMaxWidth(Double.MAX_VALUE);
                    this.getChildren().setAll((Object[])new Node[]{this.readonlyLabel});
                    this.updateLinkValue((EntityReference)this.value.get());
                }
            } else if (this.readonlyLink == null) {
                this.readonlyLabel = null;
                this.readonlyLink = new HyperlinkWidget();
                this.readonlyLink.setMaxWidth(Double.MAX_VALUE);
                this.readonlyLink.setOnAction(evt -> this.navigateTo(this.getValue()));
                this.getChildren().setAll((Object[])new Node[]{this.readonlyLink});
                this.updateLinkValue((EntityReference)this.value.get());
            }
        } else {
            this.readonlyLink = null;
            this.readonlyLabel = null;
            if (this.comboBox == null) {
                this.comboBox = new ComboBoxWidget<V>(false){

                    @Override
                    protected boolean needDropDown() {
                        if (BaseEntityBoxWidget.this.itemsSupplier == null) {
                            BaseEntityBoxWidget.this.showLookupDialog();
                            return false;
                        }
                        return true;
                    }
                };
                HBox.setHgrow(this.comboBox, (Priority)Priority.ALWAYS);
                this.comboBox.setMaxWidth(Double.MAX_VALUE);
                if (this.converter != null) {
                    this.comboBox.setConverter(this.converter);
                }
                this.configureComboBoxSupplier();
                this.comboBox.setNoNulls(this.noNulls);
                this.comboBox.setLive(this.live);
                this.comboBox.setValue(this.value.get());
                this.value.bindBidirectional(this.comboBox.valueProperty());
                if (this.clearButtonTooltip != null) {
                    this.comboBox.setClearButtonTooltip(this.clearButtonTooltip);
                }
                if (this.clearAction != null) {
                    this.comboBox.setClearAction(this.clearAction);
                }
                if (this.inactive) {
                    this.getChildren().setAll((Object[])new Node[]{this.comboBox});
                } else {
                    Button navigateButton = new Button();
                    navigateButton.setOnAction(evt -> this.navigateTo((EntityReference)this.comboBox.getValue()));
                    UiUtil.setTooltip((Node)navigateButton, Messages.General_Open_object_in_new_tab);
                    navigateButton.setGraphic((Node)new IconNode(StandardIconShapes.BOX_NAVIGATE, (Styleable)navigateButton, StandardIconIntentions.BOX_NAVIGATE_BUTTON_ACTION, (Styleable)navigateButton));
                    Styles.addStyle((Styleable)navigateButton, "xtrip-button");
                    this.getChildren().setAll((Object[])new Node[]{this.comboBox, navigateButton});
                }
            }
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
    }

    private void configureComboBoxSupplier() {
        this.comboBox.setButtonStyle(this.itemsSupplier != null ? CustomComboBox.ButtonStyle.STANDARD : CustomComboBox.ButtonStyle.LIST);
        this.comboBox.setItemsSupplier(this.itemsSupplier);
        if (this.itemsSupplier != null) {
            this.comboBox.setAsync(this.itemsSupplierAsync);
            if (this.indexPropertiesSupplier == null) {
                SimpleSuggestionsHandler suggestionsHandler = new SimpleSuggestionsHandler<V>(new StringConverter<V>(){

                    public String toString(V object) {
                        if (BaseEntityBoxWidget.this.converter != null) {
                            return BaseEntityBoxWidget.this.converter.toString(object);
                        }
                        return object == null ? null : object.toString();
                    }

                    public V fromString(String string) {
                        return null;
                    }
                }, this.itemsSupplier, true){

                    @Override
                    public void onSuggestionSelected(V val) {
                        if (BaseEntityBoxWidget.this.valueSelectionListener != null) {
                            BaseEntityBoxWidget.this.valueSelectionListener.accept(null);
                        }
                    }
                };
                suggestionsHandler.setAsync(this.itemsSupplierAsync);
                this.comboBox.setSuggestionsHandler(suggestionsHandler);
            } else {
                this.comboBox.setSuggestionsHandler(null);
            }
        } else if (this.listParametersSupplier.count() == 1 && this.indexPropertiesSupplier == null) {
            if (RootEntityHandler.forEntityClass(this.entityType) != null) {
                this.comboBox.setSuggestionsHandler(new EntityBoxSuggestionsHandler(() -> this.listParametersSupplier.get(0), idx -> this.createValue((EntityIndex)idx), idx -> {
                    if (this.valueSelectionListener != null) {
                        this.valueSelectionListener.accept((EntityIndex)idx);
                    }
                }));
            }
        } else {
            this.comboBox.setSuggestionsHandler(null);
        }
    }

    private void updateLinkValue(V val) {
        Label roWidget;
        Object object = roWidget = this.readonlyLink == null ? this.readonlyLabel : this.readonlyLink;
        if (roWidget == null) {
            return;
        }
        roWidget.pseudoClassStateChanged(Styles.EMPTY_PSEUDOCLASS, val == null);
        if (val == null) {
            roWidget.setText("\u2014");
            roWidget.setTooltip(null);
        } else {
            roWidget.setText(this.getText(val));
            if (roWidget instanceof Hyperlink) {
                UiUtil.setTooltip((Node)roWidget, Messages.General_Open_object_in_new_tab);
            }
        }
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return Collections.emptyList();
            }

            @Override
            public String getInfo() {
                return BaseEntityBoxWidget.this.getClass().getSimpleName() + " [" + BaseEntityBoxWidget.this.getEntityType().getName() + ']' + DevTools.getViewStateInfo(BaseEntityBoxWidget.this.viewState);
            }
        };
    }
}

