/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.FileChooser;

public class BytesValueWidget
extends HBox
implements HasViewState,
HasValue<byte[]> {
    private final Label label;
    private final HyperlinkWidget clearWidget;
    private final HyperlinkWidget importWidget;
    private final HyperlinkWidget exportWidget;
    private final ObjectProperty<byte[]> value = new SimpleObjectProperty();
    private final ViewState viewState = new ViewState();
    protected Supplier<String> fileNameSupplier;

    public BytesValueWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.getStyleClass().addAll((Object[])new String[]{"bytes-value-widget", "simple-widget"});
        this.clearWidget = new HyperlinkWidget();
        this.clearWidget.setText(Messages.General_Clean);
        UiUtil.setTooltip((Node)this.clearWidget, Messages.General_Delete_data);
        this.clearWidget.setOnAction(evt -> this.value.set(null));
        this.importWidget = new HyperlinkWidget();
        this.importWidget.setText(Messages.General_Import);
        UiUtil.setTooltip((Node)this.importWidget, Messages.General_Import_data_from_file);
        this.importWidget.setOnAction(evt -> this.doImport());
        this.exportWidget = new HyperlinkWidget();
        this.exportWidget.setText(Messages.General_Export);
        UiUtil.setTooltip((Node)this.exportWidget, Messages.General_Export_data_to_file);
        this.exportWidget.setOnAction(evt -> this.doExport());
        this.label = new CustomLabel();
        this.label.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.label, this.clearWidget, this.importWidget, this.exportWidget});
        this.value.addListener((s, o, n) -> this.updateState());
        this.configureDnD();
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    private void configureDnD() {
        this.label.setOnDragDetected(evt -> {
            if (this.value.get() == null) {
                return;
            }
            try {
                String fileName = this.fileNameSupplier != null ? this.fileNameSupplier.get() : null;
                File file = TextUtil.isBlank((String)fileName) ? File.createTempFile("xtrip-doc-", ".bin") : new File(new File(System.getProperty("java.io.tmpdir")), fileName);
                Files.write(file.toPath(), (byte[])this.value.get(), new OpenOption[0]);
                file.deleteOnExit();
                Dragboard db = this.label.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
                db.setContent(Collections.singletonMap(DataFormat.FILES, Collections.singletonList(file)));
                evt.consume();
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
            }
        });
        this.setOnDragOver(evt -> {
            evt.consume();
            if (this.viewState.isImmutable()) {
                return;
            }
            if (evt.getGestureSource() == this) {
                return;
            }
            if (!evt.getDragboard().hasFiles()) {
                return;
            }
            evt.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
        });
        this.setOnDragDropped(evt -> {
            evt.consume();
            if (this.viewState.isImmutable()) {
                return;
            }
            if (!evt.getDragboard().hasFiles()) {
                return;
            }
            try {
                this.setValue(Files.readAllBytes(((File)evt.getDragboard().getFiles().get(0)).toPath()));
                evt.setDropCompleted(true);
            }
            catch (IOException ioe) {
                ErrorHandler.handle(ioe);
            }
        });
    }

    @Override
    public ObjectProperty<byte[]> valueProperty() {
        return this.value;
    }

    public byte[] getValue() {
        return (byte[])this.value.get();
    }

    public void setValue(byte[] val) {
        this.value.set((Object)val);
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public void setFileNameSupplier(Supplier<String> value) {
        this.fileNameSupplier = value == null ? null : () -> {
            String result = (String)value.get();
            if (result == null) {
                return null;
            }
            return result.replace('?', '_').replace('\\', '_').replace('/', '_').replace(':', '_');
        };
    }

    private void updateState() {
        boolean editingDisabled = this.viewState.isImmutable();
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, editingDisabled);
        this.importWidget.setDisable(editingDisabled);
        this.exportWidget.setDisable(this.value.get() == null);
        this.clearWidget.setDisable(editingDisabled || this.value.get() == null);
        if (this.value.get() == null) {
            this.label.setText(this.viewState.isImmutable() ? "\u2014" : UiUtil.NULL_TEXT);
        } else {
            this.label.setText(Messages.General_Data + ": " + ((byte[])this.value.get()).length + " " + Messages.General_Bytes);
        }
        Styles.manageStyle((Styleable)this.label, "draggable", this.value.get() != null);
    }

    private void doImport() {
        FileChooser fc = new FileChooser();
        fc.setTitle(Messages.General_Choose_file_for_import);
        fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(Messages.General_All_file_types, new String[]{"*.*"}));
        File dir = ClientSettings.get().getFileChooserDirectory();
        if (UiUtil.isFileValid(dir) && dir.isDirectory()) {
            fc.setInitialDirectory(dir);
        } else {
            fc.setInitialDirectory(Environment.getDataFolder());
        }
        File file = fc.showOpenDialog(this.getScene().getWindow());
        if (file == null || !file.isFile()) {
            return;
        }
        ClientSettings.get().setFileChooserDirectory(file.getParentFile());
        ClientSettings.get().save();
        try {
            this.value.set((Object)Files.readAllBytes(file.toPath()));
            Notifications.get().showFlashNotification(Messages.General_Import_finished, null);
        }
        catch (IOException ioe) {
            ErrorHandler.handle(ioe);
        }
    }

    private void doExport() {
        if (this.value.get() == null) {
            return;
        }
        FileChooser fc = new FileChooser();
        fc.setTitle(Messages.General_Choose_file_for_export_or_enter_new_file_name2);
        fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(Messages.General_All_file_types, new String[]{"*.*"}));
        File dir = ClientSettings.get().getFileChooserDirectory();
        if (UiUtil.isFileValid(dir) && dir.isDirectory()) {
            fc.setInitialDirectory(dir);
        } else {
            fc.setInitialDirectory(Environment.getDataFolder());
        }
        File file = fc.showSaveDialog(this.getScene().getWindow());
        if (file == null) {
            return;
        }
        ClientSettings.get().setFileChooserDirectory(file.getParentFile());
        ClientSettings.get().save();
        if (file.isFile()) {
            Dialog.confirm((Node)this, Messages.General_File_already_exists, null, Messages.General_Overwrite, () -> this.writeData(file), null);
        } else {
            this.writeData(file);
        }
    }

    private void writeData(File file) {
        try {
            byte[] data = (byte[])this.value.get();
            Files.write(file.toPath(), data == null ? new byte[]{} : data, new OpenOption[0]);
            Notifications.get().showFlashNotification(Messages.General_Export_finished, null);
        }
        catch (IOException ioe) {
            ErrorHandler.handle(ioe);
        }
    }
}

