/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog;

import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionSession;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.service.GlobalSettingsService;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

class DicBoxSuggestionsHandler<D extends BaseDictionary>
implements SuggestionsHandler<DictionaryReference<D>> {
    private final DictHandler<D> handler;
    private final Supplier<DictListParameters> listParametersSupplier;
    private final Function<DictItem<D>, DictionaryReference<D>> valueBuilder;
    private final Consumer<DictItem<D>> suggestionSelectionListener;
    private Supplier<Integer> suggestionsLimit;
    private Map<DictionaryReference<D>, DictItem<D>> lastSuggestions;

    DicBoxSuggestionsHandler(DictHandler<D> hdlr, Supplier<DictListParameters> parametersSupplier, Function<DictItem<D>, DictionaryReference<D>> valBuilder, Consumer<DictItem<D>> selectionListener, Supplier<Integer> suggestionsLimit) {
        this.handler = hdlr;
        this.listParametersSupplier = parametersSupplier;
        this.valueBuilder = valBuilder;
        this.suggestionSelectionListener = selectionListener;
        this.suggestionsLimit = suggestionsLimit;
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void startSession(SuggestionSession<DictionaryReference<D>> session) {
        String text = session.getUserText();
        if (TextUtil.isBlank((String)text) || GlobalSettingsService.get().isRestrictedTextSearch() && text.trim().length() < 2) {
            session.setSuggestions(Collections.emptyList());
            return;
        }
        DictListParameters listParameters = this.listParametersSupplier.get();
        text = text.trim();
        DictQuery query = new DictQuery();
        query.setPattern(text);
        query.setLimit(this.suggestionsLimit.get().intValue());
        query.getCriterions().addAll(listParameters.getSearchCriterions());
        query.getFields().add(BaseDictionary.Property.codeVariants.name());
        query.getFields().add(BaseDictionary.Property.translations.name());
        Map<String, SortOrder> sort = listParameters.getSortings();
        if (sort != null && !sort.isEmpty()) {
            for (Map.Entry<String, SortOrder> setting : sort.entrySet()) {
                query.getSorting().put(setting.getKey(), setting.getValue());
            }
        } else if (listParameters.getColumns().isEmpty()) {
            query.getSorting().put(BaseDictionary.Property.translations.name(), SortOrder.ASC);
        } else {
            query.getSorting().put(listParameters.getColumns().get(0).getId(), SortOrder.ASC);
        }
        for (TableColumnSettings col : listParameters.getColumns()) {
            query.getFields().add(col.getId());
        }
        try {
            DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
            List searchResult = dictService.search(ServiceInvocationContext.get(), this.handler.getDictType(), query);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            ArrayList<DictionaryReference<D>> suggestions = new ArrayList<DictionaryReference<D>>(searchResult.size());
            HashMap<DictionaryReference<D>, DictItem<D>> map = new HashMap<DictionaryReference<D>, DictItem<D>>();
            for (DictItem item : searchResult) {
                DictionaryReference<D> ref = this.valueBuilder.apply(item);
                map.put(ref, item);
                suggestions.add(ref);
            }
            this.lastSuggestions = map;
            session.setSuggestions(suggestions);
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
    }

    @Override
    public void onSuggestionSelected(DictionaryReference<D> value) {
        DictItem<D> item = null;
        if (value != null && this.lastSuggestions != null) {
            item = this.lastSuggestions.get(value);
        }
        this.suggestionSelectionListener.accept(item);
    }
}

