/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionSession;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.service.GlobalSettingsService;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class EntityBoxSuggestionsHandler<E extends BaseEntity>
implements SuggestionsHandler<EntityReference<E>> {
    private final Supplier<IndexListParameters<E, ?>> listParametersSupplier;
    private final Function<EntityIndex<E>, EntityReference<E>> referenceBuilder;
    private final Consumer<EntityIndex<E>> suggestionSelectionListener;
    private Map<EntityReference<E>, EntityIndex<E>> lastSuggestions;

    EntityBoxSuggestionsHandler(Supplier<IndexListParameters<E, ?>> parametersSupplier, Function<EntityIndex<E>, EntityReference<E>> refBuilder, Consumer<EntityIndex<E>> selectionListener) {
        this.listParametersSupplier = parametersSupplier;
        this.referenceBuilder = refBuilder;
        this.suggestionSelectionListener = selectionListener;
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void startSession(SuggestionSession<EntityReference<E>> session) {
        String text = session.getUserText();
        if (TextUtil.isBlank((String)text) || GlobalSettingsService.get().isRestrictedTextSearch() && text.trim().length() < 3) {
            session.setSuggestions(Collections.emptyList());
            return;
        }
        IndexListParameters<E, ?> listParameters = this.listParametersSupplier.get();
        SearchQuery query = new SearchQuery();
        query.setLimit(10);
        if (listParameters.getPatternSearchFields().isEmpty()) {
            query.getCriteria().setFreeTextPattern(text);
        } else {
            query.getCriteria().getCriterions().add(IndexListPane.createTextSearchCriterion((IndexType)MetaRegistry.get().getIndexes().get(listParameters.getIndexType().getName()), listParameters.getPatternSearchFields(), text));
        }
        query.getCriteria().getCriterions().addAll(listParameters.getSearchCriterions());
        query.getCriteria().getRestrictions().addAll(listParameters.getRestrictions());
        query.getCriteria().getOrders().putAll(listParameters.getSortings());
        if (query.getCriteria().getOrders().isEmpty() && !listParameters.getColumns().isEmpty()) {
            query.getCriteria().getOrders().put(listParameters.getColumns().get(0).getId(), SortOrder.ASC);
        }
        query.getPreferredProperties().addAll(listParameters.getColumns().stream().map(TableColumnSettings::getId).collect(Collectors.toList()));
        try {
            List searchResult = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), listParameters.getIndexType(), query);
            ArrayList<EntityReference<E>> suggestions = new ArrayList<EntityReference<E>>(searchResult.size());
            HashMap<EntityReference<E>, EntityIndex<E>> map = new HashMap<EntityReference<E>, EntityIndex<E>>();
            for (EntityIndex idx : searchResult) {
                EntityReference<E> ref = this.referenceBuilder.apply(idx);
                map.put(ref, idx);
                suggestions.add(ref);
            }
            this.lastSuggestions = map;
            session.setSuggestions(suggestions);
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
    }

    @Override
    public void onSuggestionSelected(EntityReference<E> value) {
        EntityIndex<E> idx = null;
        if (value != null && this.lastSuggestions != null) {
            idx = this.lastSuggestions.get(value);
        }
        this.suggestionSelectionListener.accept(idx);
    }
}

