/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.CurrencyValueWidget;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class MoneyValueWidget
extends HBox
implements HasViewState,
HasValue<Money> {
    private final SimpleObjectProperty<Money> value = new SimpleObjectProperty();
    private final ViewState viewState = new ViewState();
    private Labeled readonlyNode;
    private PriceValueWidget valueWidget;
    private CurrencyValueWidget currencyWidget;
    private boolean valueIsChanging = false;
    private boolean fixedCurrency;
    private ChangeListener<Money> listener;

    public MoneyValueWidget(boolean ro) {
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"money-value-widget", "simple-widget"});
        this.value.addListener((s, o, n) -> this.updateReadonlyNodeText());
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    public void requestFocus() {
        if (this.valueWidget != null) {
            this.valueWidget.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void setFixedCurrency(boolean val) {
        this.fixedCurrency = val;
        if (this.currencyWidget != null) {
            this.currencyWidget.getViewState().setNotEditable(this.fixedCurrency);
            if (!this.fixedCurrency) {
                UiUtil.setTooltip((Node)this.currencyWidget, Messages.General_Choose_currency);
            } else {
                Tooltip.uninstall((Node)this.currencyWidget, null);
            }
        }
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    @Override
    public ObjectProperty<Money> valueProperty() {
        return this.value;
    }

    public Money getValue() {
        return (Money)this.value.get();
    }

    public void setValue(Money val) {
        this.value.set((Object)val);
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            if (this.listener != null) {
                this.value.removeListener(this.listener);
                this.listener = null;
            }
            this.valueWidget = null;
            this.currencyWidget = null;
            if (this.readonlyNode == null) {
                this.readonlyNode = new CustomLabel();
                this.readonlyNode.getStyleClass().add((Object)"value-label");
                this.getChildren().setAll((Object[])new Node[]{this.readonlyNode});
                this.updateReadonlyNodeText();
            }
        } else {
            this.readonlyNode = null;
            if (this.valueWidget == null) {
                this.valueWidget = new PriceValueWidget(false);
                HBox.setHgrow((Node)this.valueWidget, (Priority)Priority.ALWAYS);
                this.currencyWidget = new CurrencyValueWidget(false);
                this.currencyWidget.getViewState().setNotEditable(this.fixedCurrency);
                this.currencyWidget.setNoNulls(true);
                this.currencyWidget.setCompactMode(true);
                if (!this.fixedCurrency) {
                    UiUtil.setTooltip((Node)this.currencyWidget, Messages.General_Choose_currency);
                }
                this.getChildren().setAll((Object[])new Node[]{this.valueWidget, this.currencyWidget});
                this.valueWidget.valueProperty().addListener((source, oldValue, newValue) -> {
                    if (!this.valueIsChanging) {
                        this.updateValue();
                    }
                });
                this.currencyWidget.valueProperty().addListener((source, oldValue, newValue) -> {
                    if (!this.valueIsChanging) {
                        this.updateValue();
                    }
                });
                if (this.listener == null) {
                    this.listener = (s, o, n) -> {
                        this.valueIsChanging = true;
                        if (n == null) {
                            this.valueWidget.setValue(null);
                            this.currencyWidget.setDefaultValue();
                        } else {
                            this.valueWidget.setValue(n.getValue());
                            this.currencyWidget.setValue(n.getCurrency());
                        }
                        this.valueIsChanging = false;
                    };
                    FxUtil.addListener(this.value, this.listener);
                }
            }
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
    }

    private void updateReadonlyNodeText() {
        if (this.readonlyNode == null) {
            return;
        }
        Money val = (Money)this.value.get();
        if (val != null) {
            LocaleManager lm = LocaleManager.get();
            DecimalFormat nf = lm.getLocaleData(lm.getCurrentLocale()).getPriceFormat();
            this.readonlyNode.setText((val.getValue() == null ? "\u2014" : nf.format(val.getValue())) + ' ' + (val.getCurrency() == null ? "\u2014" : val.getCurrency()));
        } else {
            this.readonlyNode.setText("\u2014");
        }
        this.readonlyNode.pseudoClassStateChanged(Styles.EMPTY_PSEUDOCLASS, val == null);
    }

    private void updateValue() {
        BigDecimal val = (BigDecimal)this.valueWidget.valueProperty().get();
        String curr = this.currencyWidget.getValue();
        if (val == null && curr == null) {
            this.value.set(null);
            return;
        }
        Money oldValue = (Money)this.value.get();
        Money newValue = new Money();
        if (val != null) {
            newValue.setValue(val);
        } else if (oldValue != null) {
            newValue.setValue(BigDecimal.ZERO);
        }
        if (curr != null) {
            newValue.setCurrency(curr);
        } else if (oldValue != null) {
            newValue.setCurrency(oldValue.getCurrency());
        }
        this.value.set((Object)newValue);
    }

    public boolean hasSameValue(Money val) {
        Money current = (Money)this.value.get();
        if (current == null && val == null) {
            return true;
        }
        if (current == null || val == null) {
            return false;
        }
        if (!MiscUtil.equals((Object)current.getCurrency(), (Object)val.getCurrency())) {
            return false;
        }
        return this.valueWidget == null ? MiscUtil.equals((Object)current.getValue(), (Object)val.getValue()) : this.valueWidget.hasSameValue(val.getValue());
    }
}

