/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical.BaseHistoricalWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.model.HistoricalValue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class BooleanHistoricalWidget
extends BaseHistoricalWidget<Boolean> {
    private final BooleanValueWidget valueWidget;
    private boolean internalChanges = false;

    public BooleanHistoricalWidget(boolean readonly) {
        this.getStyleClass().add((Object)"boolean-historical-widget");
        this.valueWidget = new BooleanValueWidget(false, readonly);
        this.valueWidget.valueProperty().addListener((o, was, bool) -> this.valueChanged((Boolean)bool));
        this.init((Node)this.valueWidget, readonly);
    }

    @Override
    public ViewState getViewState() {
        return this.valueWidget.getViewState();
    }

    @Override
    public void setConverter(StringConverter<Boolean> value) {
        super.setConverter(value);
        this.valueWidget.setConverter(value);
    }

    @Override
    protected void updateCurrentValue(HistoricalValue<Boolean> historicalValue) {
        this.internalChanges = true;
        super.updateCurrentValue(historicalValue);
        this.valueWidget.valueProperty().set((Object)(historicalValue != null && (Boolean)historicalValue.getValue() != false ? 1 : 0));
        this.internalChanges = false;
    }

    @Override
    protected TableWidgetColumn<HistoricalValue<Boolean>, ?> createValueColumn() {
        Function<HistoricalValue, Boolean> getter = pair -> (Boolean)pair.getValue();
        BiConsumer<HistoricalValue, Boolean> setter = (pair, b) -> pair.setValue(b);
        BooleanValueWidgetColumn<HistoricalValue<Boolean>> column = new BooleanValueWidgetColumn<HistoricalValue<Boolean>>(getter, setter);
        column.setCaption(Messages.General_Value);
        column.setId("value");
        StringConverter converter = this.getConverter();
        if (converter != null) {
            column.setConverter(converter);
        }
        return column;
    }

    @Override
    protected void valueChanged(Boolean b) {
        if (!this.internalChanges) {
            super.valueChanged(b);
        }
    }
}

