/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical.BaseHistoricalWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.DateValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.model.HistoricalValue;
import java.time.LocalDate;
import java.util.Date;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.scene.Node;

public class DateHistoricalWidget
extends BaseHistoricalWidget<Date> {
    private final DateValueWidget valueWidget;
    private boolean internalChanges = false;

    public DateHistoricalWidget(boolean readonly) {
        this.getStyleClass().add((Object)"date-historical-widget");
        this.valueWidget = new DateValueWidget(readonly);
        this.valueWidget.valueProperty().addListener((o, was, date) -> this.valueChanged(DateUtils.asDate(date)));
        this.init((Node)this.valueWidget, readonly);
        this.setConverter(StandardRenderers.DATE.createStatefulConverter(this.valueWidget.getViewState()::isReadonly));
    }

    @Override
    public ViewState getViewState() {
        return this.valueWidget.getViewState();
    }

    @Override
    protected void updateCurrentValue(HistoricalValue<Date> historicalValue) {
        this.internalChanges = true;
        super.updateCurrentValue(historicalValue);
        this.valueWidget.valueProperty().set((Object)DateUtils.asLocalDate((Date)historicalValue.getValue()));
        this.internalChanges = false;
    }

    @Override
    protected TableWidgetColumn<HistoricalValue<Date>, ?> createValueColumn() {
        Function<HistoricalValue, LocalDate> getter = pair -> DateUtils.asLocalDate((Date)pair.getValue());
        BiConsumer<HistoricalValue, LocalDate> setter = (pair, date) -> pair.setValue((Object)DateUtils.asDate(date));
        DateValueWidgetColumn<HistoricalValue<Date>> column = new DateValueWidgetColumn<HistoricalValue<Date>>(getter, setter);
        column.setCaption(Messages.General_Value);
        column.setId("value");
        return column;
    }

    @Override
    protected void valueChanged(Date date) {
        if (!this.internalChanges) {
            super.valueChanged(date);
        }
    }
}

