/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical.BaseHistoricalWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class DoubleHistoricalWidget
extends BaseHistoricalWidget<Double> {
    private final ComboBoxWidget<Double> valueWidget;
    private Supplier<List<Double>> supplier;
    private boolean internalChanges = false;

    public DoubleHistoricalWidget(boolean readonly) {
        this.getStyleClass().add((Object)".double-historical-widget");
        this.valueWidget = new ComboBoxWidget(readonly);
        this.valueWidget.valueProperty().addListener((o, was, text) -> this.valueChanged((Double)text));
        this.init((Node)this.valueWidget, readonly);
    }

    @Override
    public ViewState getViewState() {
        return this.valueWidget.getViewState();
    }

    @Override
    protected void updateCurrentValue(HistoricalValue<Double> historicalValue) {
        this.internalChanges = true;
        super.updateCurrentValue(historicalValue);
        this.valueWidget.setValue(historicalValue == null ? null : (Double)historicalValue.getValue());
        this.internalChanges = false;
    }

    @Override
    protected TableWidgetColumn<HistoricalValue<Double>, ?> createValueColumn() {
        StringConverter converter;
        Function<HistoricalValue, Double> getter = pair -> (Double)pair.getValue();
        BiConsumer<HistoricalValue, Double> setter = (pair, str) -> pair.setValue(str);
        ComboBoxWidgetColumn<HistoricalValue, Double> column = new ComboBoxWidgetColumn<HistoricalValue, Double>(getter, setter);
        if (this.supplier != null) {
            column.setItemsSupplier(this.supplier);
        }
        if ((converter = this.getConverter()) != null) {
            column.setConverter(converter);
        }
        column.setCaption(Messages.General_Value);
        column.setId("value");
        return column;
    }

    @Override
    protected void valueChanged(Double value) {
        if (!this.internalChanges) {
            super.valueChanged(value);
        }
    }

    public boolean hasSameText(List<HistoricalValue<Double>> values) {
        Double value = (Double)HistoricalValueHelper.getValue((List)this.getValues());
        Double value1 = (Double)HistoricalValueHelper.getValue(values);
        return MiscUtil.equals((Object)value, (Object)value1);
    }

    @Override
    public void setConverter(StringConverter<Double> value) {
        super.setConverter(value);
        this.valueWidget.setConverter(value);
    }

    public void setItemsSupplier(Supplier<List<Double>> supplier) {
        this.supplier = supplier;
        this.valueWidget.setItemsSupplier(supplier);
    }
}

