/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomTextField;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical.BaseHistoricalWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.scene.Node;

public class StringHistoricalWidget
extends BaseHistoricalWidget<String> {
    private final TextFieldWidget valueWidget;
    private boolean internalChanges = false;

    public StringHistoricalWidget(boolean readonly) {
        this.getStyleClass().add((Object)"string-historical-widget");
        this.valueWidget = new TextFieldWidget(readonly);
        this.valueWidget.valueProperty().addListener((o, was, text) -> this.valueChanged((String)text));
        this.init((Node)this.valueWidget, readonly);
    }

    @Override
    public ViewState getViewState() {
        return this.valueWidget.getViewState();
    }

    @Override
    protected void updateCurrentValue(HistoricalValue<String> historicalValue) {
        this.internalChanges = true;
        super.updateCurrentValue(historicalValue);
        this.valueWidget.setValue(historicalValue == null ? null : (String)historicalValue.getValue());
        this.internalChanges = false;
    }

    @Override
    protected TableWidgetColumn<HistoricalValue<String>, ?> createValueColumn() {
        Function<HistoricalValue, String> getter = pair -> (String)pair.getValue();
        BiConsumer<HistoricalValue, String> setter = (pair, str) -> pair.setValue(str);
        TextWidgetColumn<HistoricalValue<String>> column = new TextWidgetColumn<HistoricalValue<String>>(getter, setter);
        column.setCaption(Messages.General_Value);
        column.setId("value");
        return column;
    }

    @Override
    protected void valueChanged(String text) {
        if (!this.internalChanges) {
            super.valueChanged(text);
        }
    }

    public boolean hasSameText(List<HistoricalValue<String>> values) {
        return CustomTextField.sameNormalizedText((String)HistoricalValueHelper.getValue((List)this.getValues()), (String)HistoricalValueHelper.getValue(values));
    }
}

