/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.Buttons;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.PlaceholderPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableColumnOwner;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.MultiProvider;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

public class ExtendedTableWidget<T extends Identity>
extends BorderPane
implements HasViewState,
DevTool {
    protected final ViewState viewState = new ViewState();
    protected List<TableWidgetColumn<T, ?>> columns = new ArrayList();
    protected MultiProvider<T> itemsProvider = null;
    protected Predicate<ControlsPane.ButtonType> controlButtonsAvailability = ControlsPane.ADD_REMOVE;
    protected Node placeholderNode;
    protected GridPane dataPane;
    protected Header<T> header;
    protected Table<T> table;
    private boolean changed = false;
    private int reflowCounter = 0;

    public ExtendedTableWidget(boolean readonly) {
        this.viewState.setReadonly(readonly);
        this.createGUI();
        this.createBindings();
        this.createListeners();
    }

    private void createGUI() {
        this.getStyleClass().addAll((Object[])new String[]{"extended-table-widget", "table-widget"});
        PlaceholderPane placeholderPane = new PlaceholderPane();
        placeholderPane.setPlaceholder(new CustomLabel(Messages.General_No_entries));
        this.placeholderNode = new StackPane(new Node[]{placeholderPane});
        this.placeholderNode.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
        this.dataPane = new GridPane();
        this.dataPane.getStyleClass().add((Object)"grid-frame");
        this.setCenter((Node)this.dataPane);
    }

    private void createBindings() {
    }

    private void createListeners() {
        this.viewState.stateProperty().addListener((observable, oldValue, newValue) -> this.reflowAdvice(() -> UiUtil.updateState(oldValue.intValue(), newValue.intValue(), readonly -> {
            this.header.getViewState().setReadonly(readonly);
            this.table.getViewState().setReadonly(readonly);
        }, notEditable -> {
            this.header.getViewState().setNotEditable(notEditable);
            this.table.getViewState().setNotEditable(notEditable);
        }, aclNotEditable -> {
            this.header.getViewState().setAclNotEditable(aclNotEditable);
            this.table.getViewState().setAclNotEditable(aclNotEditable);
        }, aclNotViewable -> {
            this.header.getViewState().setAclNotViewable(aclNotViewable);
            this.table.getViewState().setAclNotViewable(aclNotViewable);
        }, aclNotCreatable -> {
            this.header.getViewState().setAclNotCreatable(aclNotCreatable);
            this.table.getViewState().setAclNotCreatable(aclNotCreatable);
        }, aclNotDeletable -> {
            this.header.getViewState().setAclNotDeletable(aclNotDeletable);
            this.table.getViewState().setAclNotDeletable(aclNotDeletable);
        })));
        this.sceneProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.reflow();
            }
        });
    }

    public void setColumns(List<TableWidgetColumn<T, ?>> columns) {
        this.columns.clear();
        this.columns.addAll(columns);
        this.header = new Header(this, this.viewState.getState());
        this.table = null;
        this.reflow();
    }

    public void setItemsProvider(MultiProvider<T> itemsProvider) {
        this.itemsProvider = Objects.requireNonNull(itemsProvider);
    }

    public void setControlButtonsAvailability(Predicate<ControlsPane.ButtonType> controlButtonsAvailability) {
        this.controlButtonsAvailability = Objects.requireNonNull(controlButtonsAvailability);
        this.header = new Header(this, this.viewState.getState());
        this.table = null;
        this.reflow();
    }

    public void setEventHandler(EventHandler<ExtendedTableRowEvent> eventHandler) {
        if (eventHandler != null) {
            this.setEventHandler(ExtendedTableRowEvent.ROW_ANY, eventHandler);
        }
        this.reflow();
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public Table<T> getTable() {
        return this.table;
    }

    public boolean isDataChanged() {
        if (this.changed) {
            return true;
        }
        return this.table.isDataChanged();
    }

    public void readData(Collection<T> model) {
        this.reflowAdvice(() -> {
            ArrayList tableModel = new ArrayList(model);
            this.table = new Table(this, tableModel, this.viewState.getState());
            this.table.readData();
            this.changed = false;
        });
    }

    public void writeData(Collection<T> model) {
        this.table.writeData();
        model.clear();
        model.addAll(this.table.model);
        this.changed = false;
    }

    protected void reflow() {
        if (this.getScene() == null) {
            return;
        }
        if (this.dataPane == null) {
            this.dataPane = new GridPane();
            this.dataPane.getStyleClass().add((Object)"grid-frame");
        }
        this.dataPane.getColumnConstraints().clear();
        this.dataPane.getChildren().clear();
        if (this.table != null) {
            int offset = 0;
            this.header.reflow(0, offset, !this.viewState.isImmutable());
            this.table.reflow(0, offset += this.header.getHeight(), !this.viewState.isImmutable());
        } else {
            ColumnConstraints constraints = new ColumnConstraints();
            constraints.setHgrow(Priority.ALWAYS);
            this.dataPane.getColumnConstraints().add((Object)constraints);
            GridPane.setConstraints((Node)this.placeholderNode, (int)0, (int)0);
            this.dataPane.getChildren().add((Object)this.placeholderNode);
        }
    }

    protected void reflowAdvice(Runnable runnable) {
        try {
            ++this.reflowCounter;
            if (runnable != null) {
                runnable.run();
            }
        }
        finally {
            --this.reflowCounter;
            if (this.reflowCounter == 0) {
                this.reflow();
            }
        }
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return Collections.unmodifiableList(ExtendedTableWidget.this.columns);
            }

            @Override
            public String getInfo() {
                return ExtendedTableWidget.this.getClass().getSimpleName() + DevTools.getViewStateInfo(ExtendedTableWidget.this.viewState);
            }
        };
    }

    public static class Row<T extends Identity>
    implements HasViewState {
        protected final ViewState viewState = new ViewState();
        final ExtendedTableWidget<T> widget;
        final Table<T> table;
        final T model;
        private final List<Node> nodes = new ArrayList<Node>();
        private ControlsPane controlsPane;

        Row(ExtendedTableWidget<T> widget, Table<T> table, T model, int state) {
            this.widget = widget;
            this.table = table;
            this.model = model;
            this.viewState.setState(state);
            this.createGUI();
            this.createBindings();
            this.createListeners();
        }

        private void createGUI() {
            for (TableWidgetColumn column : this.widget.columns) {
                Object node = column.createNode();
                node.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
                this.nodes.add((Node)node);
            }
            this.controlsPane = new ControlsPane();
            this.controlsPane.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
            Predicate<ControlsPane.ButtonType> controlButtonsAvailability = this.widget.controlButtonsAvailability;
            if (controlButtonsAvailability != null && controlButtonsAvailability.test(ControlsPane.ButtonType.DOWN)) {
                Tooltip.install((Node)this.controlsPane.addButton(ControlsPane.ButtonType.DOWN, (EventHandler<? super MouseEvent>)((EventHandler)event -> {
                    int index = this.table.rows.indexOf((Object)this);
                    this.table.model.remove(this.model);
                    this.table.model.add(index + 1, this.model);
                    this.table.rows.remove((Object)this);
                    this.table.rows.add(index + 1, (Object)this);
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{table.getViewState().stateProperty(), table.rows});
                    }

                    protected boolean computeValue() {
                        return table.getViewState().isImmutable() || table.rows.indexOf((Object)this) == table.rows.size() - 1;
                    }
                }), (Tooltip)new Tooltip(Messages.General_Move_line_down_to_one));
            }
            if (controlButtonsAvailability != null && controlButtonsAvailability.test(ControlsPane.ButtonType.UP)) {
                Tooltip.install((Node)this.controlsPane.addButton(ControlsPane.ButtonType.UP, (EventHandler<? super MouseEvent>)((EventHandler)event -> {
                    int index = this.table.rows.indexOf((Object)this);
                    this.table.model.remove(this.model);
                    this.table.model.add(index - 1, this.model);
                    this.table.rows.remove((Object)this);
                    this.table.rows.add(index - 1, (Object)this);
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{table.getViewState().stateProperty(), table.rows});
                    }

                    protected boolean computeValue() {
                        return table.getViewState().isImmutable() || table.rows.indexOf((Object)this) == 0;
                    }
                }), (Tooltip)new Tooltip(Messages.General_Move_line_up_to_one));
            }
            if (controlButtonsAvailability != null && controlButtonsAvailability.test(ControlsPane.ButtonType.REMOVE)) {
                Tooltip.install((Node)this.controlsPane.addButton(ControlsPane.ButtonType.REMOVE, (EventHandler<? super MouseEvent>)((EventHandler)event -> {
                    this.table.model.remove(this.model);
                    this.table.rows.remove((Object)this);
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{table.getViewState().stateProperty(), viewState.stateProperty()});
                    }

                    protected boolean computeValue() {
                        return table.getViewState().isImmutable() || viewState.isAclNotDeletable();
                    }
                }), (Tooltip)new Tooltip(Messages.General_Remove_line));
            }
            if (controlButtonsAvailability != null && controlButtonsAvailability.test(ControlsPane.ButtonType.ADD)) {
                Tooltip.install((Node)this.controlsPane.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)event -> this.widget.itemsProvider.createAny(createdItems -> {
                    for (Identity item2 : createdItems) {
                        if (item2.getUid() != null) continue;
                        item2.setUid(UUID.randomUUID().toString());
                    }
                    int index = this.table.rows.indexOf((Object)this);
                    List createdRows = createdItems.stream().map(item -> new Row<Identity>((ExtendedTableWidget<Identity>)this.widget, (Table<Identity>)this.table, (Identity)item, 0)).collect(Collectors.toList());
                    for (Row createdRow : createdRows) {
                        createdRow.readData();
                    }
                    this.table.model.addAll(index + 1, createdItems);
                    this.table.rows.addAll(index + 1, createdRows);
                })), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{table.getViewState().stateProperty(), viewState.stateProperty()});
                    }

                    protected boolean computeValue() {
                        return table.getViewState().isImmutable() || viewState.isAclNotCreatable();
                    }
                }), (Tooltip)new Tooltip(Messages.General_Add_new_line_after_this));
            }
        }

        private void createBindings() {
        }

        private void createListeners() {
            this.viewState.stateProperty().addListener((observable, oldValue, newValue) -> this.widget.reflowAdvice(() -> UiUtil.updateState(oldValue.intValue(), newValue.intValue(), readonly -> {
                for (Node node : this.nodes) {
                    if (!(node instanceof HasViewState)) continue;
                    ((HasViewState)node).getViewState().setReadonly(readonly);
                }
            }, notEditable -> {
                for (Node node : this.nodes) {
                    if (!(node instanceof HasViewState)) continue;
                    ((HasViewState)node).getViewState().setNotEditable(notEditable);
                }
            }, aclNotEditable -> {
                for (Node node : this.nodes) {
                    if (!(node instanceof HasViewState)) continue;
                    ((HasViewState)node).getViewState().setAclNotEditable(aclNotEditable);
                }
            }, aclNotViewable -> {
                for (Node node : this.nodes) {
                    node.setVisible(!aclNotViewable);
                }
            }, aclNotCreatable -> {}, aclNotDeletable -> {})));
        }

        @Override
        public ViewState getViewState() {
            return this.viewState;
        }

        public String getId() {
            return this.model.getUid();
        }

        public Table<T> getTable() {
            return this.table;
        }

        public <N extends Node> N getWidget(String id) {
            int index = this.table.rows.indexOf((Object)this);
            for (TableWidgetColumn column : this.widget.columns) {
                if (!MiscUtil.equals((Object)id, (Object)column.getId())) continue;
                return (N)column.getWidget(index);
            }
            throw new IllegalArgumentException("invalid column id " + id);
        }

        boolean isDataChanged() {
            for (int i = 0; i < this.widget.columns.size(); ++i) {
                Node node;
                TableWidgetColumn column = this.widget.columns.get(i);
                if (!column.isDataChanged(this.model, node = this.nodes.get(i))) continue;
                return true;
            }
            return false;
        }

        void readData() {
            this.widget.reflowAdvice(() -> {
                for (int i = 0; i < this.widget.columns.size(); ++i) {
                    TableWidgetColumn column = this.widget.columns.get(i);
                    Node node = this.nodes.get(i);
                    column.readData(this.model, node);
                }
            });
        }

        void writeData() {
            for (int i = 0; i < this.widget.columns.size(); ++i) {
                TableWidgetColumn column = this.widget.columns.get(i);
                Node node = this.nodes.get(i);
                column.writeData(this.model, node);
            }
        }

        void reflow(int x, int y, boolean useControls) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                if (this.nodes.get(i).isVisible()) {
                    Node node = this.nodes.get(i);
                    GridPane.setConstraints((Node)node, (int)(x + i), (int)y);
                    this.widget.dataPane.getChildren().add((Object)node);
                    continue;
                }
                CustomLabel label = new CustomLabel(Messages.hidden);
                StackPane node = new StackPane();
                node.getStyleClass().addAll((Object[])new String[]{"row-cell", "acl-not-viewable-cell", "grid-cell"});
                GridPane.setConstraints((Node)node, (int)(x + i), (int)y);
                node.getChildren().add((Object)label);
                this.widget.dataPane.getChildren().add((Object)node);
            }
            if (useControls) {
                GridPane.setConstraints((Node)this.controlsPane, (int)(x + this.nodes.size()), (int)y);
                this.widget.dataPane.getChildren().add((Object)this.controlsPane);
            }
        }
    }

    public static class Table<T extends Identity>
    implements HasViewState {
        protected final ViewState viewState = new ViewState();
        final ExtendedTableWidget<T> widget;
        final List<T> model;
        final ObservableList<Row<T>> rows = FXCollections.observableArrayList();
        private Node placeholderNode;
        private ControlsPane controlsPane;
        private final TableColumnOwner<T> asOwner = new TableColumnOwner<T>(){

            @Override
            public ViewState getViewState() {
                return viewState;
            }

            @Override
            public int indexOfRow(Node node) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <N extends Node> N getWidget(TableWidgetColumn<T, N> column, int index) {
                Row row = (Row)rows.get(index);
                return (N)((Node)row.nodes.get(widget.columns.indexOf(column)));
            }

            @Override
            public void injectWidget(int row, Node widget) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void ejectWidget(int row) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getRowsCount() {
                throw new UnsupportedOperationException();
            }
        };

        Table(ExtendedTableWidget<T> widget, List<T> model, int state) {
            this.widget = widget;
            this.model = model;
            this.viewState.setState(state);
            for (TableWidgetColumn column : widget.columns) {
                column.setOwner(this.asOwner);
            }
            this.createGUI();
            this.createBindings();
            this.createListeners();
        }

        private void createGUI() {
            PlaceholderPane placeholderPane = new PlaceholderPane();
            placeholderPane.setPlaceholder(new CustomLabel(Messages.General_No_entries));
            this.placeholderNode = new StackPane(new Node[]{placeholderPane});
            this.placeholderNode.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
            this.controlsPane = new ControlsPane();
            this.controlsPane.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
            Predicate<ControlsPane.ButtonType> controlButtonsAvailability = this.widget.controlButtonsAvailability;
            if (controlButtonsAvailability != null && controlButtonsAvailability.test(ControlsPane.ButtonType.ADD)) {
                this.controlsPane.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)event -> this.widget.itemsProvider.createAny(createdItems -> {
                    for (Identity item2 : createdItems) {
                        if (item2.getUid() != null) continue;
                        item2.setUid(UUID.randomUUID().toString());
                    }
                    List createdRows = createdItems.stream().map(item -> new Row<Identity>((ExtendedTableWidget<Identity>)this.widget, this, (Identity)item, 0)).collect(Collectors.toList());
                    for (Row createdRow : createdRows) {
                        createdRow.readData();
                    }
                    this.model.addAll(0, (Collection<T>)createdItems);
                    this.rows.addAll(0, createdRows);
                })), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{viewState.stateProperty()});
                    }

                    protected boolean computeValue() {
                        return viewState.isImmutable() || viewState.isAclNotCreatable();
                    }
                });
            }
        }

        private void createBindings() {
        }

        private void createListeners() {
            this.viewState.stateProperty().addListener((observable, oldValue, newValue) -> this.widget.reflowAdvice(() -> UiUtil.updateState(oldValue.intValue(), newValue.intValue(), readonly -> {
                for (Row row : this.rows) {
                    row.getViewState().setReadonly(readonly);
                }
            }, notEditable -> {
                for (Row row : this.rows) {
                    row.getViewState().setNotEditable(notEditable);
                }
            }, aclNotEditable -> {
                for (Row row : this.rows) {
                    row.getViewState().setAclNotEditable(aclNotEditable);
                }
            }, aclNotViewable -> {
                for (Row row : this.rows) {
                    row.getViewState().setAclNotViewable(aclNotViewable);
                }
            }, aclNotCreatable -> {
                for (Row row : this.rows) {
                    row.getViewState().setAclNotCreatable(aclNotCreatable);
                }
            }, aclNotDeletable -> {
                for (Row row : this.rows) {
                    row.getViewState().setAclNotDeletable(aclNotDeletable);
                }
            })));
            this.rows.addListener(change -> this.widget.reflowAdvice(() -> {
                ((ExtendedTableWidget)this.widget).changed = true;
                ArrayList events = new ArrayList();
                while (change.next()) {
                    if (change.wasPermutated() || change.wasUpdated()) {
                        events.addAll(IntStream.range(change.getFrom(), change.getTo()).mapToObj(index -> new ExtendedTableRowEvent(this.widget, (EventTarget)this.widget, (EventType<? extends ExtendedTableRowEvent>)ExtendedTableRowEvent.ROW_ANY, (Row)this.rows.get(index))).collect(Collectors.toList()));
                        continue;
                    }
                    events.addAll(change.getAddedSubList().stream().map(item -> new ExtendedTableRowEvent(this.widget, (EventTarget)this.widget, (EventType<? extends ExtendedTableRowEvent>)ExtendedTableRowEvent.ROW_ADD, (Row<?>)item)).collect(Collectors.toList()));
                    events.addAll(change.getRemoved().stream().map(item -> new ExtendedTableRowEvent(this.widget, (EventTarget)this.widget, (EventType<? extends ExtendedTableRowEvent>)ExtendedTableRowEvent.ROW_REMOVE, (Row<?>)item)).collect(Collectors.toList()));
                }
                for (ExtendedTableRowEvent event : events) {
                    this.widget.fireEvent(event);
                }
            }));
        }

        @Override
        public ViewState getViewState() {
            return this.viewState;
        }

        public List<Row<T>> getRows() {
            return FXCollections.unmodifiableObservableList(this.rows);
        }

        public TableWidgetColumn<T, ?> getColumn(String id) {
            for (TableWidgetColumn column : this.widget.columns) {
                if (!MiscUtil.equals((Object)id, (Object)column.getId())) continue;
                return column;
            }
            throw new IllegalArgumentException("invalid column ID " + id);
        }

        boolean isDataChanged() {
            for (Row row : this.rows) {
                if (!row.isDataChanged()) continue;
                return true;
            }
            return false;
        }

        void readData() {
            this.widget.reflowAdvice(() -> {
                for (Identity rowModel : this.model) {
                    Row<Identity> row = new Row<Identity>(this.widget, this, rowModel, this.viewState.getState());
                    this.rows.add(row);
                    row.readData();
                }
            });
        }

        void writeData() {
            for (Row row : this.rows) {
                row.writeData();
            }
        }

        void reflow(int x, int y, boolean useControls) {
            int width = this.getWidth();
            if (useControls) {
                ++width;
            }
            if (this.rows.size() > 0) {
                for (int i = 0; i < this.rows.size(); ++i) {
                    Row row = (Row)this.rows.get(i);
                    row.reflow(x, y + i, useControls);
                }
            } else {
                GridPane.setColumnSpan((Node)this.placeholderNode, (Integer)(useControls ? width - 1 : width));
                GridPane.setConstraints((Node)this.placeholderNode, (int)x, (int)y);
                this.widget.dataPane.getChildren().add((Object)this.placeholderNode);
                if (useControls) {
                    GridPane.setConstraints((Node)this.controlsPane, (int)(x + (width - 1)), (int)y);
                    this.widget.dataPane.getChildren().add((Object)this.controlsPane);
                }
            }
        }

        int getWidth() {
            return this.widget.columns.size();
        }

        int getHeight() {
            return this.rows.size() > 0 ? this.rows.size() : 1;
        }

        boolean isUseControls() {
            return !this.viewState.isImmutable();
        }
    }

    public static class Header<T extends Identity>
    implements HasViewState {
        protected final ViewState viewState = new ViewState();
        final ExtendedTableWidget<T> widget;
        private final List<MiscUtil.Pair<ColumnConstraints, Node>> nodes = new ArrayList<MiscUtil.Pair<ColumnConstraints, Node>>();

        Header(ExtendedTableWidget<T> widget, int state) {
            this.widget = widget;
            this.viewState.setState(state);
            this.createGUI();
            this.createBindings();
            this.createListeners();
        }

        private void createGUI() {
            boolean hasPercents = this.widget.columns.stream().anyMatch(item -> !item.isHidden() && item.getPrefWidth() != null);
            ColumnConstraints lastUnconstrainedCc = null;
            for (TableWidgetColumn column : this.widget.columns) {
                ColumnConstraints constraints = new ColumnConstraints();
                if (column.getPrefWidthEm() != null || column.isNotHGrowable() || column.getMaxWidthEm() != null || column.getMinWidthEm() != null) {
                    constraints.setHgrow(Priority.NEVER);
                } else if (column.getPrefWidth() != null) {
                    constraints.setPercentWidth(column.getPrefWidth().doubleValue());
                } else {
                    constraints.setPrefWidth(-1.0);
                    constraints.setMinWidth(-1.0);
                    if (hasPercents) {
                        constraints.setMaxWidth(Double.NEGATIVE_INFINITY);
                        constraints.setHgrow(Priority.SOMETIMES);
                        lastUnconstrainedCc = constraints;
                    } else {
                        constraints.setMaxWidth(Double.MAX_VALUE);
                        constraints.setHgrow(Priority.ALWAYS);
                    }
                }
                if (lastUnconstrainedCc != null) {
                    lastUnconstrainedCc.setMaxWidth(Double.MAX_VALUE);
                    lastUnconstrainedCc.setHgrow(Priority.SOMETIMES);
                }
                CustomLabel label = new CustomLabel(column.getCaption());
                StackPane node = new StackPane(new Node[]{label});
                if (column.getHelp() != null) {
                    label.getStyleClass().add((Object)"hasTooltip");
                    label.setGraphic((Node)Buttons.quickHelpButton(() -> column.getHelp().get()));
                }
                node.getStyleClass().addAll((Object[])new String[]{"header-cell", "grid-cell"});
                StringBuilder style = new StringBuilder();
                if (column.getPrefWidthEm() != null) {
                    style.append(String.format("-fx-pref-width:%sem;", String.valueOf(column.getPrefWidthEm())));
                }
                if (column.getMaxWidthEm() != null) {
                    style.append(String.format("-fx-max-width:%sem;", String.valueOf(column.getMaxWidthEm())));
                }
                if (column.getMinWidthEm() != null) {
                    style.append(String.format("-fx-min-width:%sem;", String.valueOf(column.getMinWidthEm())));
                }
                if (style.length() > 0) {
                    node.setStyle(style.toString());
                }
                this.nodes.add((MiscUtil.Pair<ColumnConstraints, Node>)new MiscUtil.Pair((Object)constraints, (Object)node));
            }
        }

        public void reflow(int x, int y, boolean useControls) {
            StackPane node;
            for (int i = 0; i < this.nodes.size(); ++i) {
                node = this.nodes.get(i);
                this.widget.dataPane.getColumnConstraints().add(node.getFirst());
                GridPane.setConstraints((Node)((Node)node.getSecond()), (int)(x + i), (int)y);
                this.widget.dataPane.getChildren().add(node.getSecond());
            }
            if (useControls) {
                ColumnConstraints constraints = new ColumnConstraints();
                constraints.setHgrow(Priority.NEVER);
                node = new StackPane(new Node[]{new CustomLabel()});
                node.getStyleClass().addAll((Object[])new String[]{"header-cell", "grid-cell"});
                this.widget.dataPane.getColumnConstraints().add((Object)constraints);
                GridPane.setConstraints((Node)node, (int)(x + this.nodes.size()), (int)y);
                this.widget.dataPane.getChildren().add((Object)node);
            }
        }

        private void createBindings() {
        }

        private void createListeners() {
            this.viewState.stateProperty().addListener((observable, oldValue, newValue) -> this.widget.reflowAdvice(null));
        }

        @Override
        public ViewState getViewState() {
            return this.viewState;
        }

        int getWidth() {
            return this.widget.columns.size();
        }

        int getHeight() {
            return 1;
        }
    }
}

