/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.groups;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.PlaceholderPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.StandardGroupsWidgetCoordinator;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ListItemStringConverter;
import com.gridnine.xtrip.client.fx.core.util.MultiProvider;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;

public abstract class BaseGroupsWidget<V extends Node>
extends BorderPane
implements HasViewState,
DevTool {
    private final PlaceholderPane placeholderPane;
    private final Label placeholder;
    private MultiProvider<V> viewFactory;
    private ListItemStringConverter<V> converter = (obj, idx) -> String.valueOf(idx + 1) + '.';
    private final ObservableList<V> views = FXCollections.observableArrayList();
    protected Predicate<ControlsPane.ButtonType> controlButtonsAvailability = ControlsPane.ADD_REMOVE_PREV_NEXT;
    private String fieldName;
    protected final ViewState viewState = new ViewState();
    protected StandardGroupsWidgetCoordinator controlButtonsCoordinator = new StandardGroupsWidgetCoordinator(this);
    protected final BooleanProperty controlButtonsRevalidationTrigger = new SimpleBooleanProperty();
    protected Consumer<V> newViewHandler;

    protected BaseGroupsWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.placeholderPane = new PlaceholderPane();
        this.placeholder = new Label(Messages.General_No_data);
        this.placeholderPane.setPlaceholder(this.placeholder);
        ControlsPane controlPane = new ControlsPane();
        UiUtil.setTooltip((Node)controlPane.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)evt -> this.getViewFactory().createAny(newViews -> {
            if (this.newViewHandler != null) {
                newViews.forEach(this.newViewHandler::accept);
            }
            this.getViews().addAll(newViews);
        })), (ObservableValue<? extends Boolean>)new BooleanBinding(){
            {
                this.bind(new Observable[]{BaseGroupsWidget.this.controlButtonsRevalidationTrigger});
                this.bind(BaseGroupsWidget.this.controlButtonsCoordinator.getTriggers());
            }

            protected boolean computeValue() {
                return !BaseGroupsWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.ADD, -1);
            }
        }), Messages.General_Add_new_group);
        controlPane.visibleProperty().bind((ObservableValue)new BooleanBinding(){
            {
                this.bind(new Observable[]{BaseGroupsWidget.this.viewState.stateProperty()});
            }

            protected boolean computeValue() {
                return !BaseGroupsWidget.this.viewState.isImmutable();
            }
        });
        this.placeholderPane.setControlsPane(controlPane);
    }

    public void setNewViewHandler(Consumer<V> value) {
        this.newViewHandler = value;
    }

    protected Node getPlaceholderPane() {
        return this.placeholderPane;
    }

    public void setPlaceholder(String value) {
        this.placeholder.setText(value.length() > 0 ? Character.toUpperCase(value.charAt(0)) + value.substring(1) : value);
    }

    public void setControlButtonsAvailability(Predicate<ControlsPane.ButtonType> value) {
        this.controlButtonsAvailability = Objects.requireNonNull(value);
    }

    protected String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String value) {
        this.fieldName = value;
    }

    public void setConverter(ListItemStringConverter<V> value) {
        this.converter = Objects.requireNonNull(value);
    }

    public ListItemStringConverter<V> getConverter() {
        return this.converter;
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public MultiProvider<V> getViewFactory() {
        return this.viewFactory;
    }

    public void setViewFactory(MultiProvider<V> value) {
        this.viewFactory = Objects.requireNonNull(value);
    }

    public void setControlButtonsCoordinator(BiPredicate<ControlsPane.ButtonType, Integer> value, Observable ... triggers) {
        this.controlButtonsCoordinator.setPredicate(value);
        this.controlButtonsCoordinator.setTriggers(triggers);
    }

    public void revalidateControlButtons() {
        this.controlButtonsRevalidationTrigger.set(!this.controlButtonsRevalidationTrigger.get());
    }

    public ObservableList<V> getViews() {
        return this.views;
    }

    public abstract V getSelectedView();

    public abstract void selectView(V var1);

    protected boolean isMoveUpEnabled(V view) {
        return view != null && this.getViews().indexOf(view) > 0;
    }

    protected void doMoveUp(V view) {
        if (view == null) {
            return;
        }
        int idx = this.getViews().indexOf(view);
        FxUtil.swap(this.getViews(), idx - 1, idx);
    }

    protected boolean isMoveDownEnabled(V view) {
        return view != null && this.getViews().indexOf(view) < this.getViews().size() - 1;
    }

    protected void doMoveDown(V view) {
        if (view == null) {
            return;
        }
        int idx = this.getViews().indexOf(view);
        FxUtil.swap(this.getViews(), idx, idx + 1);
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return BaseGroupsWidget.this.getViews();
            }

            @Override
            public String getInfo() {
                return BaseGroupsWidget.this.getClass().getSimpleName() + DevTools.getViewStateInfo(BaseGroupsWidget.this.viewState);
            }
        };
    }
}

