/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.groups;

import com.gridnine.xtrip.client.fx.core.acl.AppliedAclData;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.BaseGroupsWidget;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public abstract class GroupsWidgetController<V extends Node, M, C extends ViewController<V, M>>
implements ViewController<BaseGroupsWidget<V>, Collection<M>> {
    private final IdentityHashMap<V, C> controllers = new IdentityHashMap();
    private boolean viewsChanged;
    private Collection<M> data;
    private AppliedAclData aclData;
    private String parentAclId;

    protected GroupsWidgetController() {
        ((BaseGroupsWidget)this.getView()).getViews().addListener(change -> {
            IdentityHashMap newControllers = new IdentityHashMap();
            for (Node view : ((BaseGroupsWidget)this.getView()).getViews()) {
                ViewController controller = (ViewController)this.controllers.get(view);
                if (controller == null) {
                    controller = this.createOrGetController(view);
                    if (this.aclData != null) {
                        controller.enforceAcl(this.aclData, this.parentAclId);
                    }
                }
                controller.setReadonly(((BaseGroupsWidget)this.getView()).getViewState().isReadonly());
                newControllers.put(view, controller);
            }
            this.controllers.clear();
            this.controllers.putAll(newControllers);
            this.viewsChanged = true;
        });
    }

    @Override
    public void enforceAcl(AppliedAclData acl, String parentId) {
        this.aclData = acl;
        this.parentAclId = parentId;
        this.controllers.values().forEach(controller -> controller.enforceAcl(this.aclData, this.parentAclId));
        if (!this.aclData.canEdit(this.parentAclId)) {
            ((BaseGroupsWidget)this.getView()).getViewState().setAclNotEditable(true);
        }
    }

    @Override
    public boolean isDataAclEnforceable() {
        return this.controllers.values().stream().anyMatch(ViewController::isDataAclEnforceable);
    }

    @Override
    public void enforceDataAcl(ViewController<?, DataTransferPackage<?, ?>> rootController, Set<String> deniedPermissions) {
        this.controllers.values().forEach(controller -> controller.enforceDataAcl(rootController, deniedPermissions));
    }

    @Override
    public Collection<M> getData() {
        return this.data;
    }

    @Override
    public void readData(Collection<M> model) {
        this.data = model;
        Object newSelectedView = null;
        Object selected = ((BaseGroupsWidget)this.getView()).getSelectedView();
        String selectedUid = selected == null ? null : (String)selected.getProperties().get((Object)"model-uid");
        ArrayList<V> views = new ArrayList<V>(model.size());
        for (M item : model) {
            V view = this.getOrCreateView(item);
            ViewController controller = (ViewController)this.controllers.get(view);
            if (controller == null) {
                controller = this.createOrGetController(view);
                if (this.aclData != null) {
                    controller.enforceAcl(this.aclData, this.parentAclId);
                }
                controller.setReadonly(((BaseGroupsWidget)this.getView()).getViewState().isReadonly());
                this.controllers.put(view, (C)controller);
            }
            if (item instanceof Identity) {
                String uid = ((Identity)item).getUid();
                view.getProperties().put((Object)"model-uid", (Object)uid);
                if (MiscUtil.equals((Object)selectedUid, (Object)uid)) {
                    newSelectedView = view;
                }
            }
            controller.readData(item);
            views.add(view);
        }
        ((BaseGroupsWidget)this.getView()).getViews().setAll(views);
        if (newSelectedView != null) {
            ((BaseGroupsWidget)this.getView()).selectView(newSelectedView);
        }
        this.viewsChanged = false;
    }

    private V getOrCreateView(M item) {
        if (!(item instanceof Identity)) {
            return (V)((Node)((BaseGroupsWidget)this.getView()).getViewFactory().createOne());
        }
        String uid = ((Identity)item).getUid();
        if (uid != null) {
            for (Node view : ((BaseGroupsWidget)this.getView()).getViews()) {
                if (!uid.equals(view.getProperties().get((Object)"model-uid"))) continue;
                return (V)view;
            }
        }
        return (V)((Node)((BaseGroupsWidget)this.getView()).getViewFactory().createOne());
    }

    @Override
    public void writeData(Collection<M> model) {
        ArrayList<M> list = new ArrayList<M>(((BaseGroupsWidget)this.getView()).getViews().size());
        Iterator<M> it = model.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof Identity) continue;
            it.remove();
        }
        for (Node view : ((BaseGroupsWidget)this.getView()).getViews()) {
            String viewUid;
            M item;
            ViewController controller = (ViewController)this.controllers.get(view);
            if (controller == null) {
                controller = this.createOrGetController(view);
                if (this.aclData != null) {
                    controller.enforceAcl(this.aclData, this.parentAclId);
                }
                controller.setReadonly(((BaseGroupsWidget)this.getView()).getViewState().isReadonly());
                this.controllers.put(view, (C)controller);
            }
            if ((item = this.getExisting(model, viewUid = (String)view.getProperties().get((Object)"model-uid"))) == null && (item = this.createItem()) instanceof Identity) {
                if (viewUid == null) {
                    viewUid = UUID.randomUUID().toString();
                }
                ((Identity)item).setUid(viewUid);
            }
            controller.writeData(item);
            if (item instanceof Identity) {
                view.getProperties().put((Object)"model-uid", (Object)((Identity)item).getUid());
            }
            list.add(item);
        }
        model.clear();
        model.addAll(list);
        this.viewsChanged = false;
    }

    @Override
    public boolean isReadonly() {
        return ((BaseGroupsWidget)this.getView()).getViewState().isReadonly();
    }

    @Override
    public void setReadonly(boolean value) {
        ((BaseGroupsWidget)this.getView()).getViewState().setReadonly(value);
        this.controllers.values().forEach(ctr -> ctr.setReadonly(value));
    }

    @Override
    public void setNotEditable(boolean notEditable) {
        ((BaseGroupsWidget)this.getView()).getViewState().setNotEditable(notEditable);
        this.controllers.values().forEach(ctr -> ctr.setNotEditable(notEditable));
    }

    @Override
    public void setAclNotEditable(boolean aclNotEditable) {
        ((BaseGroupsWidget)this.getView()).getViewState().setAclNotEditable(aclNotEditable);
        this.controllers.values().forEach(ctr -> ctr.setAclNotEditable(aclNotEditable));
    }

    @Override
    public boolean isDataChanged() {
        if (this.viewsChanged) {
            return true;
        }
        for (Node view : ((BaseGroupsWidget)this.getView()).getViews()) {
            ViewController controller = (ViewController)this.controllers.get(view);
            if (controller == null) {
                controller = this.createOrGetController(view);
                if (this.aclData != null) {
                    controller.enforceAcl(this.aclData, this.parentAclId);
                }
                controller.setReadonly(((BaseGroupsWidget)this.getView()).getViewState().isReadonly());
                this.controllers.put(view, (C)controller);
            }
            if (!controller.isDataChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validateData(List<Message> messages) {
        ControllersRegistry.validateData(this, messages);
        for (ViewController controller : this.controllers.values()) {
            controller.validateData(messages);
        }
    }

    private M getExisting(Collection<M> model, String uid) {
        if (uid == null || model.isEmpty()) {
            return null;
        }
        Iterator<M> it = model.iterator();
        while (it.hasNext()) {
            M item = it.next();
            if (!(item instanceof Identity) || !uid.equals(((Identity)item).getUid())) continue;
            it.remove();
            return item;
        }
        return null;
    }

    private C createOrGetController(V view) {
        ViewController<V, Object> controller = ViewController.forView(view);
        if (controller == null) {
            controller = this.createController(view);
        }
        return (C)controller;
    }

    protected abstract C createController(V var1);

    protected abstract M createItem();
}

