/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.groups;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.FilteringPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.BaseGroupsWidget;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

public class PlainGroupsWidget<V extends Node>
extends BaseGroupsWidget<V> {
    protected final StringProperty caption = new SimpleStringProperty();
    protected final ReadOnlyObjectWrapper<V> selectedView = new ReadOnlyObjectWrapper();
    private ContentPane contentPane;
    private FilteringPane<?> filteringPane;

    public PlainGroupsWidget(boolean ro) {
        super(ro);
        this.getStyleClass().add((Object)"plain-groups-widget");
        this.getViews().addListener(change -> FxUtil.submitToFxThread(() -> {
            if (this.getViews().isEmpty()) {
                this.setTop(this.getPlaceholderPane());
                this.setCenter(null);
                this.contentPane = null;
                this.selectedView.set(null);
                return;
            }
            if (this.contentPane == null) {
                this.contentPane = new ContentPane();
                this.setTop((Node)this.filteringPane);
                this.setCenter((Node)this.contentPane);
            }
            this.contentPane.updateState();
        }));
        this.setTop(this.getPlaceholderPane());
    }

    public void setCaption(String value) {
        this.caption.set((Object)value);
    }

    public ReadOnlyObjectProperty<V> selectedViewProperty() {
        return this.selectedView.getReadOnlyProperty();
    }

    @Override
    public V getSelectedView() {
        return (V)((Node)this.selectedView.get());
    }

    @Override
    public void selectView(V view) {
        if (this.contentPane != null && view != null) {
            this.contentPane.selectView(view);
        }
    }

    public <N extends Node> void setFiltering(Supplier<N> filtersPaneSupplier, Function<N, Predicate<V>> predicateSupplier, boolean collapsible) {
        FilteringPane<Node> pane = filtersPaneSupplier == null ? null : new FilteringPane<Node>(filtersPaneSupplier, collapsible);
        this.filteringPane = pane;
        if (this.filteringPane == null || !this.getViews().isEmpty()) {
            this.setTop((Node)this.filteringPane);
        }
        if (pane != null) {
            pane.setOnApply(filtersPane -> {
                Predicate predicate = (Predicate)predicateSupplier.apply(filtersPane);
                for (Node view : this.getViews()) {
                    if (predicate.test(view)) {
                        view.getProperties().remove((Object)"filteredOut");
                        continue;
                    }
                    view.getProperties().put((Object)"filteredOut", (Object)Boolean.TRUE);
                }
                this.contentPane.updateState();
                this.updateFilteringCaption();
            });
            this.updateFilteringCaption();
        } else {
            this.getViews().forEach(view -> view.getProperties().remove((Object)"filteredOut"));
            this.contentPane.updateState();
        }
    }

    private void updateFilteringCaption() {
        if (this.filteringPane == null) {
            return;
        }
        long filtered = this.getViews().stream().filter(view -> !view.getProperties().containsKey((Object)"filteredOut")).count();
        this.filteringPane.setCaption(Messages.getGeneral_Paging_filter(this.getFieldName(), filtered, this.getViews().size()));
    }

    class CellPane
    extends StackPane {
        protected final Supplier<V> itemSupplier;
        private final Label title;
        ControlsPane controlsPane;

        CellPane(Supplier<V> supplier) {
            this.setAlignment(Pos.CENTER_LEFT);
            this.itemSupplier = supplier;
            this.title = new CustomLabel();
            this.getChildren().add((Object)this.title);
            this.controlsPane = new ControlsPane();
            StackPane.setAlignment((Node)this.controlsPane, (Pos)Pos.CENTER_RIGHT);
            this.controlsPane.setMaxWidth(Double.NEGATIVE_INFINITY);
            if (PlainGroupsWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.DOWN)) {
                UiUtil.setTooltip((Node)this.controlsPane.addButton(ControlsPane.ButtonType.DOWN, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                    evt.consume();
                    PlainGroupsWidget.this.doMoveDown((Node)this.itemSupplier.get());
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{CellPane.this.hoverProperty()});
                    }

                    protected boolean computeValue() {
                        return !PlainGroupsWidget.this.isMoveDownEnabled((Node)CellPane.this.itemSupplier.get());
                    }
                }), Messages.General_Move_group_down_to_one);
            }
            if (PlainGroupsWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.UP)) {
                UiUtil.setTooltip((Node)this.controlsPane.addButton(ControlsPane.ButtonType.UP, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                    evt.consume();
                    PlainGroupsWidget.this.doMoveUp((Node)this.itemSupplier.get());
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{CellPane.this.hoverProperty()});
                    }

                    protected boolean computeValue() {
                        return !PlainGroupsWidget.this.isMoveUpEnabled((Node)CellPane.this.itemSupplier.get());
                    }
                }), Messages.General_Move_group_up_to_one);
            }
            if (PlainGroupsWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.REMOVE)) {
                UiUtil.setTooltip((Node)this.controlsPane.addButton(ControlsPane.ButtonType.REMOVE, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                    evt.consume();
                    PlainGroupsWidget.this.getViews().remove(this.itemSupplier.get());
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{PlainGroupsWidget.this.controlButtonsRevalidationTrigger});
                        this.bind(PlainGroupsWidget.this.controlButtonsCoordinator.getTriggers());
                    }

                    protected boolean computeValue() {
                        return !PlainGroupsWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.REMOVE, PlainGroupsWidget.this.getViews().indexOf(PlainGroupsWidget.this.selectedView.get()));
                    }
                }), Messages.General_Remove_group);
            }
            if (PlainGroupsWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.ADD)) {
                UiUtil.setTooltip((Node)this.controlsPane.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                    evt.consume();
                    PlainGroupsWidget.this.getViewFactory().createAny(newViews -> {
                        if (newViews.isEmpty()) {
                            return;
                        }
                        int idx = PlainGroupsWidget.this.getViews().indexOf(this.itemSupplier.get());
                        idx = idx == -1 ? PlainGroupsWidget.this.getViews().size() : ++idx;
                        if (PlainGroupsWidget.this.newViewHandler != null) {
                            newViews.forEach(PlainGroupsWidget.this.newViewHandler::accept);
                        }
                        PlainGroupsWidget.this.getViews().addAll(idx, newViews);
                        PlainGroupsWidget.this.selectView((Node)newViews.iterator().next());
                    });
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{PlainGroupsWidget.this.controlButtonsRevalidationTrigger});
                        this.bind(PlainGroupsWidget.this.controlButtonsCoordinator.getTriggers());
                    }

                    protected boolean computeValue() {
                        return !PlainGroupsWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.ADD, PlainGroupsWidget.this.getViews().indexOf(PlainGroupsWidget.this.selectedView.get()));
                    }
                }), Messages.General_Add_new_group);
            }
            this.getChildren().add((Object)this.controlsPane);
        }

        void updateState() {
            Node item = (Node)this.itemSupplier.get();
            this.title.setText(PlainGroupsWidget.this.getConverter().toString(item, PlainGroupsWidget.this.getViews().indexOf((Object)item)));
        }
    }

    private class ContentPane
    extends HBox {
        private final ListView<ValueHolder<V>> listView;
        private final StackPane payloadPane;

        ContentPane() {
            this.getStyleClass().add((Object)"content-pane");
            this.listView = new ListView();
            this.listView.setMaxWidth(Double.NEGATIVE_INFINITY);
            this.listView.setMinWidth(Double.NEGATIVE_INFINITY);
            this.listView.setCellFactory(lv -> new ListCell<ValueHolder<V>>(){
                private CellPane pane;

                protected void updateItem(ValueHolder<V> value, boolean empty) {
                    super.updateItem(value, empty);
                    if (empty || value == null) {
                        this.setGraphic(null);
                        return;
                    }
                    if (this.pane == null) {
                        this.pane = new CellPane(() -> {
                            ValueHolder result = (ValueHolder)this.getItem();
                            return result == null ? null : (Node)result.get();
                        });
                        this.pane.controlsPane.visibleProperty().bind((ObservableValue)new BooleanBinding(){
                            {
                                this.bind(new Observable[]{this.hoverProperty()});
                            }

                            protected boolean computeValue() {
                                return !PlainGroupsWidget.this.getViewState().isImmutable() && this.isHover();
                            }
                        });
                    }
                    this.pane.updateState();
                    this.setGraphic((Node)this.pane);
                }
            });
            CardsContainer cc = new CardsContainer();
            cc.getStyleClass().add((Object)"list-container");
            Card card = new Card("main", UiCardsContainer.Style.STATIC, (String)PlainGroupsWidget.this.caption.get(), this.listView);
            card.captionProperty().bind((ObservableValue)PlainGroupsWidget.this.caption);
            card.setAdaptiveHeight(true);
            cc.getCards().add(card);
            HBox.setHgrow((Node)cc, (Priority)Priority.NEVER);
            this.getChildren().add((Object)cc);
            this.payloadPane = new StackPane();
            HBox.setHgrow((Node)this.payloadPane, (Priority)Priority.ALWAYS);
            this.getChildren().add((Object)this.payloadPane);
            this.listView.getSelectionModel().selectedIndexProperty().addListener((src, o, n) -> this.updateContent());
        }

        private void updateContent() {
            ValueHolder item = (ValueHolder)this.listView.getSelectionModel().getSelectedItem();
            if (item == null) {
                this.payloadPane.getChildren().clear();
                PlainGroupsWidget.this.selectedView.set(null);
            } else {
                Node view = (Node)item.get();
                if (view instanceof CardsContainer) {
                    this.payloadPane.getChildren().setAll((Object[])new Node[]{view});
                } else {
                    CardsContainer cc = new CardsContainer();
                    Card<Node> card = new Card<Node>("main", UiCardsContainer.Style.STATIC, PlainGroupsWidget.this.getConverter().toString(view, PlainGroupsWidget.this.getViews().indexOf((Object)view)), view);
                    card.setAdaptiveHeight(true);
                    cc.getCards().add(card);
                    this.payloadPane.getChildren().setAll((Object[])new Node[]{cc});
                }
                PlainGroupsWidget.this.selectedView.set((Object)view);
            }
        }

        void selectView(V view) {
            int idx = 0;
            for (ValueHolder item : this.listView.getItems()) {
                if (((Node)item.get()).equals(view)) {
                    this.listView.getSelectionModel().select(idx);
                    break;
                }
                ++idx;
            }
        }

        void updateState() {
            ValueHolder selected = (ValueHolder)this.listView.getSelectionModel().getSelectedItem();
            int selectedIdx = 0;
            ArrayList<ValueHolder<Node>> items = new ArrayList<ValueHolder<Node>>(PlainGroupsWidget.this.getViews().size());
            for (Node view : PlainGroupsWidget.this.getViews()) {
                if (view.getProperties().containsKey((Object)"filteredOut")) continue;
                items.add(new ValueHolder<Node>(view));
                if (selected == null || !view.equals(selected.get())) continue;
                selectedIdx = items.size() - 1;
            }
            this.listView.getItems().setAll(items);
            if (!items.isEmpty()) {
                this.listView.getSelectionModel().select(selectedIdx);
            } else {
                this.listView.getSelectionModel().select(null);
            }
        }
    }
}

