/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.grouptable;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.PlaceholderPane;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomContextMenu;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import com.gridnine.xtrip.client.fx.core.lib.widgets.grouptable.GroupTableItem;
import com.gridnine.xtrip.client.fx.core.lib.widgets.grouptable.GroupTableItemModificationEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.grouptable.GroupTableWidgetRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableColumnOwner;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class GroupTableWidget<G, V>
extends BorderPane
implements HasViewState,
DevTool {
    private static final int MAX_LEVEL = 5;
    protected PlaceholderPane placeholderPane;
    protected GridPane dataPane;
    protected ControlsPane placeholderControls;
    protected GroupHandler<G> handler;
    protected Supplier<V> factory;
    protected ObjectProperty<EventHandler<GroupTableWidgetRowEvent>> onRowsAction;
    protected final List<TableWidgetColumn<V, ?>> columns = new ArrayList();
    protected final ViewState viewState = new ViewState();
    protected final BooleanProperty reorderable = new SimpleBooleanProperty();
    protected Header header;
    protected final ObservableMap<GroupTableItem<G, V>, Group> groups = FXCollections.observableHashMap();
    protected final ObservableMap<GroupTableItem<G, V>, Row> rows = FXCollections.observableHashMap();
    protected final GroupTableItem<G, V> root = new GroupTableItem();
    protected boolean moving;
    protected boolean changed;
    private CustomContextMenu contextMenu;
    private final TableColumnOwner<V> asOwner = new TableColumnOwner<V>(){

        @Override
        public ViewState getViewState() {
            return GroupTableWidget.this.viewState;
        }

        @Override
        public int indexOfRow(Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <N extends Node> N getWidget(TableWidgetColumn<V, N> column, int row) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <N extends Node> N getHiddenWidget(TableWidgetColumn<V, N> column, int row) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void injectWidget(int row, Node widget) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void ejectWidget(int row) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRowsCount() {
            return GroupTableWidget.this.rows.size();
        }
    };

    public GroupTableWidget(boolean ro) {
        this.createGUI();
        this.createBindings();
        this.createListeners();
        this.viewState.setReadonly(ro);
        this.reorderable.set(true);
    }

    private void createGUI() {
        this.getStyleClass().addAll((Object[])new String[]{"table-widget", "group-table-widget"});
        this.placeholderControls = this.createControlsPane();
        this.placeholderPane = new PlaceholderPane();
        this.placeholderPane.setPlaceholder(new Label(Messages.General_No_data));
        this.dataPane = new GridPane();
        this.dataPane.getStyleClass().add((Object)"grid-frame");
    }

    private ControlsPane createControlsPane() {
        ControlsPane pane = new ControlsPane();
        pane.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)event -> {
            if (event.getButton() == MouseButton.PRIMARY) {
                if (this.contextMenu != null && this.contextMenu.isShowing()) {
                    this.contextMenu.hide();
                    return;
                }
                this.contextMenu = this.createContextMenu(this.root, true, false, false);
                this.contextMenu.show((Node)event.getSource(), Side.BOTTOM, 0.0, 0.0);
            }
        }));
        return pane;
    }

    private void createBindings() {
    }

    private void createListeners() {
        this.viewState.stateProperty().addListener((s, o, n) -> this.update());
        this.reorderable.addListener((observable, oldValue, newValue) -> this.update());
        this.root.addEventHandler(GroupTableItemModificationEvent.treeTableItemAnyEvent(), event -> {
            if (event.getEventType() == GroupTableItemModificationEvent.treeTableItemChildrenModificationEvent()) {
                if (!this.moving) {
                    if (event.wasRemoved()) {
                        for (GroupTableItem item : event.getRemovedChildren()) {
                            this.handleRemove(item);
                        }
                    }
                    if (event.wasAdded()) {
                        for (GroupTableItem item : event.getAddedChildren()) {
                            this.handleAdd(item);
                        }
                    }
                }
                this.update();
                this.changed = true;
            }
        });
        this.groups.addListener(change -> {});
        this.rows.addListener(change -> {
            if (change.wasRemoved()) {
                this.fireEvent(new GroupTableWidgetRowEvent(null, null, GroupTableWidgetRowEvent.ROW_REMOVE, (Row)change.getValueRemoved()));
            }
            if (change.wasAdded()) {
                this.fireEvent(new GroupTableWidgetRowEvent(null, null, GroupTableWidgetRowEvent.ROW_ADD, (Row)change.getValueAdded()));
            }
        });
        this.sceneProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.update();
            }
        });
    }

    public void setColumns(List<TableWidgetColumn<V, ?>> columns) {
        for (TableWidgetColumn<V, ?> column : this.columns) {
            column.setOwner(null);
        }
        this.columns.clear();
        this.columns.addAll(columns);
        for (TableWidgetColumn<V, ?> column : this.columns) {
            column.setOwner(this.asOwner);
        }
        int size = columns.size() + 10;
        ArrayList<ColumnConstraints> constraints = new ArrayList<ColumnConstraints>(size);
        for (int i = 0; i < size; ++i) {
            ColumnConstraints columnConstraints = new ColumnConstraints();
            if (i >= 5 && i <= 5 + columns.size() - 1) {
                columnConstraints.setHgrow(Priority.ALWAYS);
                TableWidgetColumn<V, ?> column = columns.get(i - 5);
                if (column.getPrefWidth() != null) {
                    columnConstraints.setMinWidth(column.getPrefWidth().doubleValue());
                    columnConstraints.setPrefWidth(column.getPrefWidth().doubleValue());
                    columnConstraints.setMaxWidth(column.getPrefWidth().doubleValue());
                }
                if (column.getPrefWidthEm() != null) {
                    columnConstraints.setPercentWidth(column.getPrefWidthEm().doubleValue());
                }
            } else {
                columnConstraints.setHgrow(Priority.NEVER);
            }
            constraints.add(columnConstraints);
        }
        this.dataPane.getColumnConstraints().setAll(constraints);
    }

    public void setGroupHandler(GroupHandler<G> handler) {
        this.handler = handler;
    }

    public void setValueFactory(Supplier<V> factory) {
        this.factory = factory;
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public void setReorderable(boolean value) {
        this.reorderable.set(value);
    }

    public final ObjectProperty<EventHandler<GroupTableWidgetRowEvent>> onRowsActionProperty() {
        if (this.onRowsAction == null) {
            this.onRowsAction = new ObjectPropertyBase<EventHandler<GroupTableWidgetRowEvent>>(){

                protected void invalidated() {
                    GroupTableWidget.this.setEventHandler(GroupTableWidgetRowEvent.ROW_ANY, (EventHandler)this.get());
                }

                public Object getBean() {
                    return GroupTableWidget.this;
                }

                public String getName() {
                    return "onRowsAction";
                }
            };
        }
        return this.onRowsAction;
    }

    public final void setOnRowsAction(EventHandler<GroupTableWidgetRowEvent> value) {
        this.onRowsActionProperty().set(value);
    }

    public final EventHandler<GroupTableWidgetRowEvent> getOnRowsAction() {
        return this.onRowsAction != null ? (EventHandler)this.onRowsAction.get() : null;
    }

    private void update() {
        if (this.getScene() == null) {
            return;
        }
        this.setCenter((Node)(this.groups.size() > 0 || this.rows.size() > 0 ? this.dataPane : this.placeholderPane));
        if (this.viewState.isImmutable()) {
            this.placeholderPane.setControlsPane(null);
        } else {
            this.placeholderPane.setControlsPane(this.placeholderControls);
        }
        if (this.groups.size() > 0 || this.rows.size() > 0) {
            if (this.header == null) {
                this.header = new Header();
            }
            this.header.update();
        } else {
            if (this.header != null) {
                this.header.dispose();
            }
            this.header = null;
        }
        ValueHolder<Integer> level = new ValueHolder<Integer>(0);
        ValueHolder<Integer> index = new ValueHolder<Integer>(0);
        for (GroupTableItem childItem : this.root.getChildren()) {
            this.update(childItem, level, index);
        }
    }

    private void update(GroupTableItem<G, V> item, ValueHolder<Integer> level, ValueHolder<Integer> index) {
        Group group = (Group)this.groups.get(item);
        Row row = (Row)this.rows.get(item);
        if (group != null) {
            group.update(level.get(), index.get());
        }
        if (row != null) {
            row.update(group != null && !this.handler.isHidden(item.getGroup()) ? level.get() + 1 : level.get(), index.get());
        }
        if (group != null) {
            if (!this.handler.isHidden(item.getGroup())) {
                level.set(level.get() + 1);
            }
            if (item.getValue() == null && item.getChildren().size() == 0) {
                index.set(index.get() + 1);
            }
        }
        if (row != null) {
            index.set(index.get() + 1);
        }
        for (GroupTableItem childItem : item.getChildren()) {
            this.update(childItem, level, index);
        }
        if (group != null && !this.handler.isHidden(item.getGroup())) {
            level.set(level.get() - 1);
        }
    }

    private CustomContextMenu createContextMenu(GroupTableItem<G, V> item, boolean placeholder, boolean includeMove, boolean includeDelete) {
        CustomContextMenu contextMenu = new CustomContextMenu();
        contextMenu.getItems().clear();
        for (G group : this.handler.getSupplier().get()) {
            CustomMenuItem menuItem = new CustomMenuItem(this.handler.getName(group));
            if (!this.handler.isSimple(group)) {
                menuItem.setShape(this.handler.getMenuShape(group));
            }
            menuItem.setOnAction(event -> {
                GroupTableItem<Object, V> groupItem = new GroupTableItem<Object, V>();
                groupItem.setGroup(group);
                if (this.handler.isSimple(group)) {
                    groupItem.setValue(this.factory.get());
                }
                if (placeholder) {
                    this.add(item, groupItem, item.getChildren().size());
                } else {
                    GroupTableItem parentItem = item.getParent();
                    if (parentItem != null) {
                        int index = parentItem.getChildren().indexOf((Object)item);
                        this.add(parentItem, groupItem, index + 1);
                    }
                }
            });
            contextMenu.getItems().add((Object)menuItem);
        }
        if (includeMove && this.reorderable.get()) {
            CustomMenuItem upMenuItem = new CustomMenuItem(Messages.General_Move_up);
            upMenuItem.setOnAction(event -> this.move(item, false));
            contextMenu.getItems().add((Object)upMenuItem);
            CustomMenuItem downMenuItem = new CustomMenuItem(Messages.General_Move_down);
            downMenuItem.setOnAction(event -> this.move(item, true));
            contextMenu.getItems().add((Object)downMenuItem);
        }
        if (includeDelete) {
            CustomMenuItem deleteMenuItem = new CustomMenuItem(Messages.General_Remove_group);
            deleteMenuItem.setOnAction(event -> this.remove(item));
            contextMenu.getItems().add((Object)deleteMenuItem);
        }
        return contextMenu;
    }

    private void add(GroupTableItem<G, V> parent, GroupTableItem<G, V> item, int index) {
        parent.getChildren().add(index, item);
    }

    private void remove(GroupTableItem<G, V> item) {
        if (item.getParent() != null) {
            item.getParent().getChildren().remove(item);
        }
    }

    private void move(GroupTableItem<G, V> item, boolean down) {
        this.moving = true;
        GroupTableItem<G, V> parent = item.getParent();
        if (parent != null) {
            int index = parent.getChildren().indexOf(item);
            if (index < parent.getChildren().size() - 1 && down) {
                parent.getChildren().remove(item);
                parent.getChildren().add(index + 1, item);
            } else if (index > 0 && !down) {
                parent.getChildren().remove(item);
                parent.getChildren().add(index - 1, item);
            }
        }
        this.moving = false;
    }

    private void handleAdd(GroupTableItem<G, V> item) {
        if (item.getGroup() != null) {
            this.groups.put(item, (Object)new Group(item));
        }
        if (item.getValue() != null) {
            this.rows.put(item, (Object)new Row(item));
        }
        for (GroupTableItem child : item.getChildren()) {
            this.handleAdd(child);
        }
    }

    private void handleRemove(GroupTableItem<G, V> item) {
        Row row;
        Group group;
        if (item.getGroup() != null && (group = (Group)this.groups.remove(item)) != null) {
            group.dispose();
        }
        if (item.getValue() != null && (row = (Row)this.rows.remove(item)) != null) {
            row.dispose();
        }
        for (GroupTableItem child : item.getChildren()) {
            this.handleRemove(child);
        }
    }

    private void handleRead(GroupTableItem<G, V> item) {
        Row row;
        Group group;
        if (item.getGroup() != null && (group = (Group)this.groups.get(item)) != null) {
            group.readData();
        }
        if (item.getValue() != null && (row = (Row)this.rows.get(item)) != null) {
            row.readData();
        }
        for (GroupTableItem child : item.getChildren()) {
            this.handleRead(child);
        }
    }

    private void handleWrite(GroupTableItem<G, V> item) {
        Row row;
        Group group;
        if (item.getGroup() != null && (group = (Group)this.groups.get(item)) != null) {
            group.writeData();
        }
        if (item.getValue() != null && (row = (Row)this.rows.get(item)) != null) {
            row.writeData();
        }
        for (GroupTableItem child : item.getChildren()) {
            this.handleWrite(child);
        }
    }

    public boolean isDataChanged() {
        if (this.changed) {
            return true;
        }
        for (Group group : this.groups.values()) {
            if (!group.isDataChanged()) continue;
            return true;
        }
        for (Row row : this.rows.values()) {
            if (!row.isDataChanged()) continue;
            return true;
        }
        return false;
    }

    public void readData(Collection<GroupTableItem<G, V>> model) {
        while (this.root.getChildren().size() > 0) {
            this.remove((GroupTableItem)this.root.getChildren().get(0));
        }
        for (GroupTableItem<G, V> item : model) {
            this.add(this.root, item, this.root.getChildren().size());
            this.handleRead(item);
        }
        this.changed = false;
    }

    public void writeData(Collection<GroupTableItem<G, V>> model) {
        for (GroupTableItem item : this.root.getChildren()) {
            this.handleWrite(item);
        }
        model.clear();
        model.addAll((Collection<GroupTableItem<G, V>>)this.root.getChildren());
        this.changed = false;
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return Collections.unmodifiableList(GroupTableWidget.this.columns);
            }

            @Override
            public String getInfo() {
                return GroupTableWidget.this.getClass().getSimpleName() + DevTools.getViewStateInfo(GroupTableWidget.this.viewState);
            }
        };
    }

    class Row {
        private final GroupTableItem<G, V> item;
        private Node downButton;
        private Node upButton;
        private Node removeButton;
        private Node addButton;
        private final List<Node> cells;

        Row(GroupTableItem<G, V> item) {
            this.cells = new ArrayList<Node>(GroupTableWidget.this.columns.size());
            this.item = item;
            this.createGUI();
            this.createBindings();
            this.createListeners();
        }

        private void createGUI() {
            int count = 0;
            for (TableWidgetColumn column : GroupTableWidget.this.columns) {
                Object node = column.createNode();
                if (node instanceof Region) {
                    Region region = (Region)node;
                    region.setMinWidth(-1.0);
                    region.setPrefWidth(0.0);
                    region.setMaxWidth(Double.MAX_VALUE);
                }
                GridPane cell = new GridPane();
                cell.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
                cell.setMinWidth(-1.0);
                cell.setPrefWidth(0.0);
                cell.setMaxWidth(Double.MAX_VALUE);
                UiUtil.gridPosition(cell, node).col(0).row(0).hGrow(Priority.ALWAYS).vGrow(Priority.NEVER).place();
                if (count == GroupTableWidget.this.columns.size() - 1) {
                    Node controls = this.createControlsPanel();
                    UiUtil.gridPosition(cell, controls).col(1).row(0).hGrow(Priority.NEVER).vGrow(Priority.ALWAYS).place();
                }
                this.cells.add((Node)cell);
                ++count;
            }
            GroupTableWidget.this.dataPane.getChildren().addAll(this.cells);
        }

        private Node createControlsPanel() {
            this.downButton = ControlsPane.createButton(ControlsPane.ButtonType.DOWN, (EventHandler<? super MouseEvent>)((EventHandler)event -> {
                if (event.getButton() == MouseButton.PRIMARY) {
                    GroupTableWidget.this.move(this.item, true);
                }
            }));
            Tooltip.install((Node)this.downButton, (Tooltip)new Tooltip(Messages.General_Move_line_down_to_one));
            this.upButton = ControlsPane.createButton(ControlsPane.ButtonType.UP, (EventHandler<? super MouseEvent>)((EventHandler)event -> {
                if (event.getButton() == MouseButton.PRIMARY) {
                    GroupTableWidget.this.move(this.item, false);
                }
            }));
            Tooltip.install((Node)this.upButton, (Tooltip)new Tooltip(Messages.General_Move_line_up_to_one));
            this.removeButton = ControlsPane.createButton(ControlsPane.ButtonType.REMOVE, (EventHandler<? super MouseEvent>)((EventHandler)event -> {
                if (event.getButton() == MouseButton.PRIMARY) {
                    GroupTableWidget.this.remove(this.item);
                }
            }));
            Tooltip.install((Node)this.removeButton, (Tooltip)new Tooltip(Messages.General_Remove_line));
            this.addButton = ControlsPane.createButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)event -> {
                if (event.getButton() == MouseButton.PRIMARY) {
                    if (GroupTableWidget.this.contextMenu != null && GroupTableWidget.this.contextMenu.isShowing()) {
                        GroupTableWidget.this.contextMenu.hide();
                        return;
                    }
                    GroupTableWidget.this.contextMenu = GroupTableWidget.this.createContextMenu(this.item, false, false, false);
                    GroupTableWidget.this.contextMenu.show(this.addButton, Side.BOTTOM, 0.0, 0.0);
                }
            }));
            Tooltip.install((Node)this.addButton, (Tooltip)new Tooltip(Messages.General_Add_new_line_after_this));
            ControlsPane pane = new ControlsPane();
            pane.getChildren().setAll((Object[])new Node[]{this.downButton, this.upButton, this.removeButton, this.addButton});
            pane.setMinWidth(Double.NEGATIVE_INFINITY);
            return pane;
        }

        private void createBindings() {
        }

        private void createListeners() {
        }

        boolean isDataChanged() {
            int count = 0;
            for (Node node : this.cells) {
                TableWidgetColumn column = GroupTableWidget.this.columns.get(count);
                if (column.isDataChanged(this.item.getValue(), (Node)((GridPane)node).getChildren().get(0))) {
                    return true;
                }
                ++count;
            }
            return false;
        }

        void readData() {
            int count = 0;
            for (Node node : this.cells) {
                TableWidgetColumn column = GroupTableWidget.this.columns.get(count);
                column.readData(this.item.getValue(), (Node)((GridPane)node).getChildren().get(0));
                ++count;
            }
        }

        void writeData() {
            int count = 0;
            for (Node node : this.cells) {
                TableWidgetColumn column = GroupTableWidget.this.columns.get(count);
                column.writeData(this.item.getValue(), (Node)((GridPane)node).getChildren().get(0));
                ++count;
            }
        }

        boolean canMoveUp() {
            return this.item.getParent() != null ? this.item.getParent().getChildren().indexOf(this.item) > 0 : false;
        }

        boolean canMoveDown() {
            return this.item.getParent() != null ? this.item.getParent().getChildren().indexOf(this.item) < this.item.getParent().getChildren().size() - 1 : false;
        }

        void update(int level, int index) {
            this.downButton.setDisable(!this.canMoveDown());
            this.upButton.setDisable(!this.canMoveUp());
            UiUtil.setHidden(this.downButton, GroupTableWidget.this.viewState.isImmutable() || !GroupTableWidget.this.reorderable.get());
            UiUtil.setHidden(this.upButton, GroupTableWidget.this.viewState.isImmutable() || !GroupTableWidget.this.reorderable.get());
            UiUtil.setHidden(this.removeButton, GroupTableWidget.this.viewState.isImmutable());
            UiUtil.setHidden(this.addButton, GroupTableWidget.this.viewState.isImmutable());
            boolean last = this.isLast(this.item);
            int count = 0;
            for (Node node : this.cells) {
                TableWidgetColumn column = GroupTableWidget.this.columns.get(count);
                column.setReadonly((Node)((GridPane)node).getChildren().get(0), GroupTableWidget.this.viewState.isImmutable());
                int columnIndex = count == 0 ? level : 5 + count;
                int rowIndex = index + 1;
                int columnSpan = count == 0 || count == this.cells.size() - 1 ? 6 - level : 1;
                int rowSpan = 1;
                GridPane.setConstraints((Node)node, (int)columnIndex, (int)rowIndex, (int)columnSpan, (int)rowSpan);
                node.pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, count == this.cells.size() - 1 && level == 0);
                node.pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, last);
                ++count;
            }
        }

        void dispose() {
            GroupTableWidget.this.dataPane.getChildren().removeAll(this.cells);
        }

        <N extends Node> N getWidget(TableWidgetColumn<V, N> column) {
            return (N)((Node)((GridPane)this.cells.get(GroupTableWidget.this.columns.indexOf(column))).getChildren().get(0));
        }

        private boolean isLast(GroupTableItem<G, V> item) {
            if (item.getParent() == null) {
                return true;
            }
            return item.getParent().getChildren().get(item.getParent().getChildren().size() - 1) == item && this.isLast(item.getParent());
        }
    }

    class Group {
        private final GroupTableItem<G, V> item;
        private Pane leftPane;
        private Pane rightPane;
        private PlaceholderPane placeholder;
        private Node leftCell;
        private Node rightCell;
        private Pane centerCell;

        Group(GroupTableItem<G, V> item) {
            this.item = item;
            this.createGUI();
            this.createBindings();
            this.createListeners();
        }

        private void createGUI() {
            this.leftPane = new StackPane();
            this.leftPane.setMaxWidth(Double.NEGATIVE_INFINITY);
            this.leftPane.setMinWidth(Double.NEGATIVE_INFINITY);
            IconNode icon = new IconNode(GroupTableWidget.this.handler.getGroupShape(this.item.getGroup()), StandardIconIntentions.GROUP_TABLE_LEFT_MENU);
            icon.getStyleClass().add((Object)"group-icon");
            this.leftPane.getChildren().add((Object)icon);
            this.leftCell = new StackPane(new Node[]{this.leftPane});
            this.leftCell.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
            this.rightPane = new StackPane();
            this.rightPane.setMaxWidth(Double.NEGATIVE_INFINITY);
            this.rightPane.setMinWidth(Double.NEGATIVE_INFINITY);
            icon = new IconNode(StandardIconShapes.DOTS_22X14, StandardIconIntentions.GROUP_TABLE_RIGHT_MENU);
            icon.getStyleClass().add((Object)"group-icon");
            this.rightPane.getChildren().add((Object)icon);
            this.rightCell = new StackPane(new Node[]{this.rightPane});
            this.rightCell.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
            this.placeholder = new PlaceholderPane();
            this.placeholder.setPlaceholder(new Label(GroupTableWidget.this.getViewState().isImmutable() ? "\u2014" : UiUtil.NULL_TEXT));
            this.placeholder.setControlsPane(this.createControlsPane());
            this.centerCell = new StackPane(new Node[]{this.placeholder});
            this.centerCell.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
            this.centerCell.setMinWidth(-1.0);
            this.centerCell.setPrefWidth(0.0);
            this.centerCell.setMaxWidth(Double.MAX_VALUE);
            GroupTableWidget.this.dataPane.getChildren().addAll((Object[])new Node[]{this.leftCell, this.rightCell, this.centerCell});
        }

        private ControlsPane createControlsPane() {
            ControlsPane pane = new ControlsPane();
            pane.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)event -> {
                if (event.getButton() == MouseButton.PRIMARY) {
                    if (GroupTableWidget.this.contextMenu != null && GroupTableWidget.this.contextMenu.isShowing()) {
                        GroupTableWidget.this.contextMenu.hide();
                        return;
                    }
                    GroupTableWidget.this.contextMenu = GroupTableWidget.this.createContextMenu(this.item, true, false, false);
                    GroupTableWidget.this.contextMenu.show((Node)event.getSource(), Side.BOTTOM, 0.0, 0.0);
                }
            }));
            return pane;
        }

        private void createBindings() {
        }

        private void createListeners() {
            this.rightPane.setOnMousePressed(event -> {
                if (event.getButton() == MouseButton.PRIMARY) {
                    if (GroupTableWidget.this.contextMenu != null && GroupTableWidget.this.contextMenu.isShowing()) {
                        GroupTableWidget.this.contextMenu.hide();
                        return;
                    }
                    GroupTableWidget.this.contextMenu = GroupTableWidget.this.createContextMenu(this.item, false, true, true);
                    GroupTableWidget.this.contextMenu.show((Node)this.rightPane, Side.BOTTOM, 0.0, 0.0);
                }
            });
        }

        boolean isDataChanged() {
            return false;
        }

        void readData() {
        }

        void writeData() {
        }

        void update(int level, int index) {
            int rowSpan;
            int columnSpan;
            int rowIndex;
            int columnIndex;
            this.leftPane.setDisable(GroupTableWidget.this.viewState.isImmutable());
            this.rightPane.setDisable(GroupTableWidget.this.viewState.isImmutable());
            boolean hidden = GroupTableWidget.this.handler.isHidden(this.item.getGroup());
            UiUtil.setHidden(this.leftCell, hidden);
            UiUtil.setHidden(this.rightCell, hidden);
            UiUtil.setHidden((Node)this.centerCell, this.item.getValue() != null || this.item.getChildren().size() > 0);
            int count = this.count(this.item);
            if (!hidden) {
                columnIndex = level;
                rowIndex = index + 1;
                columnSpan = 1;
                rowSpan = count;
                GridPane.setConstraints((Node)this.leftCell, (int)columnIndex, (int)rowIndex, (int)columnSpan, (int)rowSpan);
                columnIndex = GroupTableWidget.this.columns.size() + 10 - level - 1;
                GridPane.setConstraints((Node)this.rightCell, (int)columnIndex, (int)rowIndex, (int)columnSpan, (int)rowSpan);
            }
            columnIndex = hidden ? level : level + 1;
            rowIndex = index + 1;
            columnSpan = GroupTableWidget.this.columns.size() + (5 - (hidden ? level : level + 1)) * 2;
            rowSpan = count;
            GridPane.setConstraints((Node)this.centerCell, (int)columnIndex, (int)rowIndex, (int)columnSpan, (int)rowSpan);
            if (!hidden) {
                this.rightCell.pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, level == 0);
            } else {
                this.centerCell.pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, level == 0);
            }
            boolean last = this.isLast(this.item);
            this.leftCell.pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, last);
            this.rightCell.pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, last);
            this.centerCell.pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, last);
        }

        void dispose() {
            GroupTableWidget.this.dataPane.getChildren().removeAll((Object[])new Node[]{this.leftCell, this.rightCell, this.centerCell});
        }

        private int count(GroupTableItem<G, V> item) {
            if (item.getChildren().size() > 0) {
                int count = 0;
                for (GroupTableItem childItem : item.getChildren()) {
                    count += this.count(childItem);
                }
                return count;
            }
            return 1;
        }

        private boolean isLast(GroupTableItem<G, V> item) {
            if (item.getParent() == null) {
                return true;
            }
            return item.getParent().getChildren().get(item.getParent().getChildren().size() - 1) == item && this.isLast(item.getParent());
        }
    }

    class Header {
        private final List<Node> cells;

        Header() {
            this.cells = new ArrayList<Node>(GroupTableWidget.this.columns.size());
            this.createGUI();
            this.createBindings();
            this.createListeners();
        }

        private void createGUI() {
            for (TableWidgetColumn column : GroupTableWidget.this.columns) {
                Label node = new Label(column.getCaption());
                StackPane cell = new StackPane(new Node[]{node});
                cell.getStyleClass().addAll((Object[])new String[]{"header-cell", "grid-cell"});
                cell.setMinWidth(-1.0);
                cell.setPrefWidth(0.0);
                cell.setMaxWidth(Double.MAX_VALUE);
                this.cells.add((Node)cell);
            }
            GroupTableWidget.this.dataPane.getChildren().addAll(this.cells);
        }

        private void createBindings() {
        }

        private void createListeners() {
        }

        void update() {
            int count = 0;
            for (Node cell : this.cells) {
                int columnIndex = count == 0 ? 0 : 5 + count;
                int rowIndex = 0;
                int columnSpan = count == 0 || count == this.cells.size() - 1 ? 6 : 1;
                int rowSpan = 1;
                GridPane.setConstraints((Node)cell, (int)columnIndex, (int)rowIndex, (int)columnSpan, (int)rowSpan);
                cell.pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, count == this.cells.size() - 1);
                ++count;
            }
        }

        void dispose() {
            GroupTableWidget.this.dataPane.getChildren().removeAll(this.cells);
        }
    }

    public static interface GroupHandler<G> {
        public String getName(G var1);

        public IconShape getGroupShape(G var1);

        public IconShape getMenuShape(G var1);

        public boolean isSimple(G var1);

        public boolean isHidden(G var1);

        public Supplier<List<G>> getSupplier();
    }
}

