/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.metadata;

import com.gridnine.xtrip.client.fx.core.entity.metadata.MetadataBasedEditor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.layout.StackPane;

public class MetadataWidget<E extends BaseEntity>
extends StackPane
implements HasValue<E>,
HasViewState {
    private ViewController<MetadataBasedEditor<E>, EntityContainer<BaseEntity>> controller;
    private final ObjectProperty<E> settingsValue = new SimpleObjectProperty();
    private final ViewState viewState = new ViewState();

    public MetadataWidget(Class<E> entityClass) {
        FxUtil.addListener(this.settingsValue, (observable, oldValue, newValue) -> {
            EntityType entityType = newValue == null ? (EntityType)MetaRegistry.get().getEntities().get(entityClass.getName()) : (EntityType)MetaRegistry.get().getEntities().get(newValue.getClass().getName());
            try {
                this.controller = MetadataBasedEditor.createController(entityType, (type, s) -> true);
                this.getChildren().clear();
                this.getChildren().add(this.controller.getView());
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
            }
        });
        this.viewState.stateProperty().addListener((s, o, n) -> {
            this.controller.setReadonly(ViewState.isReadonly(n.intValue()));
            this.controller.setNotEditable(ViewState.isNotEditable(n.intValue()));
        });
    }

    public MetadataBasedEditor<E> getView() {
        return this.controller.getView();
    }

    public void readData(E model) {
        this.controller.readData((EntityContainer<BaseEntity>)EntityContainer.create(model));
    }

    public void writeData(E model) {
        this.controller.writeData((EntityContainer<BaseEntity>)EntityContainer.create(model));
    }

    public boolean isDataChanged() {
        return this.controller.isDataChanged();
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    @Override
    public ObjectProperty<E> valueProperty() {
        return this.settingsValue;
    }
}

