/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.multi;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.dicts.list.DictsListPane;
import com.gridnine.xtrip.client.fx.core.dicts.list.DictsListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.table.CustomTableView;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.BaseMultiWidget;
import com.gridnine.xtrip.client.fx.core.service.DictEditingService;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;

public class MultiDictWidget<D extends BaseDictionary>
extends BaseMultiWidget<DictionaryReference<D>> {
    protected final Class<D> dictType;
    private Supplier<List<DictionaryReference<D>>> itemsSupplier;
    private boolean itemsSupplierAsync;
    protected DictBoxWidget.DictMultiSupplier<? extends D> listParametersSupplier;

    public MultiDictWidget(Class<D> dictCls, boolean readonly) {
        super(readonly);
        this.dictType = dictCls;
        this.listParametersSupplier = DictBoxWidget.createDefaultListParametersSupplier(this.dictType);
    }

    public void setItemsSupplier(Supplier<List<DictionaryReference<D>>> supplier, boolean async) {
        this.itemsSupplier = supplier;
        this.itemsSupplierAsync = async;
    }

    public void setListParametersSupplier(final Supplier<DictListParameters> value) {
        this.listParametersSupplier = new DictBoxWidget.DictMultiSupplier<D>(){

            @Override
            public int count() {
                return 1;
            }

            @Override
            public String getDisplayName(int idx) {
                return null;
            }

            @Override
            public DictListParameters get(int idx) {
                return (DictListParameters)value.get();
            }

            @Override
            public Class<D> getDictType(int idx) {
                return MultiDictWidget.this.dictType;
            }
        };
    }

    public void setListParametersSupplier(DictBoxWidget.DictMultiSupplier<? extends D> value) {
        this.listParametersSupplier = value;
    }

    @Override
    protected boolean isLimited() {
        return true;
    }

    @Override
    protected Node createNode(int valueIdx) {
        DictBoxWidget<D> result = new DictBoxWidget<D>(this.dictType, this.getViewState().isReadonly());
        result.getViewState().setState(this.getViewState().getState());
        result.setFieldName(this.getFieldName());
        result.setMaxWidth(Double.MAX_VALUE);
        if (this.itemsSupplier != null) {
            result.setItemsSupplier(this.itemsSupplier, this.itemsSupplierAsync);
        }
        if (this.listParametersSupplier != null) {
            result.setListParametersSupplier(this.listParametersSupplier);
        }
        result.setValue((DictionaryReference)this.getValues().get(valueIdx));
        result.valueProperty().addListener((s, o, n) -> {
            DictionaryReference cfr_ignored_0 = (DictionaryReference)this.getValues().set(valueIdx, n);
        });
        return result;
    }

    @Override
    protected void addNew(int valueIdx) {
        if (this.itemsSupplier != null || this.listParametersSupplier == null) {
            this.getValues().add(valueIdx, null);
            return;
        }
        DictsListPane pane = new DictsListPane(new ObservableMutex(), new MultiSupplier<DictsListPaneConfiguration>(){

            @Override
            public int count() {
                return MultiDictWidget.this.listParametersSupplier.count();
            }

            @Override
            public String getDisplayName(int idx) {
                return MultiDictWidget.this.listParametersSupplier.getDisplayName(idx);
            }

            @Override
            public DictsListPaneConfiguration get(int idx) {
                DictsListPaneConfiguration result = new DictsListPaneConfiguration(DictHandler.forDictClass(MultiDictWidget.this.listParametersSupplier.getDictType(idx)));
                result.setSelectionMode(SelectionMode.MULTIPLE);
                result.setPatternSearchEnabled(true);
                result.setActionsEnabled(false);
                result.applyParameters((DictListParameters)MultiDictWidget.this.listParametersSupplier.get(idx));
                return result;
            }
        }){

            @Override
            protected void newConfigurationPopulated() {
                super.newConfigurationPopulated();
                this.getTableView().getColumns().add(TableColumnSettings.createActionColumn(item -> DictEditingService.get().open(item.getReference())));
            }
        };
        new Dialog().setTitle(Messages.getWritingField(this.getFieldName())).setBody((Node)pane).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE, Messages.General_Cancel).addButton(DialogButtonStyle.AUXILARY, Messages.Select_all, () -> BaseMultiWidget.massiveAdd(this, () -> {
            try {
                ValueHolder query = new ValueHolder();
                ValueHolder dictHandler = new ValueHolder();
                FxUtil.waitForFxThread(() -> {
                    query.set(pane.buildQuery());
                    dictHandler.set(pane.getDictHandler());
                });
                ((DictQuery)query.get()).getFields().clear();
                if (((DictQuery)query.get()).getSorting().isEmpty()) {
                    ((DictQuery)query.get()).getSorting().put(BaseDictionary.Property.code.name(), SortOrder.ASC);
                }
                ((DictQuery)query.get()).setLimit(200);
                ((DictQuery)query.get()).setOffset(0);
                DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
                ArrayList result = new ArrayList(200);
                while (true) {
                    List list = dictService.search(ServiceInvocationContext.get(), ((DictHandler)dictHandler.get()).getDictType(), (DictQuery)query.get());
                    list.stream().map(DictItem::getReference).collect(Collectors.toCollection(() -> result));
                    if (list.size() < ((DictQuery)query.get()).getLimit()) break;
                    ((DictQuery)query.get()).setOffset(((DictQuery)query.get()).getOffset() + ((DictQuery)query.get()).getLimit());
                }
                return result;
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
                return Collections.emptyList();
            }
        })).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.General_Choose, () -> {
            List items = pane.getSelectedItems();
            this.getValues().addAll(valueIdx, (Collection)items.stream().map(DictItem::getReference).filter(ref -> !this.getValues().contains(ref)).collect(Collectors.toList()));
        }, (BooleanExpression)pane.selectionPresentProperty()).show((Node)this);
    }

    @Override
    protected void configureFullDataTable(CustomTableView<DictionaryReference<D>> tableView) {
        super.configureFullDataTable(tableView);
        tableView.getColumns().add(TableColumnSettings.createActionColumn(item -> DictEditingService.get().open((DictionaryReference<?>)item)));
    }
}

