/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.multi;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.table.CustomTableView;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.BaseEntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.BaseMultiWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;

public class MultiEntityWidget<E extends BaseEntity>
extends BaseMultiWidget<EntityReference<E>> {
    private final Class<E> entityType;
    private Supplier<List<EntityReference<E>>> itemsSupplier;
    private boolean itemsSupplierAsync;
    protected MultiSupplier<IndexListParameters<E, ?>> listParametersSupplier;
    private boolean noNulls;

    public MultiEntityWidget(Class<E> entityCls, boolean readonly) {
        super(readonly);
        this.entityType = entityCls;
        this.listParametersSupplier = BaseEntityBoxWidget.createDefaultListParametersSupplier(this.entityType);
    }

    public void setItemsSupplier(Supplier<List<EntityReference<E>>> supplier, boolean async) {
        this.itemsSupplier = supplier;
        this.itemsSupplierAsync = async;
    }

    public void setListParametersSupplier(final Supplier<IndexListParameters<E, ?>> value) {
        this.listParametersSupplier = new MultiSupplier<IndexListParameters<E, ?>>(){

            @Override
            public int count() {
                return 1;
            }

            @Override
            public String getDisplayName(int idx) {
                return null;
            }

            @Override
            public IndexListParameters<E, ?> get(int idx) {
                return (IndexListParameters)value.get();
            }
        };
    }

    public void setListParametersSupplier(MultiSupplier<IndexListParameters<E, ?>> value) {
        this.listParametersSupplier = value;
    }

    public void setNoNulls(boolean noNulls) {
        this.noNulls = noNulls;
    }

    @Override
    protected boolean isLimited() {
        return true;
    }

    @Override
    protected Node createNode(int valueIdx) {
        EntityBoxWidget<E> result = new EntityBoxWidget<E>(this.entityType, this.getViewState().isReadonly());
        result.getViewState().setState(this.getViewState().getState());
        result.setFieldName(this.getFieldName());
        result.setMaxWidth(Double.MAX_VALUE);
        if (this.itemsSupplier != null) {
            result.setItemsSupplier(this.itemsSupplier, this.itemsSupplierAsync);
        }
        if (this.listParametersSupplier != null) {
            result.setListParametersSupplier(this.listParametersSupplier);
        }
        result.setNoNulls(this.noNulls);
        result.setValue((EntityReference)this.getValues().get(valueIdx));
        result.valueProperty().addListener((s, o, n) -> {
            EntityReference cfr_ignored_0 = (EntityReference)this.getValues().set(valueIdx, n);
        });
        return result;
    }

    @Override
    protected void addNew(int valueIdx) {
        if (this.itemsSupplier != null || this.listParametersSupplier == null) {
            this.getValues().add(valueIdx, null);
            return;
        }
        IndexListPane pane = new IndexListPane<E, EntityIndex<E>>(new ObservableMutex(), new MultiSupplier<IndexListPaneConfiguration<E, EntityIndex<E>>>(){

            @Override
            public int count() {
                return MultiEntityWidget.this.listParametersSupplier.count();
            }

            @Override
            public String getDisplayName(int idx) {
                return MultiEntityWidget.this.listParametersSupplier.getDisplayName(idx);
            }

            @Override
            public IndexListPaneConfiguration<E, EntityIndex<E>> get(int idx) {
                IndexListParameters parameters = MultiEntityWidget.this.listParametersSupplier.get(idx);
                IndexListPaneConfiguration result = new IndexListPaneConfiguration(parameters.getIndexType());
                result.setSelectionMode(SelectionMode.MULTIPLE);
                result.setPatternSearchEnabled(true);
                result.setActionsEnabled(false);
                result.setLimit(parameters.getLimit());
                result.applyParameters(parameters);
                return result;
            }
        }){

            @Override
            protected void newConfigurationPopulated() {
                super.newConfigurationPopulated();
                this.getTableView().getColumns().add(TableColumnSettings.createActionColumn(item -> RootEntityEditingService.navigateTo(item.getSource())));
            }
        };
        new Dialog().setTitle(Messages.getWritingField(this.getFieldName())).setBody((Node)pane).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE, Messages.General_Cancel).addButton(DialogButtonStyle.AUXILARY, Messages.Select_all, () -> BaseMultiWidget.massiveAdd(this, () -> {
            try {
                ValueHolder query = new ValueHolder();
                ValueHolder indexType = new ValueHolder();
                FxUtil.waitForFxThread(() -> {
                    query.set(pane.buildQuery());
                    indexType.set(((IndexListPaneConfiguration)pane.getConfiguration()).getIndexType());
                });
                ((SearchQuery)query.get()).getPreferredProperties().clear();
                ((SearchQuery)query.get()).getPreferredProperties().add("containerUid");
                ((SearchQuery)query.get()).setLimit(0);
                ((SearchQuery)query.get()).setOffset(0);
                return ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), (Class)indexType.get(), (SearchQuery)query.get()).stream().map(EntityIndex::getSource).collect(Collectors.toList());
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
                return Collections.emptyList();
            }
        })).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.General_Choose, () -> {
            List items = pane.getSelectedItems();
            this.getValues().addAll(valueIdx, (Collection)items.stream().map(EntityIndex::getSource).filter(ref -> !this.getValues().contains(ref)).collect(Collectors.toList()));
        }, (BooleanExpression)pane.selectionPresentProperty()).show((Node)this);
    }

    @Override
    protected void configureFullDataTable(CustomTableView<EntityReference<E>> tableView) {
        super.configureFullDataTable(tableView);
        tableView.getColumns().add(TableColumnSettings.createActionColumn(item -> RootEntityEditingService.navigateTo(item)));
    }
}

