/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.multi;

import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.BaseMultiWidget;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;

public class MultiTextWidget
extends BaseMultiWidget<String> {
    private final ObservableList<String> displayedValues = FXCollections.observableArrayList();

    public MultiTextWidget(boolean readonly) {
        super(readonly);
    }

    public ObservableList<String> getDisplayedValues() {
        return this.displayedValues;
    }

    @Override
    protected Node createNode(int valueIdx) {
        TextFieldWidget result = new TextFieldWidget(this.getViewState().isReadonly());
        result.getViewState().setState(this.getViewState().getState());
        result.setMaxWidth(Double.MAX_VALUE);
        result.setValue((String)this.getValues().get(valueIdx));
        AtomicBoolean valueChanged = new AtomicBoolean(false);
        result.controlFocusedProperty().addListener((s, o, n) -> {
            if (!n.booleanValue() && valueChanged.get()) {
                this.getValues().set(valueIdx, (Object)result.getValue());
                valueChanged.set(false);
            }
        });
        result.valueProperty().addListener((c, o, n) -> {
            valueChanged.set(true);
            this.updateDisplayedValues();
        });
        result.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.ENTER) {
                this.addNew(valueIdx + 1);
            }
        });
        if (this.getValues().get(valueIdx) == null) {
            FxUtil.submitToFxThread(result::requestFocus);
        }
        return result;
    }

    @Override
    protected void createGridPane() {
        super.createGridPane();
        this.gridPane.getChildren().addListener(change -> this.updateDisplayedValues());
    }

    @Override
    protected void addNew(int idx) {
        this.getValues().add(idx, null);
    }

    private void updateDisplayedValues() {
        if (this.gridPane == null) {
            this.displayedValues.setAll(Collections.emptyList());
        } else {
            this.displayedValues.setAll((Collection)this.gridPane.getChildren().stream().filter(widget -> widget instanceof TextFieldWidget).map(widget -> ((TextFieldWidget)widget).getValue()).collect(Collectors.toList()));
        }
    }
}

