/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.navigator;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomComboBox;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsSupport;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.BaseNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.StandardCompactNavigatorWidgetCoordinator;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ListItemStringConverter;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class CompactNavigatorWidget
extends BaseNavigatorWidget {
    protected final ReadOnlyObjectWrapper<Node> selectedView = new ReadOnlyObjectWrapper();
    protected Predicate<ControlsPane.ButtonType> controlButtonsAvailability = ControlsPane.ADD_REMOVE_PREV_NEXT;
    protected BiPredicate<ControlsPane.ButtonType, Node> controlButtonsCoordinator = new StandardCompactNavigatorWidgetCoordinator(this);
    protected Consumer<Node> callbackOnDelete;
    private NavPane navPane;
    protected String navigationTooltip = Messages.General_Choose_group_for_view_from_available;
    protected ListItemStringConverter<Node> converter = (obj, idx) -> String.valueOf(idx + 1) + '.';

    public CompactNavigatorWidget(boolean readonly) {
        super(readonly);
        this.getStyleClass().add((Object)"compact-navigator-widget");
        this.getViews().addListener(change -> FxUtil.submitToFxThread(() -> {
            if (this.getViews().isEmpty()) {
                this.setTop(this.getPlaceholderPane());
                this.setCenter(null);
                this.selectedView.set(null);
                this.navPane = null;
                return;
            }
            if (this.navPane == null) {
                this.navPane = new NavPane();
                this.setTop((Node)this.navPane);
                ScrollPane sp = new ScrollPane((Node)this.navPane.contentPane);
                sp.getStyleClass().add((Object)"edge-to-edge");
                sp.setFitToWidth(true);
                sp.setFitToHeight(true);
                this.setCenter((Node)sp);
            }
            this.navPane.updateState();
        }));
        this.setTop(this.getPlaceholderPane());
        this.getViewState().stateProperty().addListener((s, o, n) -> {
            if (this.navPane != null) {
                this.navPane.contentPane.getChildren().removeAll((Collection)this.navPane.contentPane.getChildren().stream().filter(node -> !node.isVisible()).collect(Collectors.toList()));
            }
        });
    }

    public void setControlButtonsAvailability(Predicate<ControlsPane.ButtonType> value) {
        this.controlButtonsAvailability = Objects.requireNonNull(value);
    }

    public void setControlButtonsCoordinator(BiPredicate<ControlsPane.ButtonType, Node> value) {
        this.controlButtonsCoordinator = Objects.requireNonNull(value);
    }

    public void revalidateControlButtons() {
        if (this.navPane != null) {
            this.navPane.buttonsRevalidationTrigger.set(!this.navPane.buttonsRevalidationTrigger.get());
        }
    }

    public void setNavigationTooltip(String value) {
        this.navigationTooltip = value;
    }

    public Consumer<Node> getCallbackOnDelete() {
        return this.callbackOnDelete;
    }

    public void setCallbackOnDelete(Consumer<Node> value) {
        this.callbackOnDelete = value;
    }

    public ListItemStringConverter<Node> getConverter() {
        return this.converter;
    }

    public void setConverter(ListItemStringConverter<Node> value) {
        this.converter = Objects.requireNonNull(value);
    }

    public ReadOnlyObjectProperty<Node> selectedElementProperty() {
        return this.selectedView.getReadOnlyProperty();
    }

    @Override
    public Node getSelectedView() {
        return (Node)this.selectedView.get();
    }

    @Override
    public void selectView(Node view) {
        if (this.navPane == null || view == null) {
            return;
        }
        this.navPane.selectView(view);
    }

    @Override
    public void redraw() {
        if (this.navPane != null) {
            String old = this.navPane.comboBox.getPromptText();
            this.navPane.comboBox.setPromptText("fake prompt text");
            this.navPane.comboBox.setPromptText(old);
        }
    }

    private class NavPane
    extends BorderPane {
        protected final CustomComboBox<ValueHolder<Node>> comboBox;
        protected final BooleanProperty buttonsRevalidationTrigger = new SimpleBooleanProperty();
        final StackPane contentPane;

        NavPane() {
            Region button;
            this.getStyleClass().add((Object)"navigation-pane");
            this.contentPane = new StackPane();
            this.contentPane.getStyleClass().add((Object)"content-pane");
            this.comboBox = new CustomComboBox();
            this.comboBox.setNoNulls(true);
            this.comboBox.setButtonStyle(CustomComboBox.ButtonStyle.NAVIGATION);
            this.comboBox.setMaxWidth(Double.MAX_VALUE);
            this.comboBox.setConverter((StringConverter)new StringConverter<ValueHolder<Node>>(){

                public String toString(ValueHolder<Node> object) {
                    return CompactNavigatorWidget.this.converter.toString(object == null ? null : object.get(), NavPane.this.comboBox.getItems().indexOf(object));
                }

                public ValueHolder<Node> fromString(String string) {
                    return null;
                }
            });
            this.comboBox.valueProperty().addListener((s, o, n) -> {
                if (o != null) {
                    ((Node)o.get()).setVisible(false);
                    ((Node)o.get()).setManaged(false);
                }
                if (n == null) {
                    CompactNavigatorWidget.this.selectedView.set(null);
                } else {
                    Node node = (Node)n.get();
                    if (!this.contentPane.getChildren().contains((Object)node)) {
                        this.contentPane.getChildren().add((Object)node);
                    }
                    node.setManaged(true);
                    node.setVisible(true);
                    CompactNavigatorWidget.this.selectedView.set((Object)node);
                }
            });
            if (CompactNavigatorWidget.this.suggestionsEnabled) {
                SuggestionsSupport.installSuggestions(this.comboBox, new SimpleSuggestionsHandler<ValueHolder<Node>>(this.comboBox, false));
            }
            UiUtil.setTooltip(this.comboBox, () -> CompactNavigatorWidget.this.navigationTooltip);
            this.setCenter((Node)this.comboBox);
            ControlsPane pane = new ControlsPane();
            if (CompactNavigatorWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.PREV)) {
                UiUtil.setTooltip((Node)pane.addButton(ControlsPane.ButtonType.PREV, (EventHandler<? super MouseEvent>)((EventHandler)evt -> this.comboBox.getSelectionModel().select(this.comboBox.getSelectionModel().getSelectedIndex() - 1)), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{NavPane.this.buttonsRevalidationTrigger, NavPane.this.comboBox.getSelectionModel().selectedIndexProperty(), NavPane.this.comboBox.getItems()});
                    }

                    protected boolean computeValue() {
                        return !CompactNavigatorWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.PREV, CompactNavigatorWidget.this.getSelectedView());
                    }
                }), () -> (String)CompactNavigatorWidget.this.controlButtonTooltips.apply(ControlsPane.ButtonType.PREV));
            }
            if (CompactNavigatorWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.NEXT)) {
                UiUtil.setTooltip((Node)pane.addButton(ControlsPane.ButtonType.NEXT, (EventHandler<? super MouseEvent>)((EventHandler)evt -> this.comboBox.getSelectionModel().select(this.comboBox.getSelectionModel().getSelectedIndex() + 1)), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{NavPane.this.buttonsRevalidationTrigger, NavPane.this.comboBox.getSelectionModel().selectedIndexProperty(), NavPane.this.comboBox.getItems()});
                    }

                    protected boolean computeValue() {
                        return !CompactNavigatorWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.NEXT, CompactNavigatorWidget.this.getSelectedView());
                    }
                }), () -> (String)CompactNavigatorWidget.this.controlButtonTooltips.apply(ControlsPane.ButtonType.NEXT));
            }
            ArrayList<Region> editButtons = new ArrayList<Region>(4);
            if (CompactNavigatorWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.DOWN)) {
                button = ControlsPane.createButton(ControlsPane.ButtonType.DOWN, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                    int idx = this.comboBox.getSelectionModel().getSelectedIndex();
                    FxUtil.swap(CompactNavigatorWidget.this.getViews(), idx, idx + 1);
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{NavPane.this.buttonsRevalidationTrigger, NavPane.this.comboBox.getSelectionModel().selectedIndexProperty(), NavPane.this.comboBox.getItems()});
                    }

                    protected boolean computeValue() {
                        return !CompactNavigatorWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.DOWN, CompactNavigatorWidget.this.getSelectedView());
                    }
                });
                UiUtil.setTooltip((Node)button, () -> (String)CompactNavigatorWidget.this.controlButtonTooltips.apply(ControlsPane.ButtonType.DOWN));
                editButtons.add(button);
            }
            if (CompactNavigatorWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.UP)) {
                button = ControlsPane.createButton(ControlsPane.ButtonType.UP, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                    int idx = this.comboBox.getSelectionModel().getSelectedIndex();
                    FxUtil.swap(CompactNavigatorWidget.this.getViews(), idx - 1, idx);
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{NavPane.this.buttonsRevalidationTrigger, NavPane.this.comboBox.getSelectionModel().selectedIndexProperty(), NavPane.this.comboBox.getItems()});
                    }

                    protected boolean computeValue() {
                        return !CompactNavigatorWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.UP, CompactNavigatorWidget.this.getSelectedView());
                    }
                });
                UiUtil.setTooltip((Node)button, () -> (String)CompactNavigatorWidget.this.controlButtonTooltips.apply(ControlsPane.ButtonType.UP));
                editButtons.add(button);
            }
            if (CompactNavigatorWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.REMOVE)) {
                button = ControlsPane.createButton(ControlsPane.ButtonType.REMOVE, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                    if (CompactNavigatorWidget.this.callbackOnDelete != null) {
                        CompactNavigatorWidget.this.callbackOnDelete.accept(CompactNavigatorWidget.this.getSelectedView());
                    } else {
                        CompactNavigatorWidget.this.getViews().remove((Object)CompactNavigatorWidget.this.getSelectedView());
                    }
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{NavPane.this.buttonsRevalidationTrigger, NavPane.this.comboBox.getSelectionModel().selectedIndexProperty(), NavPane.this.comboBox.getItems()});
                    }

                    protected boolean computeValue() {
                        return !CompactNavigatorWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.REMOVE, CompactNavigatorWidget.this.getSelectedView());
                    }
                });
                UiUtil.setTooltip((Node)button, () -> (String)CompactNavigatorWidget.this.controlButtonTooltips.apply(ControlsPane.ButtonType.REMOVE));
                editButtons.add(button);
            }
            if (CompactNavigatorWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.ADD)) {
                button = ControlsPane.createButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)evt -> CompactNavigatorWidget.this.createView(CompactNavigatorWidget.this.getSelectedView())), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{NavPane.this.buttonsRevalidationTrigger, NavPane.this.comboBox.getSelectionModel().selectedIndexProperty(), NavPane.this.comboBox.getItems()});
                    }

                    protected boolean computeValue() {
                        return !CompactNavigatorWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.ADD, CompactNavigatorWidget.this.getSelectedView());
                    }
                });
                UiUtil.setTooltip((Node)button, () -> (String)CompactNavigatorWidget.this.controlButtonTooltips.apply(ControlsPane.ButtonType.ADD));
                editButtons.add(button);
            }
            if (!CompactNavigatorWidget.this.getViewState().isImmutable()) {
                pane.getChildren().addAll(editButtons);
            }
            this.setRight((Node)pane);
            CompactNavigatorWidget.this.getViewState().stateProperty().addListener((s, o, n) -> {
                pane.getChildren().removeAll((Collection)editButtons);
                if (!ViewState.isImmutable(n.intValue())) {
                    pane.getChildren().addAll((Collection)editButtons);
                }
            });
        }

        void selectView(Node view) {
            this.comboBox.getSelectionModel().select(CompactNavigatorWidget.this.getViews().indexOf((Object)view));
        }

        void updateState() {
            ArrayList<Node> toBeRemoved = new ArrayList<Node>();
            for (Node node : this.contentPane.getChildren()) {
                if (CompactNavigatorWidget.this.getViews().contains((Object)node) && node.isVisible()) continue;
                toBeRemoved.add(node);
            }
            this.contentPane.getChildren().removeAll(toBeRemoved);
            int selected = this.comboBox.getSelectionModel().getSelectedIndex();
            this.comboBox.getItems().setAll((Collection)CompactNavigatorWidget.this.getViews().stream().map(view -> new ValueHolder<Node>((Node)view)).collect(Collectors.toList()));
            if (!this.comboBox.getItems().isEmpty()) {
                this.comboBox.getSelectionModel().select(selected >= this.comboBox.getItems().size() ? this.comboBox.getItems().size() - 1 : (selected >= 0 ? selected : 0));
            }
        }
    }
}

