/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.navigator;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import java.util.function.BiPredicate;
import javafx.scene.Node;

public class StandardCompactNavigatorWidgetCoordinator
implements BiPredicate<ControlsPane.ButtonType, Node> {
    private final CompactNavigatorWidget widget;

    public StandardCompactNavigatorWidgetCoordinator(CompactNavigatorWidget wgt) {
        this.widget = wgt;
    }

    @Override
    public boolean test(ControlsPane.ButtonType buttonType, Node view) {
        if (!this.widget.controlButtonsAvailability.test(buttonType)) {
            return false;
        }
        switch (buttonType) {
            case NEXT: {
                if (view == null) {
                    return false;
                }
                int idx = this.widget.getViews().indexOf((Object)view);
                return idx < this.widget.getViews().size() - 1;
            }
            case PREV: {
                if (view == null) {
                    return false;
                }
                int idx = this.widget.getViews().indexOf((Object)view);
                return idx > 0;
            }
            case DOWN: {
                if (view == null || this.widget.getViewState().isImmutable()) {
                    return false;
                }
                int idx = this.widget.getViews().indexOf((Object)view);
                return idx < this.widget.getViews().size() - 1;
            }
            case UP: {
                if (view == null || this.widget.getViewState().isImmutable()) {
                    return false;
                }
                int idx = this.widget.getViews().indexOf((Object)view);
                return idx > 0;
            }
            case REMOVE: {
                return view != null && !this.widget.getViewState().isImmutable();
            }
            case ADD: {
                return !this.widget.getViewState().isImmutable();
            }
        }
        return true;
    }
}

