/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.navigator;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.FilteringPane;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconIntention;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomTreeView;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.BaseNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.StandardTreeNavigatorWidgetCoordinator;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class TreeNavigatorWidget
extends BaseNavigatorWidget {
    protected StringConverter<HierarchyElement> converter = StandardRenderers.GENERIC.createConverter(() -> "");
    protected Supplier<List<TreeItem<HierarchyElement>>> hierarchySupplier = Collections::emptyList;
    protected final StringProperty caption = new SimpleStringProperty();
    protected final ReadOnlyObjectWrapper<HierarchyElement> selectedElement = new ReadOnlyObjectWrapper();
    private ContentPane contentPane;
    private FilteringPane<?> filteringPane;
    protected BiPredicate<ControlsPane.ButtonType, TreeItem<HierarchyElement>> controlButtonsAvailability = (bt, item) -> {
        switch (bt) {
            case ADD: 
            case REMOVE: 
            case UP: 
            case DOWN: {
                return true;
            }
        }
        return false;
    };
    protected BiPredicate<ControlsPane.ButtonType, TreeItem<HierarchyElement>> controlButtonsCoordinator = new StandardTreeNavigatorWidgetCoordinator(this);
    protected Consumer<TreeItem<HierarchyElement>> callbackOnDelete;
    TreeItem<HierarchyElement> removedItemSibling;
    boolean removedAnElement = false;

    static <T> TreeItem<T> find(List<TreeItem<T>> items, Predicate<T> predicate) {
        for (TreeItem<T> item : items) {
            if (predicate.test(item.getValue())) {
                return item;
            }
            TreeItem<T> result = TreeNavigatorWidget.find(item.getChildren(), predicate);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public TreeNavigatorWidget(boolean readonly) {
        super(readonly);
        this.getStyleClass().add((Object)"tree-navigator-widget");
        this.getViews().addListener(change -> FxUtil.submitToFxThread(() -> {
            if (this.getViews().isEmpty()) {
                this.setTop(this.getPlaceholderPane());
                this.setCenter(null);
                this.contentPane = null;
                this.selectedElement.unbind();
                this.selectedElement.set(null);
                return;
            }
            if (this.contentPane == null) {
                this.contentPane = new ContentPane();
                this.setCenter((Node)this.contentPane);
                this.setTop((Node)this.filteringPane);
            }
            this.contentPane.updateTreeView();
        }));
        this.setTop(this.getPlaceholderPane());
    }

    public TreeItem<HierarchyElement> getSelectedRootTreeItem() {
        return this.getSelectedTreeItem().getParent();
    }

    public void setConverter(StringConverter<HierarchyElement> value) {
        this.converter = Objects.requireNonNull(value);
    }

    public void setHierarchySupplier(Supplier<List<TreeItem<HierarchyElement>>> value) {
        this.hierarchySupplier = Objects.requireNonNull(value);
    }

    public void setControlButtonsAvailability(BiPredicate<ControlsPane.ButtonType, TreeItem<HierarchyElement>> value) {
        this.controlButtonsAvailability = Objects.requireNonNull(value);
    }

    BiPredicate<ControlsPane.ButtonType, TreeItem<HierarchyElement>> getControlButtonsCoordinator() {
        return this.controlButtonsCoordinator;
    }

    public void setControlButtonsCoordinator(BiPredicate<ControlsPane.ButtonType, TreeItem<HierarchyElement>> value) {
        this.controlButtonsCoordinator = Objects.requireNonNull(value);
    }

    public Consumer<TreeItem<HierarchyElement>> getCallbackOnDelete() {
        return this.callbackOnDelete;
    }

    public void setCallbackOnDelete(Consumer<TreeItem<HierarchyElement>> value) {
        this.callbackOnDelete = value;
    }

    public void setCaption(String value) {
        this.caption.set((Object)value);
    }

    public ReadOnlyObjectProperty<HierarchyElement> selectedElementProperty() {
        return this.selectedElement.getReadOnlyProperty();
    }

    public HierarchyElement getSelectedElement() {
        return (HierarchyElement)this.selectedElement.get();
    }

    @Override
    public void selectView(Node view) {
        if (this.contentPane != null) {
            this.contentPane.selectView(view);
        }
    }

    @Override
    public void redraw() {
        if (this.contentPane != null) {
            this.contentPane.updateTreeView();
        }
    }

    @Override
    public Node getSelectedView() {
        HierarchyElement data = this.getSelectedElement();
        if (data == null) {
            return null;
        }
        return data.getView();
    }

    public <N extends Node> void setFiltering(Supplier<N> filtersPaneSupplier, Function<N, Predicate<Node>> predicateSupplier, boolean collapsible) {
        FilteringPane<Node> pane = filtersPaneSupplier == null ? null : new FilteringPane<Node>(filtersPaneSupplier, collapsible);
        this.filteringPane = pane;
        if (this.filteringPane == null || !this.getViews().isEmpty()) {
            this.setTop((Node)this.filteringPane);
        }
        if (pane != null) {
            pane.setOnApply(filtersPane -> {
                Predicate predicate = (Predicate)predicateSupplier.apply(filtersPane);
                for (Node view : this.getViews()) {
                    if (predicate.test(view)) {
                        view.getProperties().remove((Object)"filteredOut");
                        continue;
                    }
                    view.getProperties().put((Object)"filteredOut", (Object)Boolean.TRUE);
                }
                if (this.contentPane != null) {
                    this.contentPane.updateTreeView();
                }
                this.updateFilteringCaption();
            });
            this.updateFilteringCaption();
        } else {
            this.getViews().forEach(view -> view.getProperties().remove((Object)"filteredOut"));
            if (this.contentPane != null) {
                this.contentPane.updateTreeView();
            }
        }
    }

    private void updateFilteringCaption() {
        if (this.filteringPane == null) {
            return;
        }
        long filtered = this.getViews().stream().filter(view -> !view.getProperties().containsKey((Object)"filteredOut")).count();
        this.filteringPane.setCaption(Messages.getGeneral_Paging_filter(this.getFieldName(), filtered, this.getViews().size()));
    }

    protected final TreeItem<HierarchyElement> getSelectedTreeItem() {
        return this.contentPane == null ? null : (TreeItem)this.contentPane.treeView.getSelectionModel().getSelectedItem();
    }

    protected void doAdd(TreeItem<HierarchyElement> after) {
        this.createView(this.lookupView(after));
    }

    private Node lookupView(TreeItem<HierarchyElement> item) {
        if (item == null) {
            return null;
        }
        HierarchyElement elm = (HierarchyElement)item.getValue();
        if (elm != null && elm.getView() != null) {
            return elm.getView();
        }
        return this.lookupView((TreeItem<HierarchyElement>)item.getParent());
    }

    protected void doRemove(TreeItem<HierarchyElement> item) {
        this.removedItemSibling = item.previousSibling() == null ? item.getParent() : item.previousSibling();
        this.removedAnElement = true;
        ArrayList<Node> views = new ArrayList<Node>();
        this.collectViews(views, item);
        if (this.callbackOnDelete != null) {
            this.callbackOnDelete.accept(item);
        }
        this.getViews().removeAll(views);
    }

    private void collectViews(List<Node> result, TreeItem<HierarchyElement> item) {
        Node view = ((HierarchyElement)item.getValue()).getView();
        if (view != null) {
            result.add(view);
        }
        item.getChildren().forEach(subItem -> this.collectViews(result, (TreeItem<HierarchyElement>)subItem));
    }

    protected void doMoveUp(TreeItem<HierarchyElement> item) {
        int idx1 = this.getViews().indexOf((Object)((HierarchyElement)item.previousSibling().getValue()).getView());
        if (idx1 == -1) {
            return;
        }
        int idx2 = this.getViews().indexOf((Object)((HierarchyElement)item.getValue()).getView());
        if (idx2 == -1) {
            return;
        }
        FxUtil.swap(this.getViews(), idx1, idx2);
    }

    protected void doMoveDown(TreeItem<HierarchyElement> item) {
        int idx1 = this.getViews().indexOf((Object)((HierarchyElement)item.getValue()).getView());
        if (idx1 == -1) {
            return;
        }
        int idx2 = this.getViews().indexOf((Object)((HierarchyElement)item.nextSibling().getValue()).getView());
        if (idx2 == -1) {
            return;
        }
        FxUtil.swap(this.getViews(), idx1, idx2);
    }

    private class ContentPane
    extends HBox {
        protected final CustomTreeView<HierarchyElement> treeView;
        private final StackPane payloadPane;

        ContentPane() {
            this.getStyleClass().add((Object)"content-pane");
            this.treeView = new CustomTreeView();
            this.treeView.setMaxWidth(Double.NEGATIVE_INFINITY);
            this.treeView.setMinWidth(Double.NEGATIVE_INFINITY);
            this.treeView.setShowRoot(false);
            this.treeView.setConverter(TreeNavigatorWidget.this.converter);
            this.treeView.setIconSupplier(item -> item.isLeaf() ? StandardIconShapes.NAVIGATION_INDEX_14X14 : StandardIconShapes.GROUP_14X14);
            this.treeView.getControlButtons().add(new CustomTreeView.ControlButton<HierarchyElement>(){

                @Override
                public IconShape getIconShape() {
                    return StandardIconShapes.MOVE_DOWN_14X14;
                }

                @Override
                public IconIntention getIconIntention() {
                    return StandardIconIntentions.TREE_CELL_BUTTON_MOVE;
                }

                @Override
                public String getDescription() {
                    return Messages.General_Down;
                }

                @Override
                public boolean isAvailable(TreeItem<HierarchyElement> item) {
                    return TreeNavigatorWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.DOWN, item);
                }

                @Override
                public boolean isEnabled(TreeItem<HierarchyElement> item) {
                    return TreeNavigatorWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.DOWN, item);
                }

                @Override
                public void onAction(TreeItem<HierarchyElement> item) {
                    ContentPane.this.treeView.getSelectionModel().select(item);
                    TreeNavigatorWidget.this.doMoveDown(item);
                }
            });
            this.treeView.getControlButtons().add(new CustomTreeView.ControlButton<HierarchyElement>(){

                @Override
                public IconShape getIconShape() {
                    return StandardIconShapes.MOVE_UP_14X14;
                }

                @Override
                public IconIntention getIconIntention() {
                    return StandardIconIntentions.TREE_CELL_BUTTON_MOVE;
                }

                @Override
                public String getDescription() {
                    return Messages.General_Up;
                }

                @Override
                public boolean isAvailable(TreeItem<HierarchyElement> item) {
                    return TreeNavigatorWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.UP, item);
                }

                @Override
                public boolean isEnabled(TreeItem<HierarchyElement> item) {
                    return TreeNavigatorWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.UP, item);
                }

                @Override
                public void onAction(TreeItem<HierarchyElement> item) {
                    ContentPane.this.treeView.getSelectionModel().select(item);
                    TreeNavigatorWidget.this.doMoveUp(item);
                }
            });
            this.treeView.getControlButtons().add(new CustomTreeView.ControlButton<HierarchyElement>(){

                @Override
                public IconShape getIconShape() {
                    return StandardIconShapes.REMOVE_14X14;
                }

                @Override
                public IconIntention getIconIntention() {
                    return StandardIconIntentions.TREE_CELL_BUTTON_ACTION;
                }

                @Override
                public String getDescription() {
                    return Messages.General_Delete;
                }

                @Override
                public boolean isAvailable(TreeItem<HierarchyElement> item) {
                    return TreeNavigatorWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.REMOVE, item);
                }

                @Override
                public boolean isEnabled(TreeItem<HierarchyElement> item) {
                    return !TreeNavigatorWidget.this.getViewState().isImmutable() && TreeNavigatorWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.REMOVE, item);
                }

                @Override
                public void onAction(TreeItem<HierarchyElement> item) {
                    ContentPane.this.treeView.getSelectionModel().select(item);
                    TreeNavigatorWidget.this.doRemove(item);
                }
            });
            this.treeView.getControlButtons().add(new CustomTreeView.ControlButton<HierarchyElement>(){

                @Override
                public IconShape getIconShape() {
                    return StandardIconShapes.ADD_14X14;
                }

                @Override
                public IconIntention getIconIntention() {
                    return StandardIconIntentions.TREE_CELL_BUTTON_ACTION;
                }

                @Override
                public String getDescription() {
                    return Messages.General_Create;
                }

                @Override
                public boolean isAvailable(TreeItem<HierarchyElement> item) {
                    return TreeNavigatorWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.ADD, item);
                }

                @Override
                public boolean isEnabled(TreeItem<HierarchyElement> item) {
                    ((HierarchyElement)TreeNavigatorWidget.this.selectedElementProperty().get()).getView();
                    return !TreeNavigatorWidget.this.getViewState().isImmutable() && TreeNavigatorWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.ADD, item);
                }

                @Override
                public void onAction(TreeItem<HierarchyElement> item) {
                    ContentPane.this.treeView.getSelectionModel().select(item);
                    TreeNavigatorWidget.this.doAdd(item);
                }
            });
            this.treeView.getSelectionModel().selectedItemProperty().addListener((src, o, n) -> this.updateContent(n == null ? null : (HierarchyElement)n.getValue()));
            CardsContainer cc = new CardsContainer();
            Styles.addStyle((Styleable)cc, "tree-container");
            Card<CustomTreeView<HierarchyElement>> card = new Card<CustomTreeView<HierarchyElement>>("main", UiCardsContainer.Style.STATIC, (String)TreeNavigatorWidget.this.caption.get(), this.treeView);
            card.captionProperty().bind((ObservableValue)TreeNavigatorWidget.this.caption);
            card.setAdaptiveHeight(true);
            cc.getCards().add(card);
            HBox.setHgrow((Node)cc, (Priority)Priority.NEVER);
            this.getChildren().add((Object)cc);
            this.payloadPane = new StackPane();
            HBox.setHgrow((Node)this.payloadPane, (Priority)Priority.ALWAYS);
            this.getChildren().add((Object)this.payloadPane);
            TreeNavigatorWidget.this.selectedElement.bind((ObservableValue)new ObjectBinding<HierarchyElement>(){
                {
                    this.bind(new Observable[]{ContentPane.this.treeView.getSelectionModel().selectedItemProperty()});
                }

                protected HierarchyElement computeValue() {
                    TreeItem item = (TreeItem)ContentPane.this.treeView.getSelectionModel().getSelectedItem();
                    return item == null ? null : (HierarchyElement)item.getValue();
                }
            });
        }

        void selectView(Node view) {
            TreeItem<HierarchyElement> item;
            if (view == null) {
                return;
            }
            TreeItem<HierarchyElement> treeItem = item = this.treeView.getRoot() == null ? null : TreeNavigatorWidget.find(this.treeView.getRoot().getChildren(), elm -> view.equals(elm.getView()));
            if (item == null) {
                return;
            }
            this.treeView.getSelectionModel().select(item);
            UiUtil.expand(item);
        }

        private void updateContent(HierarchyElement elm) {
            if (elm == null || elm.getView() == null) {
                this.payloadPane.getChildren().clear();
            } else {
                Node view = elm.getView();
                if (view instanceof CardsContainer) {
                    this.payloadPane.getChildren().setAll((Object[])new Node[]{view});
                } else {
                    CardsContainer cc = new CardsContainer();
                    cc.getCards().add(new Card<Node>("main", UiCardsContainer.Style.STATIC, TreeNavigatorWidget.this.converter.toString((Object)elm), view));
                    this.payloadPane.getChildren().setAll((Object[])new Node[]{cc});
                }
            }
        }

        void updateTreeView() {
            if (TreeNavigatorWidget.this.hierarchySupplier == null) {
                this.treeView.getSelectionModel().select(null);
                this.treeView.setRoot(null);
                return;
            }
            TreeItem item = null;
            if (!TreeNavigatorWidget.this.removedAnElement) {
                item = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
            } else {
                item = TreeNavigatorWidget.this.removedItemSibling;
                TreeNavigatorWidget.this.removedAnElement = false;
            }
            String selectedId = item == null ? null : (item.getValue() == null ? null : ((HierarchyElement)item.getValue()).getId());
            TreeItem root = new TreeItem();
            List<TreeItem<HierarchyElement>> treeItems = TreeNavigatorWidget.this.hierarchySupplier.get();
            this.handleFiltering(treeItems);
            root.getChildren().addAll(treeItems);
            this.treeView.setRoot(root);
            TreeItem selectedItem = null;
            if (selectedId != null) {
                selectedItem = TreeNavigatorWidget.find(root.getChildren(), elm -> selectedId.equals(elm.getId()));
            }
            if (selectedItem == null && !root.getChildren().isEmpty()) {
                selectedItem = (TreeItem)root.getChildren().get(0);
            }
            this.treeView.getSelectionModel().select(selectedItem);
            if (selectedItem != null && !selectedItem.isLeaf()) {
                UiUtil.expand(selectedItem);
            }
        }

        private void handleFiltering(List<TreeItem<HierarchyElement>> treeItems) {
            Iterator<TreeItem<HierarchyElement>> it = treeItems.iterator();
            while (it.hasNext()) {
                TreeItem<HierarchyElement> elm = it.next();
                Node view = ((HierarchyElement)elm.getValue()).getView();
                if (view != null && view.getProperties().containsKey((Object)"filteredOut")) {
                    it.remove();
                    continue;
                }
                this.handleFiltering((List<TreeItem<HierarchyElement>>)elm.getChildren());
            }
        }
    }

    public static interface HierarchyElement {
        public String getId();

        default public String getIconShape(boolean expanded) {
            if (this.getView() != null) {
                return "M9,5V9H21V5M9,19H21V15H9M9,14H21V10H9M4,9H8V5H4M4,19H8V15H4M4,14H8V10H4V14Z";
            }
            return expanded ? "M20,18H4V8H20M20,6H12L10,4H4C2.89,4 2,4.89 2,6V18A2,2 0 0,0 4,20H20A2,2 0 0,0 22,18V8C22,6.89 21.1,6 20,6Z" : "M10,4H4C2.89,4 2,4.89 2,6V18A2,2 0 0,0 4,20H20A2,2 0 0,0 22,18V8C22,6.89 21.1,6 20,6H12L10,4Z";
        }

        default public boolean firstInGroup() {
            return false;
        }

        public Node getView();
    }
}

