/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.pair;

import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.widgets.pair.PairWidgetHandler;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import javafx.beans.property.ObjectProperty;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class PairWidget<V, W extends Node>
extends HBox
implements HasViewState {
    private final PairWidgetHandler<V, W> handler;
    private final W firstWidget;
    private final W secondWidget;
    private final ViewState viewState = new ViewState();

    public PairWidget(PairWidgetHandler<V, W> widgetHandler, boolean readonly) {
        this.handler = widgetHandler;
        this.viewState.setReadonly(readonly);
        this.getStyleClass().addAll((Object[])new String[]{"pair-widget", "simple-widget"});
        this.firstWidget = this.handler.createWidget(readonly);
        HBox.setHgrow(this.firstWidget, (Priority)Priority.ALWAYS);
        this.secondWidget = this.handler.createWidget(readonly);
        HBox.setHgrow(this.secondWidget, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.firstWidget, new IconNode(StandardIconShapes.POINT_14x14, (Styleable)this, StandardIconIntentions.POINT_ACTION, (Styleable)this), this.secondWidget});
        this.viewState.stateProperty().addListener((s, o, n) -> {
            this.handler.setViewState(this.firstWidget, n.intValue());
            this.handler.setViewState(this.secondWidget, n.intValue());
        });
    }

    public ObjectProperty<V> firstValueProperty() {
        return this.handler.valueProperty(this.firstWidget);
    }

    public V getFirstValue() {
        return (V)this.firstValueProperty().get();
    }

    public void setFirstValue(V value) {
        this.firstValueProperty().set(value);
    }

    public ObjectProperty<V> secondValueProperty() {
        return this.handler.valueProperty(this.secondWidget);
    }

    public V getSecondValue() {
        return (V)this.secondValueProperty().get();
    }

    public void setSecondValue(V value) {
        this.secondValueProperty().set(value);
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }
}

