/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.popup;

import com.gridnine.xtrip.client.fx.core.lib.components.CustomComboBox;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsSupport;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.CustomListCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.WorkaroundSelectionModel;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Labeled;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class ComboBoxWidget<T>
extends StackPane
implements HasViewState,
HasValue<T> {
    private final ObjectProperty<T> value = new SimpleObjectProperty();
    private CustomComboBox<T> comboBox;
    Function<T, IconNode> iconsSupplier;
    private Labeled readonlyNode;
    private Supplier<List<T>> itemsSupplier = Collections::emptyList;
    private WorkaroundSelectionModel<T> workaroundSelectionModel;
    private boolean noNulls;
    private boolean live;
    private boolean async;
    private final ViewState viewState = new ViewState();
    private boolean sortItems = true;
    StringConverter<T> converter = StandardRenderers.GENERIC.createStatefulConverter(this.viewState::isImmutable);
    private Predicate<T> valueApprover = val -> true;
    private ActionData actionData;
    private SuggestionsHandler<T> suggestionsHandler;
    private CustomComboBox.ButtonStyle buttonStyle = CustomComboBox.ButtonStyle.STANDARD;
    private String clearButtonTooltip;
    private Runnable clearAction;
    private Consumer<T> navigationHandler;
    private String promptText;
    private double guessedPrefWidth = -1.0;

    public ComboBoxWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"combo-box-widget", "simple-widget"});
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.value.addListener((s, o, n) -> {
            if (this.comboBox != null) {
                this.comboBox.hide();
                this.comboBox.valueProperty().set(n);
            } else {
                this.updateReadonlyNodeText();
            }
        });
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    public void requestFocus() {
        if (this.comboBox != null) {
            this.comboBox.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void guessPrefWidth() {
        int chars = 10;
        for (T item : this.itemsSupplier.get()) {
            String str = this.converter.toString(item);
            if (str == null) continue;
            chars = Math.max(chars, str.length());
        }
        chars = Math.min(30, chars);
        this.guessedPrefWidth = chars * 15;
        this.setPrefWidth(this.viewState.isImmutable() ? -1.0 : this.guessedPrefWidth);
    }

    @Override
    public ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public T getValue() {
        return (T)this.value.get();
    }

    public void setValue(T val) {
        this.value.set(val);
    }

    public StringConverter<T> getConverter() {
        return this.converter;
    }

    public void setConverter(StringConverter<T> val) {
        this.converter = Objects.requireNonNull(val);
        if (this.comboBox != null) {
            this.comboBox.setConverter(this.converter);
        } else {
            this.updateReadonlyNodeText();
        }
    }

    public void setIconsSupplier(Function<T, IconNode> val) {
        this.iconsSupplier = val;
    }

    public void setNoNulls(boolean val) {
        this.noNulls = val;
        if (this.comboBox != null) {
            this.comboBox.setNoNulls(this.noNulls);
        }
    }

    public void setLive(boolean val) {
        this.live = val;
    }

    public void setAsync(boolean val) {
        this.async = val;
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public boolean isSortItems() {
        return this.sortItems;
    }

    public void setSortItems(boolean val) {
        this.sortItems = val;
    }

    public Supplier<List<T>> getItemsSupplier() {
        return this.itemsSupplier;
    }

    public void setItemsSupplier(Supplier<List<T>> val) {
        this.itemsSupplier = val == null ? Collections::emptyList : val;
    }

    public void setValueApprover(Predicate<T> val) {
        this.valueApprover = Objects.requireNonNull(val);
    }

    public void setActionHandler(IconShape iconShape, String tooltip, Runnable handler) {
        this.actionData = handler == null ? null : new ActionData(Objects.requireNonNull(iconShape), tooltip, handler);
        this.updateState();
    }

    public void setNavigationHandler(Consumer<T> value) {
        this.navigationHandler = value;
        this.updateState();
    }

    public void setSuggestionsHandler(SuggestionsHandler<T> value) {
        this.suggestionsHandler = value;
        if (this.comboBox == null) {
            return;
        }
        SuggestionsSupport.uninstallSuggestions(this.comboBox);
        if (this.suggestionsHandler != null) {
            SuggestionsSupport.installSuggestions(this.comboBox, this.suggestionsHandler);
        }
    }

    public void setButtonStyle(CustomComboBox.ButtonStyle value) {
        this.buttonStyle = Objects.requireNonNull(value);
        if (this.comboBox != null) {
            this.comboBox.setButtonStyle(this.buttonStyle);
        }
    }

    public void setClearButtonTooltip(String value) {
        this.clearButtonTooltip = value;
        if (this.comboBox != null) {
            this.comboBox.setClearButtonTooltip(this.clearButtonTooltip);
        }
    }

    public void setClearAction(Runnable value) {
        this.clearAction = value;
        if (this.comboBox != null) {
            this.comboBox.setClearAction(this.clearAction);
        }
    }

    public void setPromptText(String val) {
        this.promptText = val;
        if (this.comboBox != null) {
            this.comboBox.setPromptText(this.promptText == null ? this.converter.toString(null) : this.promptText);
        }
    }

    public void redraw() {
        if (this.comboBox == null) {
            this.updateReadonlyNodeText();
            return;
        }
        this.comboBox.setValue(this.value.get());
        if (this.comboBox.getButtonCell() != null) {
            ((CustomListCell)this.comboBox.getButtonCell()).updateItem(this.value.get(), this.value.get() == null);
        }
        String str = this.comboBox.getPromptText();
        this.comboBox.setPromptText(null);
        this.comboBox.setPromptText(str);
    }

    protected boolean needDropDown() {
        return true;
    }

    private void rebuildComboBoxItems() {
        if (this.comboBox == null || !this.comboBox.isArmed()) {
            return;
        }
        if (this.live || this.comboBox.getItems().isEmpty() || this.comboBox.getItems().size() == 1 && this.iconsSupplier != null) {
            if (this.async) {
                Notifications.get().submitTask(() -> {
                    List<T> list = this.itemsSupplier.get();
                    FxUtil.submitToFxThread(() -> {
                        if (this.comboBox != null) {
                            this.populateItems(list);
                            this.comboBox.hide();
                            FxUtil.submitToFxThread(() -> this.comboBox.show());
                        }
                    });
                }, ObservableMutex.lookup((Node)this));
            } else {
                this.populateItems(this.itemsSupplier.get());
            }
        }
    }

    private void populateItems(List<T> newItems) {
        Object currentValue = this.comboBox.getValue();
        ArrayList list = new ArrayList(newItems == null ? Collections.emptyList() : newItems);
        if (this.sortItems && list.size() > 1) {
            Collections.sort(list, (l1, l2) -> TextUtil.compare((String)this.converter.toString(l1), (String)this.converter.toString(l2), (boolean)true, (boolean)false));
        }
        if (this.workaroundSelectionModel != null) {
            this.workaroundSelectionModel.setItems(this.comboBox.getItems());
        }
        this.comboBox.getItems().setAll(list);
        this.comboBox.setValue(currentValue);
        this.redraw();
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            if (this.comboBox != null) {
                SuggestionsSupport.uninstallSuggestions(this.comboBox);
                this.comboBox = null;
                this.workaroundSelectionModel = null;
            }
            if (this.navigationHandler == null) {
                if (!(this.readonlyNode instanceof CustomLabel)) {
                    this.readonlyNode = new CustomLabel();
                    this.readonlyNode.getStyleClass().add((Object)"value-label");
                    this.getChildren().setAll((Object[])new Node[]{this.readonlyNode});
                }
            } else if (!(this.readonlyNode instanceof HyperlinkWidget)) {
                this.readonlyNode = new HyperlinkWidget();
                ((HyperlinkWidget)this.readonlyNode).setOnAction(evt -> {
                    T val = this.getValue();
                    if (val != null) {
                        this.navigationHandler.accept(val);
                    }
                });
                this.getChildren().setAll((Object[])new Node[]{this.readonlyNode});
            }
            this.updateReadonlyNodeText();
            this.setPrefWidth(-1.0);
        } else {
            if (this.readonlyNode != null) {
                this.readonlyNode = null;
            }
            if (this.comboBox == null) {
                this.comboBox = new CustomComboBox<T>(){

                    public void show() {
                        if (ComboBoxWidget.this.needDropDown()) {
                            super.show();
                        }
                    }
                };
                this.comboBox.setNoNulls(this.noNulls);
                this.comboBox.setButtonStyle(this.buttonStyle);
                this.comboBox.setConverter(this.converter);
                this.comboBox.setPromptText(this.promptText == null ? this.converter.toString(null) : this.promptText);
                this.comboBox.armedProperty().addListener((obj, o, n) -> this.rebuildComboBoxItems());
                this.comboBox.setValue(this.value.get());
                FxUtil.addListener(this.comboBox.valueProperty(), (observable, oldValue, newValue) -> {
                    if (!this.valueApprover.test(newValue)) {
                        this.comboBox.setValue(oldValue);
                        return;
                    }
                    if (this.comboBox.getItems().isEmpty() && this.iconsSupplier != null) {
                        this.comboBox.getItems().add(newValue);
                    }
                    this.value.set(newValue);
                });
                this.comboBox.setButtonCell(new CustomListCell(this));
                this.comboBox.setCellFactory(listView -> {
                    if (this.workaroundSelectionModel == null) {
                        this.workaroundSelectionModel = new WorkaroundSelectionModel<T>(listView.getItems(), this.value);
                        listView.setSelectionModel(this.workaroundSelectionModel);
                    }
                    return new CustomListCell(this);
                });
                if (this.suggestionsHandler != null) {
                    SuggestionsSupport.installSuggestions(this.comboBox, this.suggestionsHandler);
                }
                if (this.clearButtonTooltip != null) {
                    this.comboBox.setClearButtonTooltip(this.clearButtonTooltip);
                }
                if (this.clearAction != null) {
                    this.comboBox.setClearAction(this.clearAction);
                }
            }
            if (this.actionData != null || this.navigationHandler != null) {
                Button button;
                ArrayList<CustomComboBox<T>> nodes = new ArrayList<CustomComboBox<T>>();
                nodes.add(this.comboBox);
                HBox.setHgrow(this.comboBox, (Priority)Priority.ALWAYS);
                if (this.actionData != null) {
                    button = new Button();
                    button.setOnAction(evt -> this.actionData.handler.run());
                    if (!TextUtil.isBlank((String)this.actionData.tooltip)) {
                        UiUtil.setTooltip((Node)button, this.actionData.tooltip);
                    }
                    button.setGraphic((Node)new IconNode(this.actionData.shape, (Styleable)button, StandardIconIntentions.CONTROLS_QTY, (Styleable)button));
                    Styles.addStyle((Styleable)button, "xtrip-button");
                    nodes.add((CustomComboBox<T>)button);
                }
                if (this.navigationHandler != null) {
                    button = new Button();
                    button.setOnAction(evt -> {
                        T val = this.getValue();
                        if (val != null) {
                            this.navigationHandler.accept(val);
                        }
                    });
                    button.setGraphic((Node)new IconNode(StandardIconShapes.BOX_NAVIGATE, (Styleable)button, StandardIconIntentions.BOX_NAVIGATE_BUTTON_ACTION, (Styleable)button));
                    Styles.addStyle((Styleable)button, "xtrip-button");
                    nodes.add((CustomComboBox<T>)button);
                }
                this.getChildren().setAll((Object[])new Node[]{new HBox(nodes.toArray(new Node[nodes.size()]))});
            } else {
                this.getChildren().setAll((Object[])new Node[]{this.comboBox});
            }
            this.setPrefWidth(this.guessedPrefWidth);
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
    }

    private void updateReadonlyNodeText() {
        if (this.readonlyNode == null) {
            return;
        }
        Object val = this.value.get();
        String text = this.converter.toString(val);
        this.readonlyNode.setText(TextUtil.isBlank((String)text) ? "\u2014" : text);
        this.readonlyNode.pseudoClassStateChanged(Styles.EMPTY_PSEUDOCLASS, val == null);
    }

    private static class ActionData {
        final IconShape shape;
        final String tooltip;
        final Runnable handler;

        ActionData(IconShape is, String tt, Runnable h) {
            this.shape = is;
            this.tooltip = tt;
            this.handler = h;
        }
    }
}

