/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.popup;

import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.res.FxRes;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import javafx.scene.Node;
import javafx.scene.control.ListCell;

class CustomListCell<T>
extends ListCell<T> {
    private final ComboBoxWidget<T> widget;

    CustomListCell(ComboBoxWidget<T> w) {
        this.widget = w;
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
            return;
        }
        if (this.getScene() != null && this.getScene().getStylesheets().isEmpty()) {
            FxRes.addStylesheets(this.getScene());
        }
        String text = this.widget.converter.toString(item);
        this.setText(text);
        if (item == null) {
            this.setGraphic(null);
            return;
        }
        if (this.widget.iconsSupplier != null) {
            if (text == null || text.isEmpty() || this.getText().equals(this.widget.getViewState().isImmutable() ? "\u2014" : UiUtil.NULL_TEXT)) {
                this.setGraphic(null);
            } else {
                this.setGraphic((Node)this.widget.iconsSupplier.apply(item));
            }
        }
    }
}

