/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.popup;

import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.util.StringConverter;

class SwitchControl
extends AnchorPane {
    private static final Double ZERO = 0.0;
    private static final Double GAP = 12.0;
    final SimpleBooleanProperty value = new SimpleBooleanProperty();
    private final Label falseLabel;
    private final Label trueLabel;

    SwitchControl(StringConverter<Boolean> converter) {
        this.getStyleClass().add((Object)"switch-control");
        this.falseLabel = new CustomLabel(converter.toString((Object)Boolean.FALSE));
        this.falseLabel.getStyleClass().add((Object)"false");
        this.falseLabel.visibleProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.value));
        AnchorPane.setTopAnchor((Node)this.falseLabel, (Double)ZERO);
        AnchorPane.setRightAnchor((Node)this.falseLabel, (Double)GAP);
        AnchorPane.setBottomAnchor((Node)this.falseLabel, (Double)ZERO);
        AnchorPane.setLeftAnchor((Node)this.falseLabel, (Double)ZERO);
        this.trueLabel = new CustomLabel(converter.toString((Object)Boolean.TRUE));
        this.trueLabel.getStyleClass().add((Object)"true");
        this.trueLabel.visibleProperty().bind((ObservableValue)this.value);
        AnchorPane.setTopAnchor((Node)this.trueLabel, (Double)ZERO);
        AnchorPane.setRightAnchor((Node)this.trueLabel, (Double)ZERO);
        AnchorPane.setBottomAnchor((Node)this.trueLabel, (Double)ZERO);
        AnchorPane.setLeftAnchor((Node)this.trueLabel, (Double)GAP);
        this.getChildren().addAll((Object[])new Node[]{this.falseLabel, this.trueLabel});
        this.setOnMouseClicked(evt -> this.value.set(!this.value.get()));
    }

    void setConverter(StringConverter<Boolean> converter) {
        this.falseLabel.setText(converter.toString((Object)Boolean.FALSE));
        this.trueLabel.setText(converter.toString((Object)Boolean.TRUE));
    }
}

