/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.popup;

import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomToggleButton;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class TripleValueWidget
extends StackPane
implements HasViewState,
HasValue<Boolean> {
    private final ObjectProperty<Boolean> value = new SimpleObjectProperty();
    private final boolean compactMode;
    private final ViewState viewState = new ViewState();
    private StringConverter<Boolean> converter = StandardRenderers.BOOLEAN.createStatefulConverter(this.viewState::isImmutable);
    private Label readonlyLabel;
    private CustomToggleButton nullButton;
    private CustomToggleButton falseButton;
    private CustomToggleButton trueButton;
    private ComboBoxWidget<Boolean> comboBox;

    public TripleValueWidget(boolean compact, boolean ro) {
        this.compactMode = compact;
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"triple-value-widget", "simple-widget"});
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.value.addListener((obj, oldValue, newValue) -> this.renderValue());
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    @Override
    public ObjectProperty<Boolean> valueProperty() {
        return this.value;
    }

    public Boolean getValue() {
        return (Boolean)this.value.get();
    }

    public void setValue(Boolean val) {
        this.value.set((Object)val);
    }

    public void setConverter(StringConverter<Boolean> val) {
        this.converter = Objects.requireNonNull(val);
        if (this.comboBox != null) {
            this.comboBox.setConverter(this.converter);
        } else if (this.nullButton != null) {
            this.nullButton.setText(this.converter.toString(null));
            this.falseButton.setText(this.converter.toString((Object)Boolean.FALSE));
            this.trueButton.setText(this.converter.toString((Object)Boolean.TRUE));
        }
        this.renderValue();
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            this.comboBox = null;
            this.nullButton = null;
            this.falseButton = null;
            this.trueButton = null;
            if (this.readonlyLabel == null) {
                this.readonlyLabel = new CustomLabel();
                this.readonlyLabel.getStyleClass().add((Object)"value-label");
                this.getChildren().setAll((Object[])new Node[]{this.readonlyLabel});
            }
        } else {
            this.readonlyLabel = null;
            if (this.compactMode) {
                if (this.comboBox == null) {
                    this.comboBox = new ComboBoxWidget(false);
                    this.comboBox.setConverter(this.converter);
                    this.comboBox.setItemsSupplier(Suppliers.TRUE_FALSE);
                    this.comboBox.valueProperty().addListener((s, o, n) -> this.value.set(n));
                    this.getChildren().setAll((Object[])new Node[]{this.comboBox});
                }
            } else if (this.nullButton == null) {
                GridPane buttonsPane = new GridPane();
                ToggleGroup toggleGroup = new ToggleGroup();
                toggleGroup.selectedToggleProperty().addListener((s, o, n) -> {
                    if (this.falseButton.isSelected()) {
                        this.value.set((Object)Boolean.FALSE);
                        this.trueButton.pseudoClassStateChanged(CustomToggleButton.TO_THE_LEFT_FROM_SELECTED, true);
                    } else if (this.trueButton.isSelected()) {
                        this.value.set((Object)Boolean.TRUE);
                        this.nullButton.pseudoClassStateChanged(CustomToggleButton.TO_THE_LEFT_FROM_SELECTED, true);
                    } else {
                        this.value.set(null);
                    }
                    this.pseudoClassStateChanged(Styles.EMPTY_PSEUDOCLASS, this.value.get() == null);
                });
                this.nullButton = new CustomToggleButton(this.converter.toString(null));
                this.nullButton.setMaxWidth(Double.MAX_VALUE);
                this.nullButton.setToggleGroup(toggleGroup);
                this.nullButton.getStyleClass().add((Object)"left-button");
                this.falseButton = new CustomToggleButton(this.converter.toString((Object)Boolean.FALSE));
                this.falseButton.setMaxWidth(Double.MAX_VALUE);
                this.falseButton.setToggleGroup(toggleGroup);
                this.falseButton.getStyleClass().add((Object)"right-button");
                this.trueButton = new CustomToggleButton(this.converter.toString((Object)Boolean.TRUE));
                this.trueButton.setMaxWidth(Double.MAX_VALUE);
                this.trueButton.setToggleGroup(toggleGroup);
                this.trueButton.hoverProperty().addListener((obj, o, n) -> this.nullButton.pseudoClassStateChanged(CustomToggleButton.TO_THE_LEFT_FROM_HOVER, n != false && !this.trueButton.isSelected()));
                this.falseButton.hoverProperty().addListener((obj, o, n) -> this.trueButton.pseudoClassStateChanged(CustomToggleButton.TO_THE_LEFT_FROM_HOVER, n != false && !this.falseButton.isSelected()));
                for (int i = 0; i < 3; ++i) {
                    ColumnConstraints cc = new ColumnConstraints();
                    cc.setPercentWidth(33.333);
                    buttonsPane.getColumnConstraints().add((Object)cc);
                }
                buttonsPane.addRow(0, new Node[]{this.nullButton, this.trueButton, this.falseButton});
                this.getChildren().setAll((Object[])new Node[]{buttonsPane});
            }
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
        this.renderValue();
    }

    private void renderValue() {
        Boolean val = (Boolean)this.value.get();
        this.pseudoClassStateChanged(Styles.HIGLIGHTED_PSEUDOCLASS, val != null && val != false);
        if (this.readonlyLabel != null) {
            this.readonlyLabel.setText(this.converter.toString((Object)val));
        } else if (this.comboBox != null) {
            this.comboBox.setValue(val);
        } else if (val == null) {
            this.nullButton.setSelected(true);
        } else if (!val.booleanValue()) {
            this.falseButton.setSelected(true);
        } else {
            this.trueButton.setSelected(true);
        }
    }
}

