/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent;

import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor.EditorConfig;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.common.model.system.ContentType;
import java.util.List;
import javafx.scene.Node;
import javafx.stage.FileChooser;

public interface RichContentHandler
extends RegistryItem<RichContentHandler> {
    public static final RegistryItemType<RichContentHandler> TYPE = new RegistryItemType("RICH-CONTENT-HANDLER");

    public static RichContentHandler forId(String id) {
        return ClientRegistry.get().allOf(TYPE).get(id);
    }

    public static RichContentHandler getFor(ContentType contentType) {
        if (contentType == null) {
            return null;
        }
        for (RichContentHandler handler : ClientRegistry.get().allOf(TYPE).values()) {
            if (!handler.isAwareOf(contentType)) continue;
            return handler;
        }
        return null;
    }

    public static ContentType guessContentType(String fileName) {
        if (fileName != null) {
            for (RichContentHandler handler : ClientRegistry.get().allOf(TYPE).values()) {
                ContentType result = handler.detectContentType(fileName);
                if (result == null) continue;
                return result;
            }
        }
        return ContentType.BINARY;
    }

    @Override
    default public RegistryItemType<RichContentHandler> getType() {
        return TYPE;
    }

    public boolean isAwareOf(ContentType var1);

    public <E extends Node> E createEditor(ContentType var1, EditorConfig var2);

    public List<FileChooser.ExtensionFilter> getExtensionFilters(ContentType var1);

    public ContentType detectContentType(String var1);
}

