/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichContentHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.StandardRichContentHandlers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor.EditorConfig;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor.RichContentEditor;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;

public class RichContentWidget
extends BorderPane
implements HasViewState {
    private final ComboBoxWidget<ContentType> contentTypeWidget;
    private final HyperlinkWidget clearWidget;
    private final HyperlinkWidget importWidget;
    private final HyperlinkWidget exportWidget;
    private final HyperlinkWidget openWidget;
    private final Label placeholder;
    protected Supplier<String> fileNameSupplier;
    private RichContentHandler contentHandler;
    private RichContentEditor contentEditor;
    private final ViewState viewState = new ViewState();
    private StackPane dragPane;
    private Label dragLabel;
    private boolean fixedContentType;
    private Consumer<File> fileSelectionListener;

    public RichContentWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().add((Object)"rich-content-widget");
        this.contentTypeWidget = new ComboBoxWidget(ro);
        this.contentTypeWidget.setItemsSupplier(Suppliers.createEnumSupplier(ContentType.class));
        this.contentTypeWidget.valueProperty().addListener((src, o, n) -> this.applyContentType((ContentType)n));
        this.contentTypeWidget.guessPrefWidth();
        this.clearWidget = new HyperlinkWidget();
        this.clearWidget.setText(Messages.General_Clean);
        UiUtil.setTooltip((Node)this.clearWidget, Messages.General_Delete_data);
        this.clearWidget.setOnAction(evt -> this.doClear());
        this.importWidget = new HyperlinkWidget();
        this.importWidget.setText(Messages.General_Import);
        UiUtil.setTooltip((Node)this.importWidget, Messages.General_Import_data_from_file);
        this.importWidget.setOnAction(evt -> this.doImport());
        this.exportWidget = new HyperlinkWidget();
        this.exportWidget.setText(Messages.General_Export);
        UiUtil.setTooltip((Node)this.exportWidget, Messages.General_Export_data_to_file);
        this.exportWidget.setOnAction(evt -> this.doExport());
        this.openWidget = new HyperlinkWidget();
        this.openWidget.setText(Messages.General_Open);
        UiUtil.setTooltip((Node)this.openWidget, Messages.General_Open_file_in_view_or_edit_program);
        this.openWidget.setOnAction(evt -> this.doOpen());
        GridPane pane = new GridPane();
        pane.getStyleClass().add((Object)"selector-pane");
        this.dragLabel = new Label();
        this.dragPane = new StackPane(new Node[]{this.dragLabel});
        this.dragPane.getStyleClass().add((Object)"drag-pane");
        GridPane.setHgrow((Node)this.dragPane, (Priority)Priority.ALWAYS);
        pane.addRow(0, new Node[]{new Label(Messages.General_Content_type), this.contentTypeWidget, this.dragPane, this.clearWidget, this.importWidget, this.exportWidget, this.openWidget});
        this.setTop((Node)pane);
        this.dragPane.setOnDragDetected(evt -> this.handleDragStart((MouseEvent)evt));
        this.placeholder = new Label(Messages.General_No_data);
        this.setCenter((Node)this.placeholder);
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
        this.setOnDragOver(evt -> {
            evt.consume();
            if (this.viewState.isImmutable()) {
                return;
            }
            if (evt.getDragboard().hasFiles()) {
                evt.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
        });
        this.setOnDragDropped(evt -> {
            List files;
            evt.consume();
            if (this.viewState.isImmutable()) {
                return;
            }
            if (evt.getDragboard().hasFiles() && !(files = evt.getDragboard().getFiles()).isEmpty()) {
                this.readFile((File)files.get(0));
            }
        });
        UiUtil.configureDnDHighlighting((Node)this, evt -> {
            if (this.viewState.isImmutable()) {
                return false;
            }
            return evt.getDragboard().hasFiles();
        });
    }

    private void handleDragStart(MouseEvent evt) {
        try {
            File file = this.getExternalFile();
            if (file == null) {
                return;
            }
            byte[] data = this.contentEditor.getData();
            FxUtil.saveToFile(file, data);
            file.deleteOnExit();
            Dragboard db = this.dragPane.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
            db.setContent(Collections.singletonMap(DataFormat.FILES, Collections.singletonList(file)));
            evt.consume();
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
    }

    public void setFieldName(String value) {
    }

    public void setFixedContentType(boolean value) {
        this.fixedContentType = value;
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public RichData getData() {
        ContentType contentType = this.contentTypeWidget.getValue();
        if (contentType == null) {
            return null;
        }
        RichData result = new RichData();
        result.setContentType(contentType);
        if (this.contentEditor != null) {
            result.setContent(this.contentEditor.getData());
        }
        return result;
    }

    public void setData(RichData value) {
        if (value == null || value.getContentType() == null) {
            this.contentTypeWidget.setValue(null);
            this.contentHandler = null;
            this.contentEditor = null;
        } else {
            this.contentTypeWidget.setValue(value.getContentType());
            if (this.contentEditor != null) {
                this.contentEditor.setData(value.getContent());
            }
        }
        this.updateState();
    }

    public void setFileNameSupplier(Supplier<String> value) {
        this.fileNameSupplier = value == null ? null : () -> {
            String result = (String)value.get();
            if (result == null) {
                return null;
            }
            if (result.length() > 100) {
                int p = result.indexOf(46);
                if (p <= 0) {
                    result = result.substring(0, 100);
                } else if (p > 100) {
                    result = result.substring(0, 100) + result.substring(p);
                }
            }
            return result.replace('?', '_').replace('\\', '_').replace('/', '_').replace(':', '_');
        };
    }

    public void setFileSelectionListener(Consumer<File> value) {
        this.fileSelectionListener = value;
    }

    private void updateState() {
        boolean empty = this.contentEditor == null || this.contentEditor.getData() == null;
        this.pseudoClassStateChanged(Styles.EMPTY_PSEUDOCLASS, empty);
        if (empty) {
            Tooltip.uninstall((Node)this.dragPane, null);
        } else {
            Tooltip.install((Node)this.dragPane, (Tooltip)new Tooltip(Messages.General_Pull_to_move_data));
            ContentType contentType = this.contentTypeWidget.getValue();
            if (contentType == null) {
                contentType = ContentType.BINARY;
            }
            this.dragLabel.setText(Messages.General_Move + " \"" + contentType + '\"');
        }
        this.contentTypeWidget.getViewState().setState(this.viewState.getState());
        if (this.fixedContentType) {
            this.contentTypeWidget.getViewState().setNotEditable(true);
        }
        boolean editingDisabled = this.viewState.isImmutable();
        this.importWidget.setDisable(editingDisabled);
        if (this.contentHandler == null || this.contentEditor == null) {
            this.exportWidget.setDisable(true);
            this.openWidget.setDisable(true);
            this.clearWidget.setDisable(true);
            return;
        }
        this.contentEditor.setReadonly(editingDisabled);
        this.exportWidget.setDisable(this.contentEditor.getData() == null);
        this.openWidget.setDisable(this.contentTypeWidget.getValue() == null || this.contentEditor.getData() == null);
        this.clearWidget.setDisable(editingDisabled);
    }

    private void applyContentType(ContentType contentType) {
        if (contentType == null) {
            this.contentHandler = null;
            this.contentEditor = null;
            this.placeholder.setText(Messages.General_No_data);
            this.setCenter((Node)this.placeholder);
        } else {
            this.contentHandler = RichContentHandler.getFor(contentType);
            if (this.contentHandler == null) {
                this.contentHandler = StandardRichContentHandlers.BINARY;
            }
            this.contentEditor = (RichContentEditor)this.contentHandler.createEditor(contentType, new EditorConfig(){

                @Override
                public Supplier<String> getFileNameSupplier() {
                    return RichContentWidget.this.fileNameSupplier;
                }
            });
            this.setCenter((Node)this.contentEditor);
        }
        this.updateState();
    }

    private void doClear() {
        if (this.contentEditor != null) {
            this.contentEditor.setData(null);
        }
    }

    private void doImport() {
        FileChooser fc = new FileChooser();
        fc.setTitle(Messages.General_Choose_file_for_import);
        if (this.contentHandler != null) {
            fc.getExtensionFilters().addAll(this.contentHandler.getExtensionFilters(this.contentTypeWidget.getValue()));
        }
        fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(Messages.General_All_file_types, new String[]{"*.*"}));
        File dir = ClientSettings.get().getFileChooserDirectory();
        if (UiUtil.isFileValid(dir) && dir.isDirectory()) {
            fc.setInitialDirectory(dir);
        } else {
            fc.setInitialDirectory(Environment.getDataFolder());
        }
        File file = fc.showOpenDialog(this.getScene().getWindow());
        if (file == null || !file.isFile()) {
            return;
        }
        ClientSettings.get().setFileChooserDirectory(file.getParentFile());
        ClientSettings.get().save();
        this.readFile(file);
    }

    private void readFile(File file) {
        this.contentTypeWidget.setValue(RichContentHandler.guessContentType(file.getName()));
        try {
            this.contentEditor.setData(Files.readAllBytes(file.toPath()));
        }
        catch (IOException ioe) {
            ErrorHandler.handle(ioe);
        }
        if (this.fileSelectionListener != null) {
            this.fileSelectionListener.accept(file);
        }
    }

    private void doExport() {
        File dir;
        if (this.contentHandler == null) {
            return;
        }
        FileChooser fc = new FileChooser();
        fc.setTitle(Messages.General_Choose_file_for_export_or_enter_new_file_name2);
        fc.getExtensionFilters().addAll(this.contentHandler.getExtensionFilters(this.contentTypeWidget.getValue()));
        fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(Messages.General_All_file_types, new String[]{"*.*"}));
        ContentType contentType = this.contentTypeWidget.getValue();
        if (contentType != null) {
            String ext = this.contentHandler.getExtensionFilters(contentType).stream().findFirst().map(filter -> (String)filter.getExtensions().get(0)).orElse(null);
            fc.setInitialFileName(this.guessFileName(ext));
        }
        if (UiUtil.isFileValid(dir = ClientSettings.get().getFileChooserDirectory()) && dir.isDirectory()) {
            fc.setInitialDirectory(dir);
        } else {
            fc.setInitialDirectory(Environment.getDataFolder());
        }
        File file = fc.showSaveDialog(this.getScene().getWindow());
        if (file == null) {
            return;
        }
        ClientSettings.get().setFileChooserDirectory(file.getParentFile());
        ClientSettings.get().save();
        if (file.isFile()) {
            Dialog.confirm((Node)this, Messages.General_File_already_exists, null, Messages.General_Overwrite, () -> this.writeData(file), null);
        } else {
            this.writeData(file);
        }
    }

    private void doOpen() {
        File file;
        if (!Desktop.isDesktopSupported()) {
            Notifications.get().showFlashNotification(Messages.General_View_not_available, Messages.General_Use_export_to_file);
            return;
        }
        try {
            file = this.getExternalFile();
        }
        catch (IOException e) {
            ErrorHandler.handle(e);
            return;
        }
        if (file != null) {
            byte[] data = this.contentEditor.getData();
            Notifications.get().submitTask(() -> {
                FxUtil.saveToFile(file, data);
                FxUtil.openFile(file);
                file.deleteOnExit();
            }, Messages.General_Openning_file);
        }
    }

    private void writeData(File file) {
        FxUtil.saveToFile(file, this.contentEditor.getData());
    }

    private File getExternalFile() throws IOException {
        ContentType contentType = this.contentTypeWidget.getValue();
        if (contentType == null || this.contentHandler == null || this.contentEditor.getData() == null) {
            return null;
        }
        String ext = this.contentHandler.getExtensionFilters(contentType).stream().findFirst().map(filter -> (String)filter.getExtensions().get(0)).orElse(null);
        if (ext == null) {
            Notifications.get().showFlashNotification(Messages.General_Cant_identify_file_type, null);
            return null;
        }
        String fileName = this.guessFileName(ext);
        if (TextUtil.isBlank((String)fileName)) {
            return File.createTempFile("xtrip-doc-", this.guessExt(ext));
        }
        return new File(new File(System.getProperty("java.io.tmpdir")), fileName);
    }

    private String guessFileName(String ext) {
        String result = null;
        if (this.fileNameSupplier != null) {
            result = this.fileNameSupplier.get();
        }
        if (TextUtil.isBlank((String)ext)) {
            return result;
        }
        int pos = ext.lastIndexOf(46);
        String extension = pos != -1 ? ext.substring(pos + 1) : ext;
        extension = extension.toLowerCase();
        if (!(TextUtil.isBlank((String)result) || result.toLowerCase().endsWith(extension) || extension.endsWith("*"))) {
            result = result + '.' + extension;
        }
        return result;
    }

    private String guessExt(String ext) {
        String result;
        if (TextUtil.isBlank((String)ext)) {
            return null;
        }
        int p = ext.indexOf(46);
        String string = result = p != -1 ? ext.substring(p + 1) : ext;
        if ("*".equals(result)) {
            return null;
        }
        return '.' + result;
    }
}

