/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.ExtensionsData;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichContentHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor.BinaryContentEditor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor.EditorConfig;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor.HtmlContentEditor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor.ImageContentEditor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor.JasperDesignContentEditor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor.JasperPrintContentEditor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor.PdfContentEditor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor.PlainTextContentEditor;
import com.gridnine.xtrip.common.model.system.ContentType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javafx.stage.FileChooser;

public enum StandardRichContentHandlers implements RichContentHandler
{
    BINARY(new ExtensionsData[]{new ExtensionsData(ContentType.BINARY, Messages.General_All_files, "*.*"), new ExtensionsData(ContentType.CALENDAR, Messages.General_Calendar_files, "*.cldr"), new ExtensionsData(ContentType.EXCEL, Messages.General_Tables_MS_Excel, "*.xls"), new ExtensionsData(ContentType.EXCEL_2007, Messages.General_Tables_MS_Excel_2007, "*.xlsx"), new ExtensionsData(ContentType.WORD, Messages.General_Documents_MS_Word, "*.doc"), new ExtensionsData(ContentType.WORD_2007, Messages.General_Documents_MS_Word_2007, "*.docx"), new ExtensionsData(ContentType.DBF, Messages.General_Data_formats_DBF, "*.dbf"), new ExtensionsData(ContentType.JASPERDESIGN, Messages.General_Template_JasperReports, "*.jrxml")}){

        public BinaryContentEditor createEditor(ContentType contentType, EditorConfig config) {
            return new BinaryContentEditor();
        }
    }
    ,
    PLAIN_TEXT(new ExtensionsData[]{new ExtensionsData(ContentType.TEXT, Messages.General_Text_files, "*.txt"), new ExtensionsData(ContentType.JSON, Messages.General_Files_JSON, "*.json"), new ExtensionsData(ContentType.GROOVY, Messages.General_Files_GROOVY, "*.groovy"), new ExtensionsData(ContentType.CSS, Messages.General_Files_CSS, "*.css"), new ExtensionsData(ContentType.XML, Messages.General_Files_XML, "*.xml", "*.xsd", "*.xsl", "*.xslt")}){

        public PlainTextContentEditor createEditor(ContentType contentType, EditorConfig config) {
            return new PlainTextContentEditor();
        }
    }
    ,
    IMAGE(new ExtensionsData[]{new ExtensionsData(ContentType.GIF, Messages.General_Images_format_GIF, "*.gif"), new ExtensionsData(ContentType.JPEG, Messages.General_Images_format_JPEG, "*.jpeg", "*.jpg"), new ExtensionsData(ContentType.PNG, Messages.General_Images_format_PNG, "*.png")}){

        public ImageContentEditor createEditor(ContentType contentType, EditorConfig config) {
            return new ImageContentEditor();
        }
    }
    ,
    HTML(new ExtensionsData[]{new ExtensionsData(ContentType.HTML, Messages.General_Files_HTML, "*.html", "*.htm")}){

        public HtmlContentEditor createEditor(ContentType contentType, EditorConfig config) {
            return new HtmlContentEditor();
        }
    }
    ,
    JASPER_PRINT(new ExtensionsData[]{new ExtensionsData(ContentType.JASPERPRINT, Messages.General_Print_form_JasperReports, "*.jasper")}){

        public JasperPrintContentEditor createEditor(ContentType contentType, EditorConfig config) {
            return new JasperPrintContentEditor(config);
        }
    }
    ,
    JASPER_DESIGN(new ExtensionsData[]{new ExtensionsData(ContentType.JASPERDESIGN, Messages.General_Print_form_JasperDesign, "*.jrxml")}){

        public JasperDesignContentEditor createEditor(ContentType contentType, EditorConfig config) {
            return new JasperDesignContentEditor(config);
        }
    }
    ,
    PDF(new ExtensionsData[]{new ExtensionsData(ContentType.PDF, Messages.General_Documents_PDF, "*.pdf")}){

        public PdfContentEditor createEditor(ContentType contentType, EditorConfig config) {
            return new PdfContentEditor();
        }
    };

    private final Map<ContentType, ExtensionsData> mappingData = new EnumMap<ContentType, ExtensionsData>(ContentType.class);

    private StandardRichContentHandlers(ExtensionsData ... data) {
        for (ExtensionsData dt : data) {
            this.mappingData.put(dt.contentType, dt);
        }
    }

    @Override
    public String getId() {
        return this.name().toLowerCase();
    }

    @Override
    public boolean isAwareOf(ContentType contentType) {
        return this.mappingData.containsKey(contentType);
    }

    @Override
    public List<FileChooser.ExtensionFilter> getExtensionFilters(ContentType contentType) {
        ExtensionsData extensionsData = this.mappingData.get(contentType);
        return extensionsData == null ? Collections.emptyList() : Collections.singletonList(new FileChooser.ExtensionFilter(extensionsData.name, new ArrayList<String>(extensionsData.extensions)));
    }

    @Override
    public ContentType detectContentType(String fileName) {
        if (fileName == null) {
            return null;
        }
        String str = fileName.toLowerCase();
        for (ExtensionsData extensionsData : this.mappingData.values()) {
            for (String ext : extensionsData.extensions) {
                if (ext.endsWith("*")) continue;
                int p = ext.lastIndexOf(42);
                if (p != -1) {
                    ext = ext.substring(p + 1);
                }
                if (!str.endsWith(ext)) continue;
                return extensionsData.contentType;
            }
        }
        return null;
    }
}

