/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor.EditorConfig;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor.RichContentEditor;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;

abstract class BaseJasperContentEditor
extends BorderPane
implements RichContentEditor {
    private byte[] data;
    private final EditorConfig editorConfig;
    private boolean needRendering;
    private static final Map<FileChooser.ExtensionFilter, Converter> CONVERTERS = new LinkedHashMap<FileChooser.ExtensionFilter, Converter>();

    protected BaseJasperContentEditor(EditorConfig config) {
        this.getStyleClass().add((Object)"jasper-content-editor");
        this.editorConfig = config;
        this.sceneProperty().addListener((s, o, n) -> {
            if (n != null) {
                this.render();
            }
        });
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public void setData(byte[] value) {
        this.data = value;
        if (this.data == null || this.data.length == 0) {
            this.needRendering = false;
            this.setTop(null);
            this.setCenter((Node)new Label(Messages.General_No_data));
            return;
        }
        this.needRendering = true;
        if (this.getScene() != null) {
            this.render();
        }
    }

    private void render() {
        if (!this.needRendering) {
            return;
        }
        this.needRendering = false;
        this.setTop(null);
        this.setCenter((Node)new Label(Messages.General_Draw_doc));
        Notifications.get().submitTask(() -> {
            JasperPrint jasperPrint = this.getJasperPrint();
            ImageView iv = this.renderPage(jasperPrint, 0);
            FxUtil.submitToFxThread(() -> {
                this.setTop(this.createToolsPane(jasperPrint));
                this.setCenter((Node)iv);
            });
        }, Messages.General_Draw_doc);
    }

    private ImageView renderPage(JasperPrint jasperPrint, int pageNumber) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Image image = JasperPrintManager.printPageToImage((JasperPrint)jasperPrint, (int)pageNumber, (float)(1.6f + (float)ClientSettings.get().getScaleFactor() * 0.1f));
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 10);
        bi.createGraphics().drawImage(image, 0, 0, null);
        ImageIO.write((RenderedImage)bi, "png", baos);
        baos.flush();
        ImageView iv = new ImageView(new javafx.scene.image.Image((InputStream)new ByteArrayInputStream(baos.toByteArray())));
        BorderPane.setAlignment((Node)iv, (Pos)Pos.TOP_LEFT);
        return iv;
    }

    protected abstract JasperPrint getJasperPrint() throws Exception;

    private Node createToolsPane(JasperPrint jasperPrint) {
        ArrayList<HasViewState> widgets = new ArrayList<HasViewState>();
        HasViewState widget = new HyperlinkWidget();
        widget.setText(Messages.General_Open_as_pdf);
        widget.setOnAction(evt -> this.doOpen());
        widgets.add(widget);
        widget = new HyperlinkWidget();
        widget.setText(Messages.General_Print);
        widget.setOnAction(evt -> this.doPrint());
        widgets.add(widget);
        widget = new HyperlinkWidget();
        widget.setText(Messages.General_Export_to_file);
        widget.setOnAction(evt -> this.doExport());
        widgets.add(widget);
        widget = new StackPane(new Node[]{new Label(Messages.General_Move_pdf)});
        widget.getStyleClass().add((Object)"drag-pane");
        HBox.setHgrow((Node)widget, (Priority)Priority.ALWAYS);
        Tooltip.install((Node)widget, (Tooltip)new Tooltip(Messages.General_Pull_to_move_pdf));
        widget.setOnDragDetected(arg_0 -> this.lambda$createToolsPane$6((StackPane)widget, arg_0));
        widgets.add(widget);
        widget = new ComboBoxWidget(false);
        ((ComboBoxWidget)widget).setItemsSupplier(() -> {
            ArrayList<Integer> pages = new ArrayList<Integer>();
            for (int n = 0; n < jasperPrint.getPages().size(); ++n) {
                pages.add(n + 1);
            }
            return pages;
        });
        ((ComboBoxWidget)widget).setValue(1);
        ((ComboBoxWidget)widget).valueProperty().addListener((property, oldValue, newValue) -> {
            this.setCenter((Node)new Label(Messages.General_Draw_doc));
            Notifications.get().submitTask(() -> {
                ImageView iv = this.renderPage(jasperPrint, newValue - 1);
                FxUtil.submitToFxThread(() -> this.setCenter((Node)iv));
            }, Messages.General_Draw_doc);
        });
        ((ComboBoxWidget)widget).setNoNulls(true);
        ((ComboBoxWidget)widget).setSortItems(false);
        ((ComboBoxWidget)widget).setConverter(new StringConverter<Integer>(){

            public String toString(Integer object) {
                return Messages.General_Page + " " + object;
            }

            public Integer fromString(String string) {
                return null;
            }
        });
        ((ComboBoxWidget)widget).guessPrefWidth();
        widgets.add(widget);
        HBox result = new HBox();
        result.getChildren().addAll(widgets);
        return result;
    }

    private String guessFileName() {
        String result;
        Supplier<String> fileNameSupplier = this.editorConfig.getFileNameSupplier();
        String string = result = fileNameSupplier != null ? fileNameSupplier.get() : null;
        if (!TextUtil.isBlank((String)result) && !result.toLowerCase().endsWith(".pdf")) {
            result = result + ".pdf";
        }
        return result;
    }

    private void handleDragStart(Node node, MouseEvent evt) {
        try {
            String fileName = this.guessFileName();
            File file = TextUtil.isBlank((String)fileName) ? File.createTempFile("xtrip-doc-", ".pdf") : new File(new File(System.getProperty("java.io.tmpdir")), fileName);
            FxUtil.saveToFile(file, JasperUtil.convertToPdf((JasperPrint)this.getJasperPrint()));
            file.deleteOnExit();
            Dragboard db = node.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
            db.setContent(Collections.singletonMap(DataFormat.FILES, Collections.singletonList(file)));
            evt.consume();
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
    }

    @Override
    public void setReadonly(boolean value) {
    }

    @Override
    public boolean isDataChanged() {
        return false;
    }

    private void doOpen() {
        if (!Desktop.isDesktopSupported()) {
            Notifications.get().showFlashNotification(Messages.General_View_not_available, Messages.General_Use_export_to_file);
            return;
        }
        Notifications.get().submitTask(() -> {
            File file = File.createTempFile("xtrip-doc-", ".pdf");
            FxUtil.saveToFile(file, JasperUtil.convertToPdf((JasperPrint)this.getJasperPrint()));
            FxUtil.openFile(file);
            file.deleteOnExit();
        }, Messages.General_Openning_doc_for_viewing);
    }

    private void doPrint() {
        try {
            JasperPrintManager.printReport((JasperPrint)this.getJasperPrint(), (boolean)true);
        }
        catch (JRException jre) {
            if ("No printer available.".equals(jre.getMessage())) {
                Notifications.get().showFlashNotification(Messages.No_printers_available, null);
            } else {
                Throwable error = jre.getCause();
                if (error == null) {
                    error = jre;
                }
                ErrorHandler.handle((Throwable)Xeption.forEndUser((String)Messages.Printing_Failed(error.getMessage()), (Throwable)jre, (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
    }

    private void doExport() {
        FileChooser fc = new FileChooser();
        fc.setTitle(Messages.General_Choose_file_for_export_or_enter_new_file_name);
        fc.getExtensionFilters().addAll(CONVERTERS.keySet());
        fc.setSelectedExtensionFilter(CONVERTERS.keySet().iterator().next());
        File dir = ClientSettings.get().getFileChooserDirectory();
        if (UiUtil.isFileValid(dir) && dir.isDirectory()) {
            fc.setInitialDirectory(dir);
        } else {
            fc.setInitialDirectory(Environment.getDataFolder());
        }
        fc.setInitialFileName(this.guessFileName());
        File file = fc.showSaveDialog(this.getScene().getWindow());
        if (file == null) {
            return;
        }
        ClientSettings.get().setFileChooserDirectory(file.getParentFile());
        ClientSettings.get().save();
        if (file.isFile()) {
            Dialog.confirm((Node)this, Messages.General_File_already_exists, null, Messages.General_Overwrite, () -> this.exportTo(file, CONVERTERS.get(fc.getSelectedExtensionFilter())), null);
        } else {
            this.exportTo(file, CONVERTERS.get(fc.getSelectedExtensionFilter()));
        }
    }

    private void exportTo(File file, Converter converter) {
        Notifications.get().submitTask(() -> {
            FxUtil.saveToFile(file, converter.apply(this.getJasperPrint()));
            Notifications.get().showStaticNotification(Messages.General_Doc_exported_to_file + file.getName(), file.getAbsolutePath());
        }, Messages.General_Exporting_doc_to_file + file.getName());
    }

    private /* synthetic */ void lambda$createToolsPane$6(StackPane widget, MouseEvent evt) {
        this.handleDragStart((Node)widget, evt);
    }

    static {
        CONVERTERS.put(new FileChooser.ExtensionFilter(Messages.General_Documents_PDF, new String[]{"*.pdf"}), JasperUtil::convertToPdf);
        CONVERTERS.put(new FileChooser.ExtensionFilter(Messages.General_Documents_MS_Excel_2007, new String[]{"*.xlsx"}), JasperUtil::convertToExcelX);
        CONVERTERS.put(new FileChooser.ExtensionFilter(Messages.General_Documents_MS_Word_2007, new String[]{"*.docx"}), JasperUtil::convertToDocX);
        CONVERTERS.put(new FileChooser.ExtensionFilter(Messages.General_Documents_RTF, new String[]{"*.rtf"}), JasperUtil::convertToRtf);
    }

    @FunctionalInterface
    private static interface Converter {
        public byte[] apply(JasperPrint var1) throws Exception;
    }
}

