/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor.RichContentEditor;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.nio.charset.StandardCharsets;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.web.HTMLEditor;
import javafx.scene.web.WebView;

public class HtmlContentEditor
extends StackPane
implements RichContentEditor {
    private WebView viewer;
    private byte[] data;
    private boolean dataChanged;
    private boolean readonly;
    private ControlsPane controlsPanel;

    public HtmlContentEditor() {
        this.getStyleClass().add((Object)"html-content-editor");
        this.sceneProperty().addListener((s, o, n) -> this.updateState());
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public void setData(byte[] value) {
        this.data = value;
        this.dataChanged = false;
        this.updateState();
    }

    @Override
    public void setReadonly(boolean value) {
        this.readonly = value;
        this.updateState();
    }

    @Override
    public boolean isDataChanged() {
        return !this.readonly && this.dataChanged;
    }

    private void updateState() {
        if (this.getScene() == null) {
            this.getChildren().clear();
            this.viewer = null;
            return;
        }
        if (this.data == null || this.data.length == 0) {
            if (this.isHover() && this.controlsPanel != null) {
                this.getChildren().setAll((Object[])new Node[]{this.controlsPanel});
            } else {
                this.getChildren().clear();
            }
            this.viewer = null;
        } else {
            try {
                if (this.viewer == null) {
                    this.viewer = new WebView();
                    this.viewer.setContextMenuEnabled(false);
                    this.getChildren().setAll((Object[])new Node[]{this.viewer});
                }
                this.viewer.getEngine().loadContent(new String(this.data, StandardCharsets.UTF_8));
            }
            catch (Throwable t) {
                ErrorHandler.LOG.error("failed rendering HTML", t);
                this.getChildren().setAll((Object[])new Node[]{new Label(Messages.HTML_rendering_error + '\n' + ErrorHandler.getMessage(t))});
                this.viewer = null;
            }
        }
        if (this.readonly) {
            if (this.controlsPanel != null) {
                this.getChildren().remove((Object)this.controlsPanel);
                this.controlsPanel = null;
            }
        } else {
            if (this.controlsPanel == null) {
                this.controlsPanel = new ControlsPane();
                StackPane.setAlignment((Node)this.controlsPanel, (Pos)Pos.TOP_RIGHT);
                StackPane.setMargin((Node)this.controlsPanel, (Insets)new Insets(0.0, 20.0, 0.0, 0.0));
                this.controlsPanel.setMaxHeight(Double.NEGATIVE_INFINITY);
                this.controlsPanel.setMinHeight(Double.NEGATIVE_INFINITY);
                this.controlsPanel.setMaxWidth(Double.NEGATIVE_INFINITY);
                this.controlsPanel.setPrefWidth(Double.NEGATIVE_INFINITY);
                this.controlsPanel.setPrefHeight(-1.0);
                UiUtil.setTooltip((Node)this.controlsPanel.addButton(ControlsPane.ButtonType.EDIT, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                    HTMLEditor editor = new HTMLEditor();
                    byte[] dt = this.getData();
                    if (dt != null && dt.length > 0) {
                        editor.setHtmlText(new String(dt, StandardCharsets.UTF_8));
                    }
                    new Dialog().setTitle(Messages.Html_editor_title).setBody((Node)editor).setExpandToParent(true).setIgnoreEnterKeyAndDoubleClick(true).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Html_editor_acceptButton, () -> {
                        byte[] newData;
                        String html = editor.getHtmlText();
                        if (TextUtil.isBlank((String)html)) {
                            newData = null;
                        } else {
                            if (html.startsWith("<html")) {
                                int p1 = html.indexOf("<body");
                                p1 = p1 != -1 ? ((p1 = html.indexOf(">", p1)) == -1 ? 0 : ++p1) : 0;
                                int p2 = html.lastIndexOf("</body>");
                                if (p2 == -1) {
                                    p2 = html.length();
                                }
                                html = html.substring(p1, p2);
                            }
                            newData = html.getBytes(StandardCharsets.UTF_8);
                        }
                        this.dataChanged = !MiscUtil.equals((Object)this.data, newData);
                        this.data = newData;
                        this.updateState();
                    }).show((Node)this);
                })), Messages.Html_editor_editTooltip);
                UiUtil.setTooltip((Node)this.controlsPanel.addButton(ControlsPane.ButtonType.EDIT_CODE, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                    TextAreaWidget editor = new TextAreaWidget(false);
                    editor.setMonospace(true);
                    editor.setNotExpandable(true);
                    byte[] dt = this.getData();
                    if (dt != null && dt.length > 0) {
                        editor.setValue(new String(dt, StandardCharsets.UTF_8));
                    }
                    new Dialog().setTitle(Messages.Html_editor_code_title).setBody((Node)editor).setExpandToParent(true).setIgnoreEnterKeyAndDoubleClick(true).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Html_editor_acceptButton, () -> {
                        String html = editor.getValue();
                        byte[] newData = TextUtil.isBlank((String)html) ? null : html.getBytes(StandardCharsets.UTF_8);
                        this.dataChanged = !MiscUtil.equals((Object)this.data, (Object)newData);
                        this.data = newData;
                        this.updateState();
                    }).show((Node)this);
                })), Messages.Html_editor_editCodeTooltip);
                UiUtil.setTooltip((Node)this.controlsPanel.addButton(ControlsPane.ButtonType.REMOVE, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                    if (this.data != null && this.data.length != 0) {
                        this.data = null;
                        this.dataChanged = true;
                        this.updateState();
                    }
                })), Messages.Html_editor_clearTooltip);
            }
            if (!this.getChildren().contains((Object)this.controlsPanel)) {
                this.getChildren().add((Object)this.controlsPanel);
            }
        }
    }
}

