/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import java.util.function.BiPredicate;

public class StandardTableWidgetCoordinator
implements BiPredicate<ControlsPane.ButtonType, Integer> {
    protected final TableWidget<?> widget;

    protected StandardTableWidgetCoordinator(TableWidget<?> tableWidget) {
        this.widget = tableWidget;
    }

    @Override
    public boolean test(ControlsPane.ButtonType buttonType, Integer rowNumber) {
        if (!this.widget.controlButtonsAvailability.test(buttonType)) {
            return false;
        }
        switch (buttonType) {
            case DOWN: {
                if (this.widget.getViewState().isImmutable()) {
                    return false;
                }
                return rowNumber != null && rowNumber < this.widget.getRowsCount() - 1;
            }
            case UP: {
                if (this.widget.getViewState().isImmutable()) {
                    return false;
                }
                return rowNumber != null && rowNumber > 0;
            }
            case REMOVE: {
                if (this.widget.getViewState().isImmutable()) {
                    return false;
                }
                return rowNumber != null;
            }
            case ADD: {
                return !this.widget.getViewState().isImmutable();
            }
        }
        return true;
    }
}

