/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.function.Function;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.ButtonBase;

public abstract class BaseActionWidgetColumn<M, N extends ButtonBase>
extends TableWidgetColumn<M, N> {
    private static final String MODEL_KEY = "model";
    private final Function<M, String> getter;
    private String defaultText;
    private EventHandler<ColumnActionEvent<M, N>> actionHandler;

    protected BaseActionWidgetColumn(Function<M, String> aGetter) {
        this.getter = aGetter;
    }

    public void setDefaultText(String value) {
        this.defaultText = value;
        this.applyToAllRows(widget -> widget.setText(this.defaultText));
    }

    public void setActionHandler(EventHandler<ColumnActionEvent<M, N>> handler) {
        this.actionHandler = handler;
    }

    @Override
    public N createNode() {
        N result = this.newNode();
        result.setOnAction(evt -> {
            if (this.actionHandler != null) {
                this.actionHandler.handle(new ColumnActionEvent<Object, ButtonBase>((ButtonBase)result, result.getProperties().get((Object)MODEL_KEY)));
            }
        });
        result.setText(this.defaultText);
        return result;
    }

    protected abstract N newNode();

    @Override
    public void readData(M model, N node) {
        String text = this.getter.apply(model);
        node.setText(TextUtil.isBlank((String)text) ? this.defaultText : text);
        node.getProperties().put((Object)MODEL_KEY, model);
    }

    @Override
    public void writeData(M model, N node) {
    }

    @Override
    public void setReadonly(N node, boolean readonly) {
    }

    @Override
    public void setAclNotEditable(N node) {
    }

    @Override
    public boolean isDataChanged(M model, N node) {
        return false;
    }

    public static class ColumnActionEvent<T, B extends ButtonBase>
    extends ActionEvent {
        private static final long serialVersionUID = 3734536301173396511L;
        private final T item;

        public ColumnActionEvent(B src, T gridItem) {
            super(src, Event.NULL_SOURCE_TARGET);
            this.item = gridItem;
        }

        public B getSource() {
            return (B)((ButtonBase)super.getSource());
        }

        public T getItem() {
            return this.item;
        }
    }
}

