/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.util.StringConverter;

public class BooleanValueWidgetColumn<M>
extends TableWidgetColumn<M, BooleanValueWidget> {
    private final Function<M, Boolean> getter;
    private final BiConsumer<M, Boolean> setter;
    private StringConverter<Boolean> converter = new StringConverter<Boolean>(){

        public String toString(Boolean object) {
            if (object == null) {
                return BooleanValueWidgetColumn.this.getOwner().getViewState().isReadonly() ? "\u2014" : UiUtil.NULL_TEXT;
            }
            return (String)StandardRenderers.BOOLEAN.apply(object);
        }

        public Boolean fromString(String string) {
            return null;
        }
    };

    public BooleanValueWidgetColumn(Function<M, Boolean> aGetter, BiConsumer<M, Boolean> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setConverter(StringConverter<Boolean> value) {
        this.converter = Objects.requireNonNull(value);
        this.applyToAllRows(widget -> widget.setConverter(this.converter));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public BooleanValueWidget createNode() {
        BooleanValueWidget result = new BooleanValueWidget(true, this.getOwner().getViewState().isReadonly());
        result.getViewState().setNotEditable(this.isNotEditable());
        result.setConverter(this.converter);
        return result;
    }

    @Override
    public void readData(M model, BooleanValueWidget node) {
        Boolean value = this.getter.apply(model);
        node.setValue(value == null ? false : value);
    }

    @Override
    public void writeData(M model, BooleanValueWidget node) {
        this.setter.accept(model, node.getValue());
    }

    @Override
    public void setReadonly(BooleanValueWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(BooleanValueWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, BooleanValueWidget node) {
        return !node.getViewState().isImmutable() && node.getValue() != this.getter.apply(model).booleanValue();
    }
}

