/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class CheckBoxWidgetColumn<M>
extends TableWidgetColumn<M, CheckBoxWidget> {
    private final Function<M, Boolean> getter;
    private final BiConsumer<M, Boolean> setter;
    private String text;

    public CheckBoxWidgetColumn(Function<M, Boolean> aGetter, BiConsumer<M, Boolean> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setText(String value) {
        this.text = value;
        this.applyToAllRows(widget -> widget.setText(this.text));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public CheckBoxWidget createNode() {
        CheckBoxWidget result = new CheckBoxWidget(this.getOwner().getViewState().isReadonly());
        result.getViewState().setNotEditable(this.isNotEditable());
        result.setText(this.text);
        return result;
    }

    @Override
    public void readData(M model, CheckBoxWidget node) {
        node.setSelected(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, CheckBoxWidget node) {
        this.setter.accept(model, node.isSelected());
    }

    @Override
    public void setReadonly(CheckBoxWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(CheckBoxWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, CheckBoxWidget node) {
        return !node.getViewState().isImmutable() && node.isSelected() != this.getter.apply(model).booleanValue();
    }
}

