/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class CustomWidgetColumn<M, I>
extends TableWidgetColumn<M, CustomWidget<I>> {
    private final Function<M, I> getter;
    private final Supplier<CustomWidget<I>> nodeSupplier;
    private Consumer<CustomWidget<I>> widgetConfigurator;

    public CustomWidgetColumn(Function<M, I> aGetter, Supplier<CustomWidget<I>> aNodeSupplier) {
        this.getter = aGetter;
        this.nodeSupplier = aNodeSupplier;
    }

    public void setWidgetConfigurator(Consumer<CustomWidget<I>> value) {
        this.widgetConfigurator = value;
        if (this.widgetConfigurator != null) {
            this.applyToAllRows(widget -> this.widgetConfigurator.accept((CustomWidget<I>)widget));
        }
    }

    @Override
    public CustomWidget<I> createNode() {
        CustomWidget<I> result = this.nodeSupplier.get();
        if (this.widgetConfigurator != null) {
            this.widgetConfigurator.accept(result);
        }
        return result;
    }

    @Override
    public void readData(M model, CustomWidget<I> node) {
        node.readData(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, CustomWidget<I> node) {
        node.writeData(this.getter.apply(model));
    }

    @Override
    public void setReadonly(CustomWidget<I> node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(CustomWidget<I> node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, CustomWidget<I> node) {
        return node.isDataChanged();
    }
}

